/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSIndeliveryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSIndelivery
implements Serializable {
    private static final long serialVersionUID = -5537699296769492741L;
    public Integer iNumber;
    public Date iDate;
    public String iText;
    private List<SSIndeliveryRow> iRows;

    public SSIndelivery() {
        this.iDate = new Date();
        this.iText = null;
        this.iRows = new LinkedList<SSIndeliveryRow>();
        this.doAutoIncrement();
    }

    public SSIndelivery(SSIndelivery iIndelivery) {
        this.copyFrom(iIndelivery);
    }

    public void doAutoIncrement() {
        this.iNumber = 1;
        List<SSIndelivery> iIndeliveries = SSDB.getInstance().getIndeliveries();
        for (SSIndelivery iIndelivery : iIndeliveries) {
            if (iIndelivery.iNumber < this.iNumber) continue;
            this.iNumber = iIndelivery.iNumber + 1;
        }
    }

    public void copyFrom(SSIndelivery iIndelivery) {
        this.iNumber = iIndelivery.iNumber;
        this.iDate = iIndelivery.iDate;
        this.iText = iIndelivery.iText;
        this.iRows = new LinkedList<SSIndeliveryRow>();
        for (SSIndeliveryRow iRow : iIndelivery.iRows) {
            this.iRows.add(new SSIndeliveryRow(iRow));
        }
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public List<SSIndeliveryRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSIndeliveryRow> iRows) {
        this.iRows = iRows;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSIndelivery)) {
            return false;
        }
        return this.iNumber.equals(((SSIndelivery)obj).iNumber);
    }

    public Integer getChange(SSProduct iProduct) {
        Integer iChange = 0;
        for (SSIndeliveryRow iRow : this.iRows) {
            if (!iRow.hasProduct(iProduct)) continue;
            iChange = iChange + iRow.getChange();
        }
        return iChange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSIndelivery");
        sb.append("{iDate=").append(this.iDate);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iRows=").append(this.iRows);
        sb.append(", iText='").append(this.iText).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

