/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSInpaymentRow
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private Integer iInvoiceNr;
    private SSCurrency iInvoiceCurrency;
    private BigDecimal iInvoiceCurrencyRate;
    private BigDecimal iValue;
    private BigDecimal iCurrencyRate;
    private transient SSInvoice iInvoice;

    public SSInpaymentRow() {
    }

    public SSInpaymentRow(SSInvoice iInvoice) {
        this.setInvoice(iInvoice);
    }

    public SSInpaymentRow(SSInpaymentRow iRow) {
        this.copyFrom(iRow);
    }

    public void copyFrom(SSInpaymentRow iInpaymentRow) {
        this.iInvoiceNr = iInpaymentRow.iInvoiceNr;
        this.iInvoiceCurrency = iInpaymentRow.iInvoiceCurrency;
        this.iInvoiceCurrencyRate = iInpaymentRow.iInvoiceCurrencyRate;
        this.iValue = iInpaymentRow.iValue;
        this.iCurrencyRate = iInpaymentRow.iCurrencyRate;
        this.iInvoice = iInpaymentRow.iInvoice;
    }

    public Integer getInvoiceNr() {
        return this.iInvoiceNr;
    }

    public void setInvoiceNr(Integer iInvoiceNr) {
        this.iInvoiceNr = iInvoiceNr;
        this.iInvoice = null;
    }

    public SSCurrency getInvoiceCurrency() {
        return this.iInvoiceCurrency;
    }

    public void setInvoiceCurrency(SSCurrency iInvoiceCurrency) {
        this.iInvoiceCurrency = iInvoiceCurrency;
    }

    public BigDecimal getInvoiceCurrencyRate() {
        return this.iInvoiceCurrencyRate;
    }

    public void setInvoiceCurrencyRate(BigDecimal iInvoiceExchangerate) {
        this.iInvoiceCurrencyRate = iInvoiceExchangerate;
    }

    public BigDecimal getValue() {
        return this.iValue;
    }

    public void setValue(BigDecimal iValue) {
        this.iValue = iValue;
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public BigDecimal getCurrencyRate() {
        return this.iCurrencyRate;
    }

    public BigDecimal getLocalValue() {
        if (this.iCurrencyRate == null || this.iValue == null) {
            return null;
        }
        return this.iCurrencyRate.multiply(this.iValue);
    }

    public void setLocalValue(BigDecimal iLocalValue) {
        if (this.iCurrencyRate == null || this.iValue == null) {
            return;
        }
        this.iCurrencyRate = iLocalValue.divide(this.iValue, 5, RoundingMode.HALF_UP);
    }

    public SSInvoice getInvoice(List<SSInvoice> iInvoices) {
        if (this.iInvoice == null && this.iInvoiceNr != null) {
            for (SSInvoice iCurrent : iInvoices) {
                if (!this.iInvoiceNr.equals(iCurrent.getNumber())) continue;
                this.iInvoice = iCurrent;
            }
        }
        return this.iInvoice;
    }

    public SSInvoice getInvoice() {
        return this.iInvoice;
    }

    public void setInvoice(SSInvoice iInvoice) {
        this.iInvoice = iInvoice;
        Integer n = this.iInvoiceNr = iInvoice == null ? null : iInvoice.getNumber();
        if (iInvoice != null) {
            BigDecimal iSaldo = SSInvoiceMath.getSaldo(iInvoice.getNumber());
            this.iInvoiceCurrency = iInvoice.getCurrency();
            this.iInvoiceCurrencyRate = iInvoice.getCurrencyRate();
            this.iValue = iSaldo;
            this.iCurrencyRate = iInvoice.getCurrencyRate();
        }
    }

    public boolean isPaying(SSInvoice pInvoice) {
        boolean answer = false;
        if (pInvoice != null) {
            answer = pInvoice.getNumber().equals(this.iInvoiceNr);
        }
        return answer;
    }

    public boolean isPaying(Integer iInvoice) {
        return iInvoice != null && iInvoice.equals(this.iInvoiceNr);
    }

    @Override
    public String toRenderString() {
        return String.valueOf(this.iInvoiceNr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSInpaymentRow");
        sb.append("{iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iInvoice=").append(this.iInvoice);
        sb.append(", iInvoiceCurrency=").append(this.iInvoiceCurrency);
        sb.append(", iInvoiceCurrencyRate=").append(this.iInvoiceCurrencyRate);
        sb.append(", iInvoiceNr=").append(this.iInvoiceNr);
        sb.append(", iValue=").append(this.iValue);
        sb.append('}');
        return sb.toString();
    }
}

