/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.base.SSSale;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSInvoice
extends SSSale {
    static final long serialVersionUID = 1L;
    protected SSInvoiceType iType;
    protected BigDecimal iCurrencyRate;
    protected Date iPaymentDay;
    protected SSVoucher iVoucher;
    protected String iYourOrderNumber;
    protected String iOCRNumber;
    protected boolean iEntered;
    protected int iNumReminders;
    protected boolean iInterestInvoiced;
    private boolean iStockInfluencing;
    private String iOrderNumbers;

    public SSInvoice() {
        this.iType = SSInvoiceType.NORMAL;
        this.iCurrencyRate = new BigDecimal(1);
        this.iVoucher = new SSVoucher();
        this.iOCRNumber = null;
        this.iOrderNumbers = "Fakturan har inga ordrar";
        this.iPrinted = false;
        this.iInterestInvoiced = false;
        this.iStockInfluencing = true;
        this.iNumReminders = 0;
        if (this.iPaymentTerm != null) {
            this.iPaymentDay = this.iPaymentTerm.addDaysToDate(new Date());
        }
    }

    public SSInvoice(SSInvoice iInvoice) {
        this.copyFrom(iInvoice);
    }

    public SSInvoice(SSInvoiceType iInvoiceType) {
        this();
        this.iType = iInvoiceType;
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setDelayInterest(iCompany.getDelayInterest());
            this.setText(iCompany.getStandardText(SSStandardText.Customerinvoice));
            this.setTaxRate1(iCompany.getTaxRate1());
            this.setTaxRate2(iCompany.getTaxRate2());
            this.setTaxRate3(iCompany.getTaxRate3());
            this.setDefaultAccounts(iCompany.getDefaultAccounts());
            this.setOurContactPerson(iCompany.getContactPerson());
        }
    }

    public SSInvoice(SSOrder iOrder) {
        this();
        this.copyFrom(iOrder);
        this.iCurrencyRate = iOrder.getCurrencyRate();
        this.iVoucher = new SSVoucher();
        this.iDate = new Date();
        this.iRows = new LinkedList();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iText = iCompany.getStandardText(SSStandardText.Customerinvoice);
        }
    }

    public void copyFrom(SSInvoice iInvoice) {
        super.copyFrom(iInvoice);
        this.iCurrencyRate = iInvoice.getCurrencyRate();
        this.iPaymentDay = iInvoice.iPaymentDay;
        this.iYourOrderNumber = iInvoice.iYourOrderNumber;
        this.iType = iInvoice.iType;
        this.iEntered = iInvoice.iEntered;
        this.iStockInfluencing = iInvoice.iStockInfluencing;
        this.iInterestInvoiced = iInvoice.iInterestInvoiced;
        this.iNumReminders = iInvoice.iNumReminders;
        this.iOCRNumber = iInvoice.iOCRNumber;
        this.iOrderNumbers = iInvoice.iOrderNumbers;
        this.iVoucher = new SSVoucher(iInvoice.iVoucher);
    }

    @Override
    public void doAutoIncrecement() {
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("invoice");
        for (SSInvoice iInvoice : SSDB.getInstance().getInvoices()) {
            if (iInvoice.getNumber() == null || iInvoice.getNumber() <= iNumber) continue;
            iNumber = iInvoice.getNumber();
        }
        this.setNumber(iNumber + 1);
    }

    public SSInvoiceType getType() {
        if (this.iType == null) {
            this.iType = SSInvoiceType.NORMAL;
        }
        return this.iType;
    }

    public void setType(SSInvoiceType iType) {
        this.iType = iType;
    }

    public BigDecimal getCurrencyRate() {
        return this.iCurrencyRate;
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public Date getDueDate() {
        return this.iPaymentDay;
    }

    public void setDueDate(Date iPaymentDay) {
        this.iPaymentDay = iPaymentDay;
    }

    public void setDueDate() {
        Calendar iCalendar = Calendar.getInstance();
        if (this.iPaymentTerm != null) {
            iCalendar.setTime(this.iDate);
            iCalendar.add(5, this.iPaymentTerm.decodeValue());
            this.iPaymentDay = iCalendar.getTime();
        } else {
            this.iPaymentDay = this.iDate;
        }
    }

    public String getYourOrderNumber() {
        return this.iYourOrderNumber;
    }

    public void setYourOrderNumber(String iYourOrderNumber) {
        this.iYourOrderNumber = iYourOrderNumber;
    }

    public SSVoucher getVoucher() {
        if (this.iVoucher == null) {
            this.generateVoucher();
        }
        return this.iVoucher;
    }

    public void setVoucher(SSVoucher iVoucher) {
        this.iVoucher = iVoucher;
    }

    public boolean hasOCRNumber() {
        return this.iOCRNumber != null;
    }

    public String getOCRNumber() {
        return this.iOCRNumber;
    }

    public void setOCRNumber(String iOCRNumber) {
        this.iOCRNumber = iOCRNumber;
    }

    public boolean isEntered() {
        return this.iEntered;
    }

    public void setEntered(boolean iEntered) {
        this.iEntered = iEntered;
    }

    public void setEntered() {
        this.iEntered = true;
    }

    public String getOrderNumbers() {
        return this.iOrderNumbers;
    }

    public void setOrderNumbers(String iOrderNumbers) {
        this.iOrderNumbers = iOrderNumbers;
    }

    public void setOrderNumers(List<SSOrder> iOrders) {
        String iOrdersForInvoice = "";
        for (SSOrder iOrder : iOrders) {
            iOrdersForInvoice = iOrdersForInvoice + iOrder.getNumber() + ", ";
        }
        this.iOrderNumbers = iOrdersForInvoice = iOrdersForInvoice.substring(0, iOrdersForInvoice.lastIndexOf(", "));
    }

    public boolean isInterestInvoiced() {
        return this.iInterestInvoiced;
    }

    public void setInterestInvoiced(boolean iInterestInvoiced) {
        this.iInterestInvoiced = iInterestInvoiced;
    }

    public int getNumReminders() {
        return this.iNumReminders;
    }

    public void setNumRemainders(int iNumReminders) {
        this.iNumReminders = iNumReminders;
    }

    public boolean isStockInfluencing() {
        return this.iStockInfluencing;
    }

    public void setStockInfluencing(boolean iStockInfluencing) {
        this.iStockInfluencing = iStockInfluencing;
    }

    public void append(SSOrder iOrder) {
        for (SSSaleRow iRow : iOrder.getRows()) {
            SSSaleRow iMatchingRow = SSInvoiceMath.getMatchingRow(this, iRow);
            if (iMatchingRow != null) {
                Integer iQuantity = iMatchingRow.getQuantity();
                if (iQuantity != null) {
                    iMatchingRow.setQuantity(iQuantity + iRow.getQuantity());
                    continue;
                }
                iMatchingRow.setQuantity(iRow.getQuantity());
                continue;
            }
            this.iRows.add(new SSSaleRow(iRow));
        }
    }

    public boolean hasCustomer(SSCustomer iCustomer) {
        return this.iCustomerNr != null && this.iCustomerNr.equals(iCustomer.getNumber());
    }

    @Override
    public int hashCode() {
        if (this.iNumber != null) {
            return this.iNumber;
        }
        return super.hashCode();
    }

    public SSVoucher generateVoucher() {
        String iDescription = SSBundle.getBundle().getString("invoiceframe.voucherdescription");
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this);
        BigDecimal iRoundingSum = SSInvoiceMath.getRounding(this);
        if (this.iType == SSInvoiceType.NORMAL) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CustomerClaim), iTotalSum, null);
        }
        if (this.iType == SSInvoiceType.CASH) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Cash), iTotalSum, null);
        }
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Rounding), iRoundingSum.negate());
        }
        if (!this.iTaxFree) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax1), null, iTaxSum.get(SSTaxCode.TAXRATE_1));
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax2), null, iTaxSum.get(SSTaxCode.TAXRATE_2));
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.Tax3), null, iTaxSum.get(SSTaxCode.TAXRATE_3));
        }
        for (SSSaleRow sSSaleRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            iVoucherRow.setCredit(sSSaleRow.getSum());
            iVoucherRow.setAccount(sSSaleRow.getAccount(iAccountPlan.getAccounts()));
            iVoucherRow.setProject(sSSaleRow.getProject(SSDB.getInstance().getProjects()));
            iVoucherRow.setResultUnit(sSSaleRow.getResultUnit(SSDB.getInstance().getResultUnits()));
            if (iVoucherRow.getAccountNr() == null) continue;
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        for (SSVoucherRow sSVoucherRow : this.iVoucher.getRows()) {
            if (sSVoucherRow.isDebet()) {
                if (sSVoucherRow.getDebet().compareTo(new BigDecimal(0)) != -1) continue;
                sSVoucherRow.setCredit(sSVoucherRow.getDebet().negate());
                sSVoucherRow.setDebet(null);
                continue;
            }
            if (sSVoucherRow.getCredit().compareTo(new BigDecimal(0)) != -1) continue;
            sSVoucherRow.setDebet(sSVoucherRow.getCredit().negate());
            sSVoucherRow.setCredit(null);
        }
        if (this.iCurrencyRate != null) {
            SSVoucherMath.multiplyRowsBy(this.iVoucher, this.iCurrencyRate);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SSInvoice)) {
            return false;
        }
        return this.iNumber.equals(((SSInvoice)obj).getNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSInvoice");
        sb.append("{iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iEntered=").append(this.iEntered);
        sb.append(", iInterestInvoiced=").append(this.iInterestInvoiced);
        sb.append(", iNumReminders=").append(this.iNumReminders);
        sb.append(", iOCRNumber='").append(this.iOCRNumber).append('\'');
        sb.append(", iOrderNumbers='").append(this.iOrderNumbers).append('\'');
        sb.append(", iPaymentDay=").append(this.iPaymentDay);
        sb.append(", iStockInfluencing=").append(this.iStockInfluencing);
        sb.append(", iType=").append((Object)this.iType);
        sb.append(", iVoucher=").append(this.iVoucher);
        sb.append(", iYourOrderNumber='").append(this.iYourOrderNumber).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

