/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;

public class SSMonth
implements Serializable {
    private static Calendar cCalendar = Calendar.getInstance();
    static final long serialVersionUID = 1L;
    private Date iFrom;
    private Date iTo;

    public SSMonth(Date pFrom) {
        this.iFrom = pFrom;
        this.iTo = null;
    }

    public SSMonth(Date pFrom, Date pTo) {
        this.iFrom = pFrom;
        this.iTo = pTo;
    }

    public Date getDate() {
        return this.iFrom;
    }

    public Date getFrom() {
        return this.iFrom;
    }

    public Date getTo() {
        return this.iTo;
    }

    public boolean isBetween(Date pFrom, Date pTo) {
        return pFrom.compareTo(this.iFrom) <= 0 && pTo.compareTo(this.iFrom) >= 0;
    }

    public int hashCode() {
        if (this.iFrom == null) {
            return super.hashCode();
        }
        cCalendar.setTime(this.iFrom);
        return cCalendar.get(1) * 12 + cCalendar.get(2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSMonth) {
            return obj.hashCode() == this.hashCode();
        }
        return super.equals(obj);
    }

    public String toString() {
        DateFormat format = DateFormat.getDateInstance(3);
        return format.format(this.iFrom).substring(0, 7);
    }

    public String getName() {
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iFrom);
        int iMonth = iCalendar.get(2);
        int iYear = iCalendar.get(1);
        DateFormatSymbols iSymbols = new DateFormatSymbols();
        return iSymbols.getMonths()[iMonth] + ", " + iYear;
    }

    public static List<SSMonth> splitYearIntoMonths(SSNewAccountingYear pYearData) {
        Date iFrom = pYearData.getFrom();
        Date iTo = pYearData.getTo();
        return SSMonth.splitYearIntoMonths(iFrom, iTo);
    }

    public boolean isDateInMonth(Date iDate) {
        Calendar iCheckDate = Calendar.getInstance();
        Calendar iMonthDate = Calendar.getInstance();
        iCheckDate.setTime(iDate);
        iMonthDate.setTime(this.iFrom);
        return iCheckDate.get(2) == iMonthDate.get(2) && iCheckDate.get(1) == iMonthDate.get(1);
    }

    public static List<SSMonth> splitYearIntoMonths(Date iFrom, Date iTo) {
        LinkedList<SSMonth> iMonths = new LinkedList<SSMonth>();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(iFrom);
        iCalendar.set(5, 1);
        while (iCalendar.getTime().compareTo(iTo) < 0) {
            Date mForm = iCalendar.getTime();
            iCalendar.set(5, iCalendar.getActualMaximum(5));
            Date mTo = iCalendar.getTime();
            SSMonth iMonth = new SSMonth(mForm, mTo);
            iMonths.add(iMonth);
            iCalendar.set(5, 1);
            iCalendar.add(2, 1);
        }
        return iMonths;
    }
}

