/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.util.SSAutoIncrement;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCompany;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.util.SSMailServer;

public class SSNewCompany
implements Serializable {
    static final long serialVersionUID = 1L;
    private Integer iId;
    private String iName;
    private String iPhone;
    private String iPhone2;
    private String iTelefax;
    private String iResidence;
    private String iWebAddress;
    private String iSMTPAddress;
    private String iEMail;
    private String iContactPerson;
    private boolean iTaxRegistered;
    private String iCorporateID;
    private String iLogotype;
    private String iBank;
    private String iVATNumber;
    private String iBankAccountNumber;
    private String iPlusAccountNumber;
    private String iIBAN;
    private String iSwift;
    private SSCurrency iCurrency;
    private BigDecimal iDelayintrest;
    private BigDecimal iReminderfee;
    private String iEstimatedDelivery;
    private BigDecimal iTaxrate1;
    private BigDecimal iTaxrate2;
    private BigDecimal iTaxrate3;
    private String iWeightUnit;
    private String iVolumeUnit;
    private SSAddress iAddress;
    private SSAddress iDeliveryAddress;
    private Map<SSStandardText, String> iStandardTexts;
    private Map<SSDefaultAccount, Integer> iDefaultAccounts;
    private SSUnit iStandardUnit;
    private SSPaymentTerm iPaymentTerm;
    private SSDeliveryTerm iDeliveryTerm;
    private SSDeliveryWay iDeliveryWay;
    private boolean iRoundingOff;
    private Integer iVatPeriod;
    private SSMailServer iMailServer;
    private SSAutoIncrement iAutoIncrement;

    public SSNewCompany() {
        this.iId = 0;
        this.iAddress = new SSAddress();
        this.iDeliveryAddress = new SSAddress();
        this.iStandardTexts = new HashMap<SSStandardText, String>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iAutoIncrement = new SSAutoIncrement();
        this.iRoundingOff = false;
        this.iVatPeriod = 1;
    }

    public SSNewCompany(SSCompany iOldCompany) {
        this.iName = iOldCompany.getName();
        this.iPhone = iOldCompany.getPhone();
        this.iPhone2 = iOldCompany.getPhone2();
        this.iTelefax = iOldCompany.getTelefax();
        this.iResidence = iOldCompany.getResidence();
        this.iWebAddress = iOldCompany.getHomepage();
        this.iSMTPAddress = iOldCompany.getSMTP();
        this.iEMail = iOldCompany.getEMail();
        this.iContactPerson = iOldCompany.getContactPerson();
        this.iTaxRegistered = iOldCompany.getTaxRegistered();
        this.iCorporateID = iOldCompany.getCorporateID();
        this.iLogotype = iOldCompany.getLogotype();
        this.iBank = iOldCompany.getBank();
        this.iVATNumber = iOldCompany.getVATNumber();
        this.iBankAccountNumber = iOldCompany.getBankGiroNumber();
        this.iPlusAccountNumber = iOldCompany.getPlusGiroNumber();
        this.iIBAN = iOldCompany.getIBAN();
        this.iSwift = iOldCompany.getBIC();
        this.iCurrency = iOldCompany.getCurrency();
        this.iDelayintrest = iOldCompany.getDelayInterest();
        this.iReminderfee = iOldCompany.getReminderfee();
        this.iEstimatedDelivery = iOldCompany.getEstimatedDelivery();
        this.iTaxrate1 = iOldCompany.getTaxRate1();
        this.iTaxrate2 = iOldCompany.getTaxRate2();
        this.iTaxrate3 = iOldCompany.getTaxRate3();
        this.iWeightUnit = iOldCompany.getWeightUnit();
        this.iVolumeUnit = iOldCompany.getVolumeUnit();
        this.iAddress = iOldCompany.getAddress();
        this.iDeliveryAddress = iOldCompany.getDeliveryAddress();
        this.iStandardTexts = iOldCompany.getStandardTexts();
        this.iDefaultAccounts = iOldCompany.getDefaultAccounts();
        this.iStandardUnit = iOldCompany.getStandardUnit();
        this.iPaymentTerm = iOldCompany.getPaymentTerm();
        this.iDeliveryTerm = iOldCompany.getDeliveryTerm();
        this.iDeliveryWay = iOldCompany.getDeliveryWay();
        this.iAutoIncrement = iOldCompany.getAutoIncrement();
        this.iVatPeriod = 1;
    }

    public Integer getId() {
        return this.iId;
    }

    public void setId(Integer pId) {
        this.iId = pId;
    }

    public SSAddress getAddress() {
        return this.iAddress;
    }

    public void setAddress(SSAddress pAddress) {
        this.iAddress = pAddress;
    }

    public SSMailServer getMailServer() {
        return this.iMailServer;
    }

    public void setMailServer(SSMailServer server) {
        this.iMailServer = server;
    }

    public SSAddress getDeliveryAddress() {
        return this.iDeliveryAddress;
    }

    public void setDeliveryAddress(SSAddress pDeliveryAddress) {
        this.iDeliveryAddress = pDeliveryAddress;
    }

    public Map<SSStandardText, String> getStandardTexts() {
        if (this.iStandardTexts == null) {
            this.iStandardTexts = new HashMap<SSStandardText, String>();
        }
        return this.iStandardTexts;
    }

    public String getStandardText(SSStandardText iStandardtext) {
        if (this.iStandardTexts != null) {
            return this.iStandardTexts.get((Object)iStandardtext);
        }
        return null;
    }

    public void setStandardTexts(Map<SSStandardText, String> pStandardTexts) {
        this.iStandardTexts = pStandardTexts;
    }

    public boolean isRoundingOff() {
        return this.iRoundingOff;
    }

    public void setRoundingOff(boolean iRoundingOff) {
        this.iRoundingOff = iRoundingOff;
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        return this.iDefaultAccounts;
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        if (this.iDefaultAccounts != null && this.iDefaultAccounts.containsKey(iDefaultAccount)) {
            return this.iDefaultAccounts.get(iDefaultAccount);
        }
        return iDefaultAccount.getDefaultAccountNumber();
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.iDefaultAccounts.get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getPhone() {
        return this.iPhone;
    }

    public void setPhone(String pPhone) {
        this.iPhone = pPhone;
    }

    public String getPhone2() {
        return this.iPhone2;
    }

    public void setPhone2(String pPhone2) {
        this.iPhone2 = pPhone2;
    }

    public String getTelefax() {
        return this.iTelefax;
    }

    public void setTelefax(String pTelefax) {
        this.iTelefax = pTelefax;
    }

    public String getResidence() {
        return this.iResidence;
    }

    public void setResidence(String residence) {
        this.iResidence = residence;
    }

    public String getEMail() {
        return this.iEMail;
    }

    public void setEMail(String pEMail) {
        this.iEMail = pEMail;
    }

    public String getHomepage() {
        return this.iWebAddress;
    }

    public void setHomepage(String pWebAddress) {
        this.iWebAddress = pWebAddress;
    }

    public String getSMTP() {
        return this.iSMTPAddress;
    }

    public void setSMTP(String pSMTPAddress) {
        this.iSMTPAddress = pSMTPAddress;
    }

    public String getContactPerson() {
        return this.iContactPerson;
    }

    public void setContactPerson(String pContactPerson) {
        this.iContactPerson = pContactPerson;
    }

    public boolean getTaxRegistered() {
        return this.iTaxRegistered;
    }

    public void setTaxRegistered(boolean pTaxRegistered) {
        this.iTaxRegistered = pTaxRegistered;
    }

    public String getCorporateID() {
        return this.iCorporateID;
    }

    public void setCorporateID(String iCorporateID) {
        this.iCorporateID = iCorporateID;
    }

    public String getLogotype() {
        return this.iLogotype;
    }

    public void setLogotype(String pLogotype) {
        this.iLogotype = pLogotype;
    }

    public String getVATNumber() {
        return this.iVATNumber;
    }

    public void setVATNumber(String pVATNumber) {
        this.iVATNumber = pVATNumber;
    }

    public String getBank() {
        return this.iBank;
    }

    public void setBank(String pBank) {
        this.iBank = pBank;
    }

    public String getBankGiroNumber() {
        return this.iBankAccountNumber;
    }

    public void setBankGiroNumber(String bankAccountNumber) {
        this.iBankAccountNumber = bankAccountNumber;
    }

    public String getPlusGiroNumber() {
        return this.iPlusAccountNumber;
    }

    public void setPlusGiroNumber(String plusAccountNumber) {
        this.iPlusAccountNumber = plusAccountNumber;
    }

    public String getIBAN() {
        return this.iIBAN;
    }

    public void setIBAN(String IBAN) {
        this.iIBAN = IBAN;
    }

    public String getBIC() {
        return this.iSwift;
    }

    public void setBIC(String swift) {
        this.iSwift = swift;
    }

    public String getVolumeUnit() {
        if (this.iVolumeUnit == null) {
            this.iVolumeUnit = "m3";
        }
        return this.iVolumeUnit;
    }

    public void setVolumeUnit(String iVolumeUnit) {
        this.iVolumeUnit = iVolumeUnit;
    }

    public String getWeightUnit() {
        if (this.iWeightUnit == null) {
            this.iWeightUnit = "kg";
        }
        return this.iWeightUnit;
    }

    public void setWeightUnit(String iWeightUnit) {
        this.iWeightUnit = iWeightUnit;
    }

    public SSCurrency getCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public SSUnit getStandardUnit() {
        return this.iStandardUnit;
    }

    public void setStandardUnit(SSUnit iStandardUnit) {
        this.iStandardUnit = iStandardUnit;
    }

    public BigDecimal getDelayInterest() {
        return this.iDelayintrest;
    }

    public void setDelayInterest(BigDecimal iDelayintrest) {
        this.iDelayintrest = iDelayintrest;
    }

    public BigDecimal getReminderfee() {
        return this.iReminderfee;
    }

    public void setReminderfee(BigDecimal iReminderfee) {
        this.iReminderfee = iReminderfee;
    }

    public BigDecimal getTaxRate1() {
        if (this.iTaxrate1 == null) {
            this.iTaxrate1 = new BigDecimal(25);
        }
        return this.iTaxrate1;
    }

    public void setTaxrate1(BigDecimal iTaxrate1) {
        this.iTaxrate1 = iTaxrate1;
    }

    public BigDecimal getTaxRate2() {
        if (this.iTaxrate2 == null) {
            this.iTaxrate2 = new BigDecimal(12);
        }
        return this.iTaxrate2;
    }

    public void setTaxrate2(BigDecimal iTaxrate2) {
        this.iTaxrate2 = iTaxrate2;
    }

    public BigDecimal getTaxRate3() {
        if (this.iTaxrate3 == null) {
            this.iTaxrate3 = new BigDecimal(6);
        }
        return this.iTaxrate3;
    }

    public void setTaxrate3(BigDecimal iTaxrate3) {
        this.iTaxrate3 = iTaxrate3;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public Integer getVatPeriod() {
        return this.iVatPeriod;
    }

    public void setVatPeriod(Integer iVatPeriod) {
        this.iVatPeriod = iVatPeriod;
    }

    public BigDecimal getTaxRate(SSTaxCode iTaxCode) {
        if (iTaxCode == SSTaxCode.TAXRATE_1) {
            return this.iTaxrate1;
        }
        if (iTaxCode == SSTaxCode.TAXRATE_2) {
            return this.iTaxrate2;
        }
        if (iTaxCode == SSTaxCode.TAXRATE_3) {
            return this.iTaxrate3;
        }
        return null;
    }

    public String getEstimatedDelivery() {
        return this.iEstimatedDelivery;
    }

    public void setEstimatedDelivery(String iEstimatedDelivery) {
        this.iEstimatedDelivery = iEstimatedDelivery;
    }

    public Double getTenderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        for (SSTender iTender : SSDB.getInstance().getTenders()) {
            Date iTenderDate = iTender.getDate();
            if (!iMonth.isDateInMonth(iTenderDate)) continue;
            for (SSSaleRow iRow : iTender.getRows()) {
                if (iRow.getSum() == null) continue;
                sum = sum + iRow.getSum().doubleValue() * iTender.getCurrencyRate().doubleValue();
            }
        }
        return sum;
    }

    public Double getOrderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        for (SSOrder iOrder : iOrders) {
            Date iOrderDate = iOrder.getDate();
            if (!iMonth.isDateInMonth(iOrderDate)) continue;
            for (SSSaleRow iRow : iOrder.getRows()) {
                if (iRow.getSum() == null) continue;
                sum = sum + iRow.getSum().doubleValue() * iOrder.getCurrencyRate().doubleValue();
            }
        }
        return sum;
    }

    public Double getInvoiceValueForMonth(SSMonth iMonth) {
        Double suminvoices = 0.0;
        for (SSInvoice iInvoice : SSDB.getInstance().getInvoices()) {
            Date iInvoiceDate = iInvoice.getDate();
            if (!iMonth.isDateInMonth(iInvoiceDate)) continue;
            for (SSSaleRow iRow : iInvoice.getRows()) {
                if (iRow.getSum() == null) continue;
                suminvoices = suminvoices + iRow.getSum().doubleValue() * iInvoice.getCurrencyRate().doubleValue();
            }
        }
        Double sumcreditinvoices = 0.0;
        for (SSCreditInvoice iCreditInvoice : SSDB.getInstance().getCreditInvoices()) {
            Date iCreditInvoiceDate = iCreditInvoice.getDate();
            if (!iMonth.isDateInMonth(iCreditInvoiceDate)) continue;
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                if (iRow.getSum() == null) continue;
                sumcreditinvoices = sumcreditinvoices + iRow.getSum().doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
            }
        }
        return suminvoices - sumcreditinvoices;
    }

    public Double getPurchaseOrderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        for (SSPurchaseOrder iPurchaseOrder : SSDB.getInstance().getPurchaseOrders()) {
            Date iPurchaseOrderDate = iPurchaseOrder.getDate();
            if (!iMonth.isDateInMonth(iPurchaseOrderDate) || iPurchaseOrder.getSum() == null) continue;
            sum = sum + iPurchaseOrder.getSum().doubleValue() * iPurchaseOrder.getCurrencyRate().doubleValue();
        }
        return sum;
    }

    public Double getSupplierInvoiceValueForMonth(SSMonth iMonth) {
        Double sumSupplierInvoices = 0.0;
        for (SSSupplierInvoice iSupplierInvoice : SSDB.getInstance().getSupplierInvoices()) {
            Date iSupplierInvoiceDate = iSupplierInvoice.getDate();
            if (!iMonth.isDateInMonth(iSupplierInvoiceDate) || SSSupplierInvoiceMath.getNetSum(iSupplierInvoice) == null) continue;
            sumSupplierInvoices = sumSupplierInvoices + SSSupplierInvoiceMath.getNetSum(iSupplierInvoice).doubleValue() * iSupplierInvoice.getCurrencyRate().doubleValue();
        }
        Double sumSupplierCreditInvoices = 0.0;
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : SSDB.getInstance().getSupplierCreditInvoices()) {
            Date iSupplierCreditInvoiceDate = iSupplierCreditInvoice.getDate();
            if (!iMonth.isDateInMonth(iSupplierCreditInvoiceDate) || SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice) == null) continue;
            sumSupplierCreditInvoices = sumSupplierCreditInvoices + SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice).doubleValue() * iSupplierCreditInvoice.getCurrencyRate().doubleValue();
        }
        return sumSupplierInvoices - sumSupplierCreditInvoices;
    }

    public SSAutoIncrement getAutoIncrement() {
        if (this.iAutoIncrement == null) {
            this.iAutoIncrement = new SSAutoIncrement();
        }
        return this.iAutoIncrement;
    }

    public Image getLogoImage() {
        if (this.iLogotype == null) {
            return null;
        }
        File iFile = new File(this.iLogotype);
        if (!iFile.exists()) {
            return null;
        }
        BufferedImage iImage = null;
        try {
            iImage = ImageIO.read(iFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return iImage;
    }

    public int hashCode() {
        return this.iId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSNewCompany)) {
            return false;
        }
        if (this.iId == null) {
            return false;
        }
        return this.iId.equals(((SSNewCompany)obj).iId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iName);
        return sb.toString();
    }
}

