/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSProject;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSNewProject
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iNumber;
    private String iName;
    private String iDescription;
    private boolean iConcluded;
    private Date iConcludedDate;

    public SSNewProject() {
    }

    public SSNewProject(String pNumber, String pName, String pDescription) {
        this.iNumber = pNumber;
        this.iName = pName;
        this.iDescription = pDescription;
        this.iConcluded = false;
        this.iConcludedDate = null;
    }

    public SSNewProject(SSProject iOld) {
        this.iNumber = String.valueOf(iOld.getNumber());
        this.iName = iOld.getName();
        this.iDescription = iOld.getDescription();
        this.iConcluded = iOld.getConcluded();
        this.iConcludedDate = iOld.getConcludedDate();
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String number) {
        this.iNumber = number;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public boolean getConcluded() {
        return this.iConcluded;
    }

    public void setConcluded(boolean pConcluded) {
        this.iConcluded = pConcluded;
    }

    public Date getConcludedDate() {
        return this.iConcludedDate;
    }

    public void setConcludedDate(Date pConcluded) {
        this.iConcludedDate = pConcluded;
    }

    public boolean isConcluded(Date iDate) {
        return this.iConcluded && this.iConcludedDate != null && this.iConcludedDate.getTime() <= iDate.getTime();
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(" - ");
        sb.append(this.iName);
        sb.append(", ");
        sb.append(this.iDescription);
        if (this.iConcluded) {
            sb.append("(Concluded ");
            sb.append(iFormat.format(this.iConcludedDate));
            sb.append(") ");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSNewProject) {
            return ((SSNewProject)obj).iNumber.equals(this.iNumber);
        }
        return false;
    }

    @Override
    public String toRenderString() {
        return this.iNumber;
    }

    public BigDecimal getProjectRevenueForMonth(SSMonth iMonth) {
        Double iInvoiceSum = 0.0;
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iMonth.isDateInMonth(iInvoice.getDate())) continue;
            for (SSSaleRow iRow : iInvoice.getRows()) {
                if (iRow.getProjectNr() == null || !iRow.getProjectNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iInvoiceSum = iInvoiceSum + iRow.getSum().doubleValue() * iInvoice.getCurrencyRate().doubleValue();
            }
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        Double iCreditInvoiceSum = 0.0;
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iMonth.isDateInMonth(iCreditInvoice.getDate())) continue;
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                if (iRow.getProjectNr() == null || !iRow.getProjectNr().equals(this.iNumber) || iRow.getSum() == null) continue;
                iCreditInvoiceSum = iCreditInvoiceSum + iRow.getSum().doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
            }
        }
        return new BigDecimal(iInvoiceSum - iCreditInvoiceSum);
    }
}

