/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.base.SSSale;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOrder
extends SSSale {
    static final long serialVersionUID = 1L;
    private String iYourOrderNumber;
    private String iEstimatedDelivery;
    private Integer iInvoiceNr;
    private Integer iPeriodicInvoiceNr;
    private Integer iPurchaseOrderNr;
    private boolean iHideUnitprice;
    private transient SSInvoice iInvoice;
    private transient SSPeriodicInvoice iPeriodicInvoice;
    private transient SSPurchaseOrder iPurchaseOrder;
    protected BigDecimal iCurrencyRate;

    public Integer getPurchaseOrderNr() {
        return this.iPurchaseOrderNr;
    }

    public SSOrder() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setDelayInterest(iCompany.getDelayInterest());
            this.setText(iCompany.getStandardText(SSStandardText.Saleorder));
            this.setTaxRate1(iCompany.getTaxRate1());
            this.setTaxRate2(iCompany.getTaxRate2());
            this.setTaxRate3(iCompany.getTaxRate3());
            this.setDefaultAccounts(iCompany.getDefaultAccounts());
            this.setOurContactPerson(iCompany.getContactPerson());
            this.iEstimatedDelivery = iCompany.getEstimatedDelivery();
            this.setPaymentTerm(iCompany.getPaymentTerm());
            this.setDeliveryTerm(iCompany.getDeliveryTerm());
            this.setDeliveryWay(iCompany.getDeliveryWay());
            this.setCurrency(iCompany.getCurrency());
            this.iCurrencyRate = this.iCurrency.getExchangeRate();
        }
    }

    @Override
    public void setCustomer(SSCustomer iCustomer) {
        super.setCustomer(iCustomer);
        this.iCurrencyRate = this.iCurrency.getExchangeRate();
    }

    public SSOrder(SSOrder iOrder) {
        this.copyFrom(iOrder);
    }

    public SSOrder(SSTender iTender) {
        this.copyFrom(iTender);
        this.iDate = new Date();
        this.iCurrencyRate = iTender.getCurrencyRate();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        for (SSCustomer pCustomer : SSDB.getInstance().getCustomers()) {
            if (!pCustomer.getNumber().equals(this.iCustomerNr)) continue;
            this.iHideUnitprice = pCustomer.getHideUnitprice();
        }
        if (iCompany != null) {
            this.iEstimatedDelivery = iCompany.getEstimatedDelivery();
            this.iText = iCompany.getStandardText(SSStandardText.Saleorder);
        }
        this.iNumber = null;
    }

    public void copyFrom(SSOrder iOrder) {
        super.copyFrom(iOrder);
        this.iInvoice = iOrder.iInvoice;
        this.iInvoiceNr = iOrder.iInvoiceNr;
        this.iPeriodicInvoice = iOrder.iPeriodicInvoice;
        this.iPeriodicInvoiceNr = iOrder.iPeriodicInvoiceNr;
        this.iPurchaseOrder = iOrder.iPurchaseOrder;
        this.iPurchaseOrderNr = iOrder.iPurchaseOrderNr;
        this.iYourOrderNumber = iOrder.iYourOrderNumber;
        this.iEstimatedDelivery = iOrder.iEstimatedDelivery;
        this.iHideUnitprice = iOrder.iHideUnitprice;
        this.iCurrencyRate = iOrder.iCurrencyRate;
    }

    @Override
    public void doAutoIncrecement() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        int iNumber = iCompany.getAutoIncrement().getNumber("order");
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        for (SSOrder iOrder : iOrders) {
            if (iOrder.getNumber() == null || iOrder.getNumber() <= iNumber) continue;
            iNumber = iOrder.getNumber();
        }
        this.setNumber(iNumber + 1);
    }

    public String getYourOrderNumber() {
        return this.iYourOrderNumber;
    }

    public void setYourOrderNumber(String iYourOrderNumber) {
        this.iYourOrderNumber = iYourOrderNumber;
    }

    public String getEstimatedDelivery() {
        return this.iEstimatedDelivery;
    }

    public void setEstimatedDelivery(String iEstimatedDelivery) {
        this.iEstimatedDelivery = iEstimatedDelivery;
    }

    public void setHideUnitprice(boolean iHideUnitprice) {
        this.iHideUnitprice = iHideUnitprice;
    }

    public boolean getHideUnitprice() {
        return this.iHideUnitprice;
    }

    public Integer getInvoiceNr() {
        return this.iInvoiceNr;
    }

    public void setInvoiceNr(Integer iInvoiceNr) {
        this.iInvoiceNr = iInvoiceNr;
        this.iInvoice = null;
    }

    public Integer getPeriodicInvoiceNr() {
        return this.iPeriodicInvoiceNr;
    }

    public void setPeriodicInvoiceNr(Integer iInvoiceNr) {
        this.iPeriodicInvoiceNr = iInvoiceNr;
        this.iPeriodicInvoice = null;
    }

    public BigDecimal getCurrencyRate() {
        if (this.iCurrencyRate != null) {
            return this.iCurrencyRate;
        }
        if (this.iCustomer != null) {
            return this.iCustomer.getInvoiceCurrency().getExchangeRate();
        }
        return new BigDecimal(1);
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public SSInvoice getInvoice() {
        return this.getInvoice(SSDB.getInstance().getInvoices());
    }

    public SSInvoice getInvoice(List<SSInvoice> iInvoices) {
        if (this.iInvoice == null && this.iInvoiceNr != null) {
            for (SSInvoice iCurrent : iInvoices) {
                if (!this.iInvoiceNr.equals(iCurrent.getNumber())) continue;
                this.iInvoice = iCurrent;
            }
        }
        return this.iInvoice;
    }

    public void setInvoice(SSInvoice iInvoice) {
        this.iInvoice = iInvoice;
        this.iInvoiceNr = iInvoice == null ? null : iInvoice.getNumber();
    }

    public SSPeriodicInvoice getPeriodicInvoice() {
        return this.getPeriodicInvoice(SSDB.getInstance().getPeriodicInvoices());
    }

    public SSPeriodicInvoice getPeriodicInvoice(List<SSPeriodicInvoice> iPeriodicInvoices) {
        if (this.iPeriodicInvoice == null && this.iPeriodicInvoiceNr != null) {
            for (SSPeriodicInvoice iCurrent : iPeriodicInvoices) {
                if (!this.iPeriodicInvoiceNr.equals(iCurrent.getNumber())) continue;
                this.iPeriodicInvoice = iCurrent;
            }
        }
        return this.iPeriodicInvoice;
    }

    public void setPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        this.iPeriodicInvoice = iPeriodicInvoice;
        this.iPeriodicInvoiceNr = iPeriodicInvoice == null ? null : iPeriodicInvoice.getNumber();
    }

    public SSPurchaseOrder getPurchaseOrder() {
        return this.getPurchaseOrder(SSDB.getInstance().getPurchaseOrders());
    }

    public SSPurchaseOrder getPurchaseOrder(List<SSPurchaseOrder> iPurchaseOrders) {
        if (this.iPurchaseOrder == null && this.iPurchaseOrderNr != null) {
            for (SSPurchaseOrder iCurrent : iPurchaseOrders) {
                if (!this.iPurchaseOrderNr.equals(iCurrent.getNumber())) continue;
                this.iPurchaseOrder = iCurrent;
            }
        }
        return this.iPurchaseOrder;
    }

    public void setPurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        this.iPurchaseOrder = iPurchaseOrder;
        this.iPurchaseOrderNr = iPurchaseOrder == null ? null : iPurchaseOrder.getNumber();
    }

    public boolean hasInvoice(SSInvoice iInvoice) {
        return this.iInvoiceNr != null && this.iInvoiceNr.equals(iInvoice.getNumber());
    }

    public boolean hasInvoice() {
        return this.iInvoiceNr != null;
    }

    public boolean hasPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        return this.iPeriodicInvoiceNr != null && this.iPeriodicInvoiceNr.equals(iPeriodicInvoice.getNumber());
    }

    public boolean hasPeriodicInvoice() {
        return this.iPeriodicInvoiceNr != null;
    }

    public boolean hasPurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        return this.iPurchaseOrderNr != null && this.iPurchaseOrderNr.equals(iPurchaseOrder.getNumber());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SSOrder)) {
            return false;
        }
        return this.iNumber.equals(((SSOrder)obj).getNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSOrder");
        sb.append("{iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iEstimatedDelivery='").append(this.iEstimatedDelivery).append('\'');
        sb.append(", iHideUnitprice=").append(this.iHideUnitprice);
        sb.append(", iInvoice=").append(this.iInvoice);
        sb.append(", iInvoiceNr=").append(this.iInvoiceNr);
        sb.append(", iPeriodicInvoice=").append(this.iPeriodicInvoice);
        sb.append(", iPeriodicInvoiceNr=").append(this.iPeriodicInvoiceNr);
        sb.append(", iPurchaseOrder=").append(this.iPurchaseOrder);
        sb.append(", iPurchaseOrderNr=").append(this.iPurchaseOrderNr);
        sb.append(", iYourOrderNumber='").append(this.iYourOrderNumber).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

