/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSOutdeliveryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOutdelivery
implements Serializable {
    private static final long serialVersionUID = -5537699296769492741L;
    public Integer iNumber;
    public Date iDate;
    public String iText;
    private List<SSOutdeliveryRow> iRows;

    public SSOutdelivery() {
        this.iDate = new Date();
        this.iText = null;
        this.iRows = new LinkedList<SSOutdeliveryRow>();
        this.doAutoIncrement();
    }

    public SSOutdelivery(SSOutdelivery iOutdelivery) {
        this.copyFrom(iOutdelivery);
    }

    public void doAutoIncrement() {
        this.iNumber = 1;
        List<SSOutdelivery> iOutdeliveries = SSDB.getInstance().getOutdeliveries();
        for (SSOutdelivery iOutdelivery : iOutdeliveries) {
            if (iOutdelivery.iNumber < this.iNumber) continue;
            this.iNumber = iOutdelivery.iNumber + 1;
        }
    }

    public void copyFrom(SSOutdelivery iOutdelivery) {
        this.iNumber = iOutdelivery.iNumber;
        this.iDate = iOutdelivery.iDate;
        this.iText = iOutdelivery.iText;
        this.iRows = new LinkedList<SSOutdeliveryRow>();
        for (SSOutdeliveryRow iRow : iOutdelivery.iRows) {
            this.iRows.add(new SSOutdeliveryRow(iRow));
        }
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public List<SSOutdeliveryRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSOutdeliveryRow> iRows) {
        this.iRows = iRows;
    }

    public Integer getChange(SSProduct iProduct) {
        Integer iSum = 0;
        for (SSOutdeliveryRow iRow : this.iRows) {
            Integer iChange;
            if (!iRow.hasProduct(iProduct) || (iChange = iRow.getChange()) == null) continue;
            iSum = iSum + iChange;
        }
        return iSum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSOutdelivery)) {
            return false;
        }
        return this.iNumber.equals(((SSOutdelivery)obj).iNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSOutdelivery");
        sb.append("{iDate=").append(this.iDate);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iRows=").append(this.iRows);
        sb.append(", iText='").append(this.iText).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

