/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSOutpayment
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private Integer iNumber;
    private Date iDate;
    private String iText;
    private List<SSOutpaymentRow> iRows;
    private SSVoucher iVoucher;
    private SSVoucher iDifference;
    private boolean iEntered;
    protected Map<SSDefaultAccount, Integer> iDefaultAccounts;

    public SSOutpayment() {
        this.iRows = new LinkedList<SSOutpaymentRow>();
        this.iVoucher = new SSVoucher();
        this.iDifference = new SSVoucher();
        this.iEntered = false;
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(SSDB.getInstance().getCurrentCompany().getDefaultAccounts());
    }

    public SSOutpayment(SSOutpayment iOutpayment) {
        this.copyFrom(iOutpayment);
    }

    public SSOutpayment(SSOutpayment iOutpayment, Integer iNumber) {
        this.copyFrom(iOutpayment);
        this.iNumber = iNumber;
    }

    public void copyFrom(SSOutpayment iOutpayment) {
        this.iNumber = iOutpayment.iNumber;
        this.iDate = iOutpayment.iDate;
        this.iText = iOutpayment.iText;
        this.iEntered = iOutpayment.iEntered;
        this.iVoucher = new SSVoucher(iOutpayment.iVoucher);
        this.iDifference = new SSVoucher(iOutpayment.iDifference);
        this.iRows = new LinkedList<SSOutpaymentRow>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        for (SSOutpaymentRow iRow : iOutpayment.iRows) {
            this.iRows.add(new SSOutpaymentRow(iRow));
        }
        this.iDefaultAccounts.putAll(iOutpayment.getDefaultAccounts());
    }

    public void doAutoIncrecement() {
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        int iNumber = SSDB.getInstance().getAutoIncrement().getNumber("outpayment");
        for (SSOutpayment iOutpayment : iOutpayments) {
            if (iOutpayment.iNumber == null || iOutpayment.iNumber <= iNumber) continue;
            iNumber = iOutpayment.iNumber;
        }
        this.iNumber = iNumber + 1;
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        SSNewCompany iCompany;
        if (this.iDefaultAccounts == null && (iCompany = SSDB.getInstance().getCurrentCompany()) != null) {
            this.iDefaultAccounts = iCompany.getDefaultAccounts();
            Object var1_1 = null;
        }
        return this.iDefaultAccounts;
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.getDefaultAccounts().get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        return this.iDefaultAccounts.get(iDefaultAccount);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
    }

    public List<SSOutpaymentRow> getRows() {
        if (this.iRows == null) {
            this.iRows = new LinkedList<SSOutpaymentRow>();
        }
        return this.iRows;
    }

    public void setRows(List<SSOutpaymentRow> iRows) {
        this.iRows = iRows;
    }

    public SSVoucher getVoucher() {
        return this.iVoucher;
    }

    public void setVoucher(SSVoucher iVoucher) {
        this.iVoucher = iVoucher;
    }

    public SSVoucher getDifference() {
        if (this.iDifference == null) {
            this.iDifference = new SSVoucher();
        }
        return this.iDifference;
    }

    public void setDifference(SSVoucher iDifference) {
        this.iDifference = iDifference;
    }

    public boolean isEntered() {
        return this.iEntered;
    }

    public void setEntered(boolean iEntered) {
        this.iEntered = iEntered;
    }

    public void setEntered() {
        this.iEntered = true;
    }

    public void addInvoices(List<SSSupplierInvoice> iSupplierInvoices) {
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            SSOutpaymentRow iRow = new SSOutpaymentRow();
            iRow.setSupplierInvoice(iSupplierInvoice);
            this.iRows.add(iRow);
        }
    }

    public List<SSSupplierInvoice> getSupplierInvoices() {
        LinkedList<SSSupplierInvoice> iSupplierInvoices = new LinkedList<SSSupplierInvoice>();
        for (SSOutpaymentRow iRow : this.iRows) {
            if (iRow.getSupplierInvoice(SSDB.getInstance().getSupplierInvoices()) == null) continue;
            iSupplierInvoices.add(iRow.getSupplierInvoice(SSDB.getInstance().getSupplierInvoices()));
        }
        return iSupplierInvoices;
    }

    public boolean isPaying(SSSupplierInvoice iInvoice) {
        for (SSOutpaymentRow iRow : this.iRows) {
            if (!iRow.isPaying(iInvoice)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iText);
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iNumber == null ? null : this.iNumber.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSOutpayment)) {
            return false;
        }
        return this.iNumber.equals(((SSOutpayment)obj).iNumber);
    }

    public SSVoucher generateVoucher() {
        String iDescription = SSBundle.getBundle().getString("outpaymentframe.voucherdescription");
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        BigDecimal iSum = SSOutpaymentMath.getSum(this);
        BigDecimal iCurrencyRateDifference = SSOutpaymentMath.getCurrencyRateDifference(this);
        BigDecimal iDifferenceSum = SSVoucherMath.getCreditMinusDebetSum(this.iDifference);
        iSum = iSum.add(iCurrencyRateDifference);
        iSum = iSum.add(iDifferenceSum);
        this.iVoucher = new SSVoucher();
        this.iVoucher.setDate(new Date());
        this.iVoucher.setNumber(0);
        this.iVoucher.setDescription(String.format(iDescription, this.iNumber));
        this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.SupplierDebt), iSum);
        if (iCurrencyRateDifference.signum() > 0) {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CurrencyProfit), iCurrencyRateDifference.negate());
        } else {
            this.iVoucher.addVoucherRow(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.CurrencyLoss), iCurrencyRateDifference.negate());
        }
        for (SSVoucherRow iVoucherRow : this.iDifference.getRows()) {
            this.iVoucher.addVoucherRow(new SSVoucherRow(iVoucherRow));
        }
        for (SSOutpaymentRow iRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            BigDecimal iValue = SSOutpaymentMath.convertToLocal(iRow, iRow.getValue());
            iVoucherRow.setValue(iValue.negate());
            iVoucherRow.setAccount(this.getDefaultAccount(iAccountPlan, SSDefaultAccount.OutPayment));
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
        this.iVoucher = SSVoucherMath.compress(this.iVoucher);
        return this.iVoucher;
    }
}

