/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSPeriodicInvoice
implements Serializable {
    private static final long serialVersionUID = 4800991425088361649L;
    private Integer iNumber;
    private SSInvoice iTemplate;
    private Date iDate;
    private Integer iCount;
    private Integer iPeriod;
    private String iDescription;
    private Date iPeriodStart;
    private Date iPeriodEnd;
    private boolean iAppendPeriod;
    private boolean iAppendInformation;
    private String iInformation;
    private List<SSInvoice> iInvoices;
    private Map<Integer, Boolean> iAdded;

    public SSPeriodicInvoice() {
        this.iDate = new Date();
        this.iCount = 1;
        this.iPeriod = 1;
        this.iAppendPeriod = false;
        this.iAppendInformation = false;
        this.iInformation = "Detta \u00e4r faktura [FAK] av [TOT].";
        this.iPeriodStart = SSDateMath.getFirstDayInMonth(this.iDate);
        this.iPeriodEnd = SSDateMath.getLastDayMonth(this.iDate);
        this.iInvoices = new LinkedList<SSInvoice>();
        this.iAdded = new HashMap<Integer, Boolean>();
        this.doAutoIncrecement();
    }

    public SSPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        this.copyFrom(iPeriodicInvoice);
    }

    public void copyFrom(SSPeriodicInvoice iPeriodicInvoice) {
        this.iNumber = iPeriodicInvoice.iNumber;
        this.iPeriod = iPeriodicInvoice.iPeriod;
        this.iDate = iPeriodicInvoice.iDate;
        this.iCount = iPeriodicInvoice.iCount;
        this.iDescription = iPeriodicInvoice.iDescription;
        this.iPeriodStart = iPeriodicInvoice.iPeriodStart;
        this.iPeriodEnd = iPeriodicInvoice.iPeriodEnd;
        this.iAppendPeriod = iPeriodicInvoice.iAppendPeriod;
        this.iAppendInformation = iPeriodicInvoice.iAppendInformation;
        this.iInformation = iPeriodicInvoice.iInformation;
        this.iTemplate = new SSInvoice(iPeriodicInvoice.iTemplate);
        this.iInvoices = new LinkedList<SSInvoice>();
        this.iAdded = new HashMap<Integer, Boolean>();
        this.iTemplate.setCurrency(iPeriodicInvoice.getTemplate().getCurrency());
        this.iTemplate.setCurrencyRate(iPeriodicInvoice.getTemplate().getCurrencyRate());
        for (SSInvoice iInvoice : iPeriodicInvoice.iInvoices) {
            boolean isAdded = iPeriodicInvoice.isAdded(iInvoice);
            this.iInvoices.add(new SSInvoice(iInvoice));
            this.iAdded.put(iInvoice.getNumber(), isAdded);
        }
    }

    public void doAutoIncrecement() {
        List<SSPeriodicInvoice> iPeriodicInvoices = SSDB.getInstance().getPeriodicInvoices();
        int iMax = 0;
        for (SSPeriodicInvoice iPeriodicInvoice : iPeriodicInvoices) {
            if (iPeriodicInvoice.iNumber == null || iPeriodicInvoice.iNumber <= iMax) continue;
            iMax = iPeriodicInvoice.iNumber;
        }
        this.iNumber = iMax + 1;
    }

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public SSInvoice getTemplate() {
        if (this.iTemplate == null) {
            this.iTemplate = new SSInvoice(SSInvoiceType.NORMAL);
        }
        return this.iTemplate;
    }

    public void setTemplate(SSInvoice iTemplate) {
        this.iTemplate = iTemplate;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iValue) {
        this.iDate = iValue;
    }

    public Integer getCount() {
        return this.iCount;
    }

    public void setCount(Integer iValue) {
        this.iCount = iValue;
    }

    public Integer getPeriod() {
        return this.iPeriod;
    }

    public void setPeriod(Integer iValue) {
        this.iPeriod = iValue;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public Date getPeriodStart() {
        return this.iPeriodStart;
    }

    public void setPeriodStart(Date iPeriodStart) {
        this.iPeriodStart = iPeriodStart;
    }

    public Date getPeriodEnd() {
        return this.iPeriodEnd;
    }

    public void setPeriodEnd(Date iPeriodEnd) {
        this.iPeriodEnd = iPeriodEnd;
    }

    public boolean getAppendPeriod() {
        return this.iAppendPeriod;
    }

    public void setAppendPeriod(boolean iAppendPeriod) {
        this.iAppendPeriod = iAppendPeriod;
    }

    public boolean isAppendInformation() {
        return this.iAppendInformation;
    }

    public void setAppendInformation(boolean iAppendInformation) {
        this.iAppendInformation = iAppendInformation;
    }

    public String getInformation() {
        return this.iInformation;
    }

    public void setInformation(String iInformation) {
        this.iInformation = iInformation;
    }

    public boolean isAdded(SSInvoice iInvoice) {
        Integer iNumber;
        if (this.iAdded == null) {
            this.iAdded = new HashMap<Integer, Boolean>();
        }
        if ((iNumber = iInvoice.getNumber()) != null) {
            return this.iAdded.get(iNumber);
        }
        return true;
    }

    public void setAdded(SSInvoice iInvoice) {
        Integer iNumber;
        if (this.iAdded == null) {
            this.iAdded = new HashMap<Integer, Boolean>();
        }
        if ((iNumber = iInvoice.getNumber()) != null) {
            this.iAdded.put(iNumber, true);
        }
    }

    public void setNotAdded(SSInvoice iInvoice) {
        if (this.iAdded == null) {
            return;
        }
        Integer iNumber = iInvoice.getNumber();
        if (iNumber != null) {
            this.iAdded.put(iNumber, false);
        }
    }

    private Map<Integer, Boolean> getAdded() {
        if (this.iAdded == null) {
            this.iAdded = new HashMap<Integer, Boolean>();
        }
        return this.iAdded;
    }

    public List<SSInvoice> getInvoices() {
        if (this.iInvoices == null) {
            this.iInvoices = new LinkedList<SSInvoice>();
        }
        return this.iInvoices;
    }

    public List<SSInvoice> getInvoices(Date iDate) {
        LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : this.getInvoices()) {
            if (this.isAdded(iInvoice) || !SSInvoiceMath.inPeriod(iInvoice, iDate)) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public Date getNextDate() {
        for (SSInvoice iInvoice : this.getInvoices()) {
            if (this.isAdded(iInvoice)) continue;
            return iInvoice.getDate();
        }
        return null;
    }

    public void createInvoices() {
        this.iInvoices = new LinkedList<SSInvoice>();
        if (this.iPeriod == null || this.iPeriodStart == null || this.iPeriodEnd == null || this.iTemplate == null) {
            return;
        }
        Date iDate = this.iDate;
        Date iPeriodStart = this.iPeriodStart;
        Date iPeriodEnd = this.iPeriodEnd;
        DateFormat iFormat = DateFormat.getDateInstance(3);
        for (int i = 0; i < this.iCount; ++i) {
            SSInvoice iInvoice = new SSInvoice(this.iTemplate);
            iInvoice.setDate(iDate);
            iInvoice.setDueDate();
            iInvoice.setNumber(i);
            iInvoice.setOrderNumbers(this.iTemplate.getOrderNumbers());
            if (this.iAppendPeriod) {
                String strPeriodStart = iFormat.format(iPeriodStart);
                String strPeriodEnd = iFormat.format(iPeriodEnd);
                SSSaleRow iRow = new SSSaleRow();
                iRow.setDescription(String.format(SSBundle.getBundle().getString("periodicinvoiceframe.invoiceperiod"), strPeriodStart, strPeriodEnd));
                iRow.setQuantity(null);
                iRow.setUnitprice(null);
                iRow.setTaxCode(null);
                iInvoice.getRows().add(iRow);
            }
            if (this.iAppendInformation) {
                String iInformationText = this.iInformation;
                if (iInformationText.contains("[FAK]")) {
                    iInformationText = iInformationText.replace("[FAK]", String.valueOf(i + 1));
                }
                if (iInformationText.contains("[TOT]")) {
                    iInformationText = iInformationText.replace("[TOT]", String.valueOf(this.iCount));
                }
                SSSaleRow iRow = new SSSaleRow();
                iRow.setDescription(iInformationText);
                iRow.setQuantity(null);
                iRow.setUnitprice(null);
                iRow.setTaxCode(null);
                iInvoice.getRows().add(iRow);
            }
            iDate = SSDateMath.addMonths(iDate, this.iPeriod);
            iPeriodStart = SSDateMath.addMonths(iPeriodStart, this.iPeriod);
            iPeriodEnd = SSDateMath.addMonths(iPeriodStart, this.iPeriod);
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iPeriodEnd);
            iCal.add(5, -1);
            iPeriodEnd = iCal.getTime();
            this.iInvoices.add(iInvoice);
        }
        if (this.iAdded == null || this.iAdded.size() != this.iInvoices.size()) {
            this.iAdded = new HashMap<Integer, Boolean>();
            for (SSInvoice iInvoice : this.iInvoices) {
                Integer iNumber = iInvoice.getNumber();
                this.iAdded.put(iNumber, false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSPeriodicInvoice)) {
            return false;
        }
        return this.iNumber.equals(((SSPeriodicInvoice)obj).iNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSPeriodicInvoice");
        sb.append("{iAdded=").append(this.iAdded);
        sb.append(", iAppendInformation=").append(this.iAppendInformation);
        sb.append(", iAppendPeriod=").append(this.iAppendPeriod);
        sb.append(", iCount=").append(this.iCount);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDescription='").append(this.iDescription).append('\'');
        sb.append(", iInformation='").append(this.iInformation).append('\'');
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPeriod=").append(this.iPeriod);
        sb.append(", iPeriodEnd=").append(this.iPeriodEnd);
        sb.append(", iPeriodStart=").append(this.iPeriodStart);
        sb.append(", iTemplate=").append(this.iTemplate);
        sb.append('}');
        return sb.toString();
    }
}

