/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.base.SSSale;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSTender
extends SSSale {
    static final long serialVersionUID = 1L;
    private Date iExpires;
    private Integer iOrderNr;
    protected BigDecimal iCurrencyRate;
    private transient SSOrder iOrder;

    public Integer getOrderNr() {
        return this.iOrderNr;
    }

    public SSTender() {
    }

    public SSTender(SSTender iTender) {
        this.copyFrom(iTender);
    }

    public void copyFrom(SSTender iTender) {
        super.copyFrom(iTender);
        this.iOrder = iTender.iOrder;
        this.iOrderNr = iTender.iOrderNr;
        this.iExpires = iTender.iExpires;
        this.iCurrencyRate = iTender.iCurrencyRate;
    }

    @Override
    public void doAutoIncrecement() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        int iNumber = iCompany.getAutoIncrement().getNumber("tender");
        for (SSTender iTender : SSDB.getInstance().getTenders()) {
            if (iTender.getNumber() == null || iTender.getNumber() <= iNumber) continue;
            iNumber = iTender.getNumber();
        }
        this.setNumber(iNumber + 1);
    }

    public Date getExpires() {
        return this.iExpires;
    }

    public void setExpires(Date iExpires) {
        this.iExpires = iExpires;
    }

    public BigDecimal getCurrencyRate() {
        if (this.iCurrencyRate != null) {
            return this.iCurrencyRate;
        }
        if (this.iCustomer != null) {
            return this.iCustomer.getInvoiceCurrency().getExchangeRate();
        }
        return new BigDecimal(1);
    }

    public void setCurrencyRate(BigDecimal iCurrencyRate) {
        this.iCurrencyRate = iCurrencyRate;
    }

    public SSOrder getOrder() {
        return this.getOrder(SSDB.getInstance().getOrders());
    }

    public SSOrder getOrder(List<SSOrder> iOrders) {
        if (this.iOrder == null && this.iOrderNr != null) {
            for (SSOrder iCurrent : iOrders) {
                if (!this.iOrderNr.equals(iCurrent.getNumber())) continue;
                this.iOrder = iCurrent;
            }
        }
        return this.iOrder;
    }

    public void setOrder(SSOrder iOrder) {
        this.iOrder = iOrder;
        this.iOrderNr = iOrder == null ? null : iOrder.getNumber();
    }

    public boolean hasOrder(SSOrder iOrder) {
        return this.iOrderNr != null && this.iOrderNr.equals(iOrder.getNumber());
    }

    public boolean isExpired() {
        if (this.iExpires == null) {
            return false;
        }
        return new Date().after(this.iExpires);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SSTender)) {
            return false;
        }
        return this.iNumber.equals(((SSTender)obj).getNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSTender");
        sb.append("{iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iExpires=").append(this.iExpires);
        sb.append(", iOrder=").append(this.iOrder);
        sb.append(", iOrderNr=").append(this.iOrderNr);
        sb.append('}');
        return sb.toString();
    }
}

