/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSVoucherRow
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Integer iAccountNr;
    private String iProjectNumber;
    private Integer iProjectNr;
    private String iResultUnitNumber;
    private Integer iResultUnitNr;
    private BigDecimal iDebet;
    private BigDecimal iCredit;
    private Date iEditedDate;
    private String iEditedSignature;
    private boolean iCrossed;
    private boolean iAdded;
    private SSAccount iAccount;
    private SSNewProject iProject;
    private SSNewResultUnit iResultUnit;

    public SSVoucherRow() {
    }

    public SSVoucherRow(SSAccount pAccount, BigDecimal pDebet, BigDecimal pCredit) {
        this.iAccount = pAccount;
        this.iDebet = pDebet;
        this.iCredit = pCredit;
    }

    public SSVoucherRow(SSAccount pAccount, BigDecimal pDebet, BigDecimal pCredit, SSNewProject pProject, SSNewResultUnit pResultUnit) {
        this.iAccount = pAccount;
        if (this.iAccount != null) {
            this.iAccountNr = pAccount.getNumber();
        }
        this.iDebet = pDebet;
        this.iCredit = pCredit;
        this.iProject = pProject;
        if (this.iProject != null) {
            this.iProjectNumber = pProject.getNumber();
        }
        this.iResultUnit = pResultUnit;
        if (this.iResultUnit != null) {
            this.iResultUnitNumber = pResultUnit.getNumber();
        }
    }

    public SSVoucherRow(SSVoucherRow pVoucherRow) {
        this.copyFrom(pVoucherRow);
    }

    public SSVoucherRow(SSVoucherRow pVoucherRow, boolean iReverse) {
        this.copyFrom(pVoucherRow);
        if (iReverse) {
            this.iDebet = pVoucherRow.iCredit;
            this.iCredit = pVoucherRow.iDebet;
        }
    }

    public void copyFrom(SSVoucherRow pVoucherRow) {
        this.iAccountNr = pVoucherRow.iAccountNr;
        this.iProjectNumber = pVoucherRow.iProjectNumber;
        this.iResultUnitNumber = pVoucherRow.iResultUnitNumber;
        this.iDebet = pVoucherRow.iDebet;
        this.iCredit = pVoucherRow.iCredit;
        this.iEditedDate = pVoucherRow.iEditedDate;
        this.iEditedSignature = pVoucherRow.iEditedSignature;
        this.iCrossed = pVoucherRow.iCrossed;
        this.iAdded = pVoucherRow.iAdded;
        this.iProject = pVoucherRow.iProject;
        this.iResultUnit = pVoucherRow.iResultUnit;
        this.iAccount = pVoucherRow.iAccount;
    }

    public Integer getAccountNr() {
        return this.iAccountNr;
    }

    public void setAccountNr(Integer iAccountNr) {
        this.iAccountNr = iAccountNr;
        this.iAccount = null;
    }

    public String getResultUnitNr() {
        return this.iResultUnitNumber;
    }

    public void setResultUnitNr(String iResultUnitNr) {
        this.iResultUnitNumber = iResultUnitNr;
        this.iResultUnit = null;
    }

    public String getProjectNr() {
        return this.iProjectNumber;
    }

    public void setProjectNr(String iProjectNr) {
        this.iProjectNumber = iProjectNr;
        this.iProject = null;
    }

    public void fixResultUnitAndProject() {
        if (this.iResultUnitNr != null && this.iResultUnitNumber == null) {
            this.iResultUnitNumber = this.iResultUnitNr.toString();
        }
        if (this.iProjectNr != null && this.iProjectNumber == null) {
            this.iProjectNumber = this.iProjectNr.toString();
        }
    }

    public BigDecimal getDebet() {
        return this.iDebet;
    }

    public void setDebet(BigDecimal pDebet) {
        this.iDebet = pDebet;
    }

    public BigDecimal getCredit() {
        return this.iCredit;
    }

    public void setCredit(BigDecimal pCredit) {
        this.iCredit = pCredit;
    }

    public Date getEditedDate() {
        return this.iEditedDate;
    }

    public void setEditedDate(Date pEditedDate) {
        this.iEditedDate = pEditedDate;
    }

    public String getEditedSignature() {
        return this.iEditedSignature;
    }

    public void setEditedSignature(String pEditedSignature) {
        this.iEditedSignature = pEditedSignature;
    }

    public boolean isCrossed() {
        return this.iCrossed;
    }

    public void setCrossed(boolean iCrossed) {
        this.iCrossed = iCrossed;
    }

    public void setCrossed(String pSignature) {
        this.iCrossed = true;
        this.iEditedDate = new Date();
        this.iEditedSignature = pSignature;
    }

    public boolean isAdded() {
        return this.iAdded;
    }

    public void setAdded(boolean iAdded) {
        this.iAdded = iAdded;
    }

    public void setAdded(String pSignature) {
        this.iAdded = true;
        this.iEditedDate = new Date();
        this.iEditedSignature = pSignature;
    }

    public SSAccount getAccount() {
        return this.getAccount(SSDB.getInstance().getAccounts());
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        if (this.iAccount == null && this.iAccountNr != null) {
            for (SSAccount iCurrent : iAccounts) {
                if (!this.iAccountNr.equals(iCurrent.getNumber())) continue;
                this.iAccount = iCurrent;
                break;
            }
        }
        return this.iAccount;
    }

    public void setAccount(SSAccount iAccount) {
        this.iAccount = iAccount;
        this.iAccountNr = iAccount == null ? null : iAccount.getNumber();
    }

    public SSNewProject getProject() {
        return this.getProject(SSDB.getInstance().getProjects());
    }

    public SSNewProject getProject(List<SSNewProject> iProjects) {
        if (this.iProject == null && this.iProjectNumber != null) {
            for (SSNewProject iCurrent : iProjects) {
                if (!this.iProjectNumber.equals(iCurrent.getNumber())) continue;
                this.iProject = iCurrent;
                break;
            }
        }
        return this.iProject;
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iProjectNumber = iProject == null ? null : iProject.getNumber();
    }

    public SSNewResultUnit getResultUnit() {
        return this.getResultUnit(SSDB.getInstance().getResultUnits());
    }

    public SSNewResultUnit getResultUnit(List<SSNewResultUnit> iResultUnits) {
        if (this.iResultUnit == null && this.iResultUnitNumber != null) {
            for (SSNewResultUnit iCurrent : iResultUnits) {
                if (!this.iResultUnitNumber.equals(iCurrent.getNumber())) continue;
                this.iResultUnit = iCurrent;
                break;
            }
        }
        return this.iResultUnit;
    }

    public void setResultUnit(SSNewResultUnit iResultUnit) {
        this.iResultUnit = iResultUnit;
        this.iResultUnitNumber = iResultUnit == null ? null : iResultUnit.getNumber();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.iAccount = null;
        this.iProject = null;
        this.iResultUnit = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.iAccount != null) {
            this.iAccountNr = this.iAccount.getNumber();
        }
        if (this.iProject != null) {
            this.iProjectNumber = this.iProject.getNumber();
        }
        if (this.iResultUnit != null) {
            this.iResultUnitNumber = this.iResultUnit.getNumber();
        }
        this.iAccount = null;
        this.iProject = null;
        this.iResultUnit = null;
    }

    public void setValue(BigDecimal iValue) {
        if (iValue == null) {
            return;
        }
        if (iValue.signum() > 0) {
            this.iDebet = iValue;
            this.iCredit = null;
        } else {
            this.iDebet = null;
            this.iCredit = iValue.abs();
        }
    }

    public BigDecimal getValue() {
        if (this.iDebet != null) {
            return this.iDebet;
        }
        if (this.iCredit != null) {
            return this.iCredit.negate();
        }
        return new BigDecimal(0);
    }

    public boolean isDebet() {
        return this.iDebet != null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.iCrossed) {
            b.append('-');
        }
        b.append(this.iAccountNr);
        b.append(", D=");
        b.append(this.iDebet);
        b.append(", C=");
        b.append(this.iCredit);
        if (this.iProjectNumber != null) {
            b.append(" (Project ");
            b.append(this.iProjectNumber);
            b.append(" )");
        }
        if (this.iResultUnitNumber != null) {
            b.append(" (Resultunit ");
            b.append(this.iResultUnitNumber);
            b.append(" )");
        }
        return b.toString();
    }

    public boolean isValid() {
        return this.getAccount() != null && (this.iDebet != null || this.iCredit != null);
    }

    public boolean isEmpty() {
        return this.iAccountNr == null && this.iDebet == null && this.iCredit == null;
    }

    public boolean hasAccount(SSAccount iAccount) {
        return this.iAccountNr != null && this.iAccountNr.equals(iAccount.getNumber());
    }
}

