/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSVoucherTemplate
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iDescription;
    private Date iDate;
    private List<SSVoucherTemplateRow> iRows;

    public SSVoucherTemplate() {
        this.iRows = new LinkedList<SSVoucherTemplateRow>();
        this.iDescription = null;
        this.iDate = new Date();
    }

    public SSVoucherTemplate(SSVoucher pVoucher) {
        this.iDescription = pVoucher.getDescription();
        this.iDate = new Date();
        this.iRows = new LinkedList<SSVoucherTemplateRow>();
        for (SSVoucherRow iVoucherRow : pVoucher.getRows()) {
            SSVoucherTemplateRow iTemplateRow = new SSVoucherTemplateRow();
            iTemplateRow.setAccount(iVoucherRow.getAccount());
            iTemplateRow.setDebet(iVoucherRow.getDebet());
            iTemplateRow.setCredit(iVoucherRow.getCredit());
            this.iRows.add(iTemplateRow);
        }
    }

    public void addToVoucher(SSVoucher pVoucher) {
        pVoucher.setDescription(this.iDescription);
        for (SSVoucherTemplateRow iTemplateRow : this.iRows) {
            SSVoucherRow iVoucherRow = new SSVoucherRow();
            if (SSVoucherMath.hasAccount(pVoucher, iTemplateRow.getAccount())) continue;
            iVoucherRow.setAccount(iTemplateRow.getAccount());
            iVoucherRow.setDebet(iTemplateRow.getDebet());
            iVoucherRow.setCredit(iTemplateRow.getCredit());
            pVoucher.addVoucherRow(iVoucherRow);
        }
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public List<SSVoucherTemplateRow> getRows() {
        return this.iRows;
    }

    public void setRows(List<SSVoucherTemplateRow> iRows) {
        this.iRows = iRows;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.iDescription);
        b.append('\n');
        return b.toString();
    }

    @Override
    public String toRenderString() {
        return this.iDescription;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSVoucherTemplate)) {
            return false;
        }
        return this.iDescription.equals(((SSVoucherTemplate)obj).iDescription);
    }

    public static final class SSVoucherTemplateRow
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Integer iAccountNr = null;
        private Boolean iDebet = false;
        private SSAccount iAccount = null;

        public Integer getAccountNr() {
            return this.iAccountNr;
        }

        public void setAccountNr(Integer iAccountNr) {
            this.iAccountNr = iAccountNr;
            this.iAccount = null;
        }

        public BigDecimal getDebet() {
            return this.iDebet != false ? new BigDecimal(0) : null;
        }

        public BigDecimal getCredit() {
            return this.iDebet != false ? null : new BigDecimal(0);
        }

        public void setDebet(BigDecimal iDebet) {
            this.iDebet = iDebet != null;
        }

        public void setCredit(BigDecimal iCredit) {
            this.iDebet = iCredit == null;
        }

        public SSAccount getAccount() {
            return this.getAccount(SSDB.getInstance().getAccounts());
        }

        public SSAccount getAccount(List<SSAccount> iAccounts) {
            if (this.iAccount == null && this.iAccountNr != null) {
                for (SSAccount iCurrent : iAccounts) {
                    if (!this.iAccountNr.equals(iCurrent.getNumber())) continue;
                    this.iAccount = iCurrent;
                    break;
                }
            }
            return this.iAccount;
        }

        public void setAccount(SSAccount iAccount) {
            this.iAccount = iAccount;
            this.iAccountNr = iAccount == null ? null : iAccount.getNumber();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.iAccount = null;
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.iAccount != null) {
                this.iAccountNr = this.iAccount.getNumber();
            }
            this.iAccount = null;
        }
    }
}

