/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.backup.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupZip;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSSystemCompany;
import se.swedsoft.bookkeeping.data.system.SSSystemYear;

public class SSBackupUtils {
    private SSBackupUtils() {
    }

    public static List<SSBackupZip.ArchiveFile> getFiles() {
        LinkedList<SSBackupZip.ArchiveFile> iFiles = new LinkedList<SSBackupZip.ArchiveFile>();
        if (!SSDB.getInstance().getLocking()) {
            iFiles.add(new SSBackupZip.ArchiveFile(new File("db" + File.separator + "JFSDB.properties")));
            iFiles.add(new SSBackupZip.ArchiveFile(new File("db" + File.separator + "JFSDB.script")));
            iFiles.add(new SSBackupZip.ArchiveFile(new File("db" + File.separator + "JFSDB.data")));
            iFiles.add(new SSBackupZip.ArchiveFile(new File("db" + File.separator + "JFSDB.backup")));
            iFiles.add(new SSBackupZip.ArchiveFile(new File("db" + File.separator + "JFSDB.log")));
        }
        return iFiles;
    }

    public static List<SSBackupZip.ArchiveFile> getFiles(SSSystemCompany pCompany) {
        LinkedList<SSBackupZip.ArchiveFile> iFiles = new LinkedList<SSBackupZip.ArchiveFile>();
        for (SSSystemYear sSSystemYear : pCompany.getYears()) {
        }
        return iFiles;
    }

    public static List<SSBackupZip.ArchiveFile> getFiles(String pFilename, String iDirectory) throws FileNotFoundException, IOException {
        LinkedList<SSBackupZip.ArchiveFile> iFiles = new LinkedList<SSBackupZip.ArchiveFile>();
        for (String iName : SSBackupZip.getFiles(pFilename)) {
            if (iName.equals("backup.info")) continue;
            File iFile = new File(iDirectory + iName);
            iFiles.add(new SSBackupZip.ArchiveFile(iFile, iName));
        }
        return iFiles;
    }
}

