/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.backup.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class SSBackupZip {
    private SSBackupZip() {
    }

    public static void compressFiles(String pFilename, List<ArchiveFile> iFiles) throws FileNotFoundException, IOException {
        ZipOutputStream iZipOutputStream = new ZipOutputStream(new FileOutputStream(pFilename));
        iZipOutputStream.setLevel(-1);
        byte[] buffer = new byte[18024];
        for (ArchiveFile iArchiveFile : iFiles) {
            int iBytesRead;
            FileInputStream iFileInputStream = new FileInputStream(iArchiveFile.file);
            ZipEntry iEntry = new ZipEntry(iArchiveFile.name);
            iZipOutputStream.putNextEntry(iEntry);
            while ((iBytesRead = iFileInputStream.read(buffer)) > 0) {
                iZipOutputStream.write(buffer, 0, iBytesRead);
            }
            iZipOutputStream.closeEntry();
            iFileInputStream.close();
        }
        iZipOutputStream.close();
    }

    public static List<String> getFiles(String pFilename) throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(new File(pFilename), 1);
        Enumeration<? extends ZipEntry> iEntries = zipFile.entries();
        LinkedList<String> iFiles = new LinkedList<String>();
        while (iEntries.hasMoreElements()) {
            ZipEntry iEntry = iEntries.nextElement();
            iFiles.add(iEntry.getName());
        }
        return iFiles;
    }

    public static void extractFiles(String pFilename, List<ArchiveFile> iFiles) throws FileNotFoundException, IOException {
        ZipFile iZipFile = new ZipFile(new File(pFilename), 1);
        Enumeration<? extends ZipEntry> iEntries = iZipFile.entries();
        byte[] buffer = new byte[18024];
        while (iEntries.hasMoreElements()) {
            int iBytesRead;
            ZipEntry iEntry = iEntries.nextElement();
            ArchiveFile iFile = null;
            for (ArchiveFile iCurrent : iFiles) {
                if (!iEntry.getName().equals(iCurrent.name)) continue;
                iFile = iCurrent;
            }
            if (iFile == null) continue;
            File iParent = iFile.file.getParentFile();
            iParent.mkdirs();
            if (iEntry.isDirectory()) continue;
            BufferedInputStream iBufferedInputStream = new BufferedInputStream(iZipFile.getInputStream(iEntry));
            BufferedOutputStream iBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(iFile.file));
            while ((iBytesRead = iBufferedInputStream.read(buffer)) > 0) {
                iBufferedOutputStream.write(buffer, 0, iBytesRead);
            }
            iBufferedOutputStream.flush();
            iBufferedOutputStream.close();
            iBufferedInputStream.close();
        }
        iZipFile.close();
    }

    public static boolean extractFile(String pFilename, ArchiveFile iFile) throws FileNotFoundException, IOException {
        ZipFile iZipFile = new ZipFile(new File(pFilename), 1);
        Enumeration<? extends ZipEntry> iEntries = iZipFile.entries();
        byte[] buffer = new byte[18024];
        while (iEntries.hasMoreElements()) {
            ZipEntry iEntry = iEntries.nextElement();
            if (!iEntry.getName().equals(iFile.name)) continue;
            File iParent = iFile.file.getParentFile();
            iParent.mkdirs();
            if (!iEntry.isDirectory()) {
                int iBytesRead;
                BufferedInputStream iBufferedInputStream = new BufferedInputStream(iZipFile.getInputStream(iEntry));
                BufferedOutputStream iBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(iFile.file));
                while ((iBytesRead = iBufferedInputStream.read(buffer)) > 0) {
                    iBufferedOutputStream.write(buffer, 0, iBytesRead);
                }
                iBufferedOutputStream.flush();
                iBufferedOutputStream.close();
                iBufferedInputStream.close();
            }
            iZipFile.close();
            return true;
        }
        iZipFile.close();
        return false;
    }

    public static class ArchiveFile {
        private String name;
        private File file;

        public ArchiveFile() {
            this.name = null;
            this.file = null;
        }

        public ArchiveFile(File pFile, String pName) {
            this.file = pFile;
            this.name = pName;
        }

        public ArchiveFile(File pFile) {
            this.file = pFile;
            this.name = pFile.getName();
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public File getFile() {
            return this.file;
        }
    }
}

