/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.base;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public abstract class SSSale
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    protected Integer iNumber;
    protected Date iDate;
    protected String iCustomerNr;
    protected String iCustomerName;
    protected String iOurContactPerson;
    protected String iYourContactPerson;
    protected BigDecimal iDelayInterest;
    protected SSCurrency iCurrency;
    protected SSPaymentTerm iPaymentTerm;
    protected SSDeliveryTerm iDeliveryTerm;
    protected SSDeliveryWay iDeliveryWay;
    protected boolean iTaxFree;
    protected String iText;
    protected BigDecimal iTaxRate1;
    protected BigDecimal iTaxRate2;
    protected BigDecimal iTaxRate3;
    private boolean iEuSaleCommodity;
    private boolean iEuSaleYhirdPartCommodity;
    protected SSAddress iInvoiceAddress;
    protected SSAddress iDeliveryAddress;
    protected boolean iPrinted;
    protected Map<SSDefaultAccount, Integer> iDefaultAccounts;
    protected List<SSSaleRow> iRows;
    protected transient SSCustomer iCustomer;

    public SSSale() {
        this.iDate = new Date();
        this.iInvoiceAddress = new SSAddress();
        this.iDeliveryAddress = new SSAddress();
        this.iRows = new LinkedList<SSSaleRow>();
        this.iPrinted = false;
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iPaymentTerm = iCompany.getPaymentTerm();
            this.iDeliveryTerm = iCompany.getDeliveryTerm();
            this.iDeliveryWay = iCompany.getDeliveryWay();
            this.iCurrency = iCompany.getCurrency();
        }
    }

    public SSSale(SSSale iSale) {
        this.copyFrom(iSale);
    }

    public SSSale(SSSale iSale, Integer iNumber) {
        this.copyFrom(iSale);
        this.iNumber = iNumber;
    }

    public void copyFrom(SSSale iSale) {
        this.iNumber = iSale.iNumber;
        this.iDate = iSale.iDate;
        this.iCustomerNr = iSale.iCustomerNr;
        this.iCustomerName = iSale.iCustomerName;
        this.iOurContactPerson = iSale.iOurContactPerson;
        this.iYourContactPerson = iSale.iYourContactPerson;
        this.iDelayInterest = iSale.iDelayInterest;
        this.iCurrency = iSale.iCurrency;
        this.iPaymentTerm = iSale.iPaymentTerm;
        this.iDeliveryTerm = iSale.iDeliveryTerm;
        this.iDeliveryWay = iSale.iDeliveryWay;
        this.iTaxFree = iSale.iTaxFree;
        this.iText = iSale.iText;
        this.iTaxRate1 = iSale.iTaxRate1;
        this.iTaxRate2 = iSale.iTaxRate2;
        this.iTaxRate3 = iSale.iTaxRate3;
        this.iEuSaleCommodity = iSale.iEuSaleCommodity;
        this.iEuSaleYhirdPartCommodity = iSale.iEuSaleYhirdPartCommodity;
        this.iPrinted = iSale.iPrinted;
        this.iCustomer = null;
        this.iInvoiceAddress = new SSAddress(iSale.iInvoiceAddress);
        this.iDeliveryAddress = new SSAddress(iSale.iDeliveryAddress);
        this.iRows = new LinkedList<SSSaleRow>();
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        for (SSSaleRow iRow : iSale.iRows) {
            this.iRows.add(new SSSaleRow(iRow));
        }
        for (SSDefaultAccount iDefaultAccount : iSale.getDefaultAccounts().keySet()) {
            this.iDefaultAccounts.put(iDefaultAccount, iSale.getDefaultAccounts().get(iDefaultAccount));
        }
    }

    public abstract void doAutoIncrecement();

    public Integer getNumber() {
        return this.iNumber;
    }

    public void setNumber(Integer iNumber) {
        this.iNumber = iNumber;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public String getCustomerNr() {
        return this.iCustomerNr;
    }

    public void setCustomerNr(String iCustomerNr) {
        this.iCustomerNr = iCustomerNr;
    }

    public String getCustomerName() {
        return this.iCustomerName;
    }

    public void setCustomerName(String iCustomerName) {
        this.iCustomerName = iCustomerName;
    }

    public String getOurContactPerson() {
        return this.iOurContactPerson;
    }

    public void setOurContactPerson(String iOurContactPerson) {
        this.iOurContactPerson = iOurContactPerson;
    }

    public String getYourContactPerson() {
        return this.iYourContactPerson;
    }

    public void setYourContactPerson(String iYourContactPerson) {
        this.iYourContactPerson = iYourContactPerson;
    }

    public BigDecimal getDelayInterest() {
        if (this.iDelayInterest == null) {
            this.iDelayInterest = new BigDecimal(0);
        }
        return this.iDelayInterest;
    }

    public void setDelayInterest(BigDecimal iDelayInterest) {
        this.iDelayInterest = iDelayInterest;
    }

    public SSCurrency getCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public boolean getTaxFree() {
        return this.iTaxFree;
    }

    public void setTaxFree(boolean iTaxFree) {
        this.iTaxFree = iTaxFree;
    }

    public BigDecimal getTaxRate1() {
        if (this.iTaxRate1 == null) {
            this.iTaxRate1 = new BigDecimal(25);
        }
        return this.iTaxRate1;
    }

    public void setTaxRate1(BigDecimal iTaxRate1) {
        this.iTaxRate1 = iTaxRate1;
    }

    public BigDecimal getTaxRate2() {
        return this.iTaxRate2;
    }

    public void setTaxRate2(BigDecimal iTaxRate2) {
        if (iTaxRate2 == null) {
            iTaxRate2 = new BigDecimal(12);
        }
        this.iTaxRate2 = iTaxRate2;
    }

    public BigDecimal getTaxRate3() {
        if (this.iTaxRate3 == null) {
            this.iTaxRate3 = new BigDecimal(6);
        }
        return this.iTaxRate3;
    }

    public void setTaxRate3(BigDecimal iTaxRate3) {
        this.iTaxRate3 = iTaxRate3;
    }

    public boolean getEuSaleCommodity() {
        return this.iEuSaleCommodity;
    }

    public void setEuSaleCommodity(boolean iEuSaleCommodity) {
        this.iEuSaleCommodity = iEuSaleCommodity;
    }

    public boolean getEuSaleThirdPartCommodity() {
        return this.iEuSaleYhirdPartCommodity;
    }

    public void setEuSaleYhirdPartCommodity(boolean iEuSaleYhirdPartCommodity) {
        this.iEuSaleYhirdPartCommodity = iEuSaleYhirdPartCommodity;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iTenderText) {
        this.iText = iTenderText;
    }

    public boolean isPrinted() {
        return this.iPrinted;
    }

    public void setPrinted(boolean iPrinted) {
        this.iPrinted = iPrinted;
    }

    public void setPrinted() {
        this.iPrinted = true;
    }

    public SSAddress getInvoiceAddress() {
        return this.iInvoiceAddress;
    }

    public void setInvoiceAddress(SSAddress iInvoiceAddress) {
        this.iInvoiceAddress = iInvoiceAddress;
    }

    public SSAddress getDeliveryAddress() {
        return this.iDeliveryAddress;
    }

    public void setDeliveryAddress(SSAddress iDeliveryAddress) {
        this.iDeliveryAddress = iDeliveryAddress;
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        return this.iDefaultAccounts;
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.iDefaultAccounts.get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        return this.iDefaultAccounts.get(iDefaultAccount);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iDefaultAccounts.putAll(iDefaultAccounts);
    }

    public List<SSSaleRow> getRows() {
        if (this.iRows == null) {
            this.iRows = new LinkedList<SSSaleRow>();
        }
        return this.iRows;
    }

    public void setRows(List<SSSaleRow> iRows) {
        this.iRows = iRows;
    }

    public void setRows(SSSaleRow ... iRows) {
        this.iRows = new LinkedList<SSSaleRow>();
        this.iRows.addAll(Arrays.asList(iRows));
    }

    public SSCustomer getCustomer() {
        return this.getCustomer(SSDB.getInstance().getCustomers());
    }

    public SSCustomer getCustomer(List<SSCustomer> iCustomers) {
        if (this.iCustomer == null) {
            for (SSCustomer iCurrent : iCustomers) {
                String iNumber = iCurrent.getNumber();
                if (iNumber == null || !iNumber.equals(this.iCustomerNr)) continue;
                this.iCustomer = iCurrent;
                break;
            }
        }
        return this.iCustomer;
    }

    public void setCustomer(SSCustomer iCustomer) {
        this.iCustomer = iCustomer;
        this.iCustomerName = iCustomer.getName();
        this.iCustomerNr = iCustomer.getNumber();
        this.iYourContactPerson = iCustomer.getYourContactPerson();
        this.iOurContactPerson = iCustomer.getOurContactPerson();
        this.iPaymentTerm = iCustomer.getPaymentTerm();
        this.iDeliveryTerm = iCustomer.getDeliveryTerm();
        this.iDeliveryWay = iCustomer.getDeliveryWay();
        this.iCurrency = iCustomer.getInvoiceCurrency();
        this.iTaxFree = iCustomer.getTaxFree();
        this.iEuSaleCommodity = iCustomer.getEuSaleCommodity();
        this.iEuSaleYhirdPartCommodity = iCustomer.getEuSaleYhirdPartCommodity();
        this.iInvoiceAddress = new SSAddress(iCustomer.getInvoiceAddress());
        this.iDeliveryAddress = new SSAddress(iCustomer.getDeliveryAddress());
    }

    public BigDecimal getNormalizedTaxRate1() {
        return this.iTaxRate1 == null ? new BigDecimal("0.25") : this.iTaxRate1.scaleByPowerOfTen(-2);
    }

    public BigDecimal getNormalizedTaxRate2() {
        return this.iTaxRate2 == null ? new BigDecimal("0.12") : this.iTaxRate2.scaleByPowerOfTen(-2);
    }

    public BigDecimal getNormalizedTaxRate3() {
        return this.iTaxRate3 == null ? new BigDecimal("0.06") : this.iTaxRate3.scaleByPowerOfTen(-2);
    }

    public boolean equals(Object obj) {
        if (this.iNumber == null) {
            return false;
        }
        if (obj instanceof SSSale) {
            SSSale iSale = (SSSale)obj;
            return this.iNumber.equals(iSale.iNumber);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iNumber);
        sb.append(", ");
        sb.append(this.iCustomerNr);
        sb.append(", ");
        sb.append(this.iCustomerName);
        sb.append(") {\n");
        for (SSSaleRow iRow : this.iRows) {
            sb.append("  ");
            sb.append(iRow);
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.iNumber;
    }

    @Override
    public String toRenderString() {
        return this.iNumber == null ? "" : this.iNumber.toString();
    }
}

