/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.common;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSPaymentTerm
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iName;
    private String iDescription;

    public SSPaymentTerm() {
    }

    public SSPaymentTerm(String pName, String pDescription) {
        this.iName = pName;
        this.iDescription = pDescription;
    }

    public void dispose() {
        this.iName = null;
        this.iDescription = null;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public Integer decodeValue() {
        try {
            return Integer.decode(this.iName);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Date addDaysToDate(Date iDate) {
        int iDays = this.decodeValue();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(5, iDays);
        return iCalendar.getTime();
    }

    @Override
    public String toRenderString() {
        return this.iName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSPaymentTerm) {
            SSPaymentTerm iUnit = (SSPaymentTerm)obj;
            return this.iName.equals(iUnit.iName);
        }
        return false;
    }

    public String toString() {
        return this.iDescription;
    }

    public static List<SSPaymentTerm> getDefaultPaymentTerms() {
        LinkedList<SSPaymentTerm> iPaymentTerms = new LinkedList<SSPaymentTerm>();
        iPaymentTerms.add(new SSPaymentTerm("K", "Kontant"));
        iPaymentTerms.add(new SSPaymentTerm("PF", "Postf\u00f6rskott"));
        iPaymentTerms.add(new SSPaymentTerm("30", "30 dagar netto"));
        iPaymentTerms.add(new SSPaymentTerm("52", "10 dagar netto"));
        iPaymentTerms.add(new SSPaymentTerm("10", "10 dagar netto"));
        return iPaymentTerms;
    }
}

