/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.common;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSUnit
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iName;
    private String iDescription;

    public SSUnit() {
    }

    public SSUnit(String pName, String pDescription) {
        this.iName = pName;
        this.iDescription = pDescription;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    @Override
    public String toRenderString() {
        return this.iName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SSUnit) {
            SSUnit iUnit = (SSUnit)obj;
            return this.iName.equals(iUnit.iName);
        }
        return false;
    }

    public String toString() {
        return this.iName;
    }

    public static List<SSUnit> getDefaultUnits() {
        LinkedList<SSUnit> iUnits = new LinkedList<SSUnit>();
        iUnits.add(new SSUnit("st", SSBundle.getBundle().getString("ssunit.unit.pcs")));
        iUnits.add(new SSUnit("m", SSBundle.getBundle().getString("ssunit.unit.meter")));
        iUnits.add(new SSUnit("H", SSBundle.getBundle().getString("ssunit.unit.hours")));
        iUnits.add(new SSUnit("pkt", SSBundle.getBundle().getString("ssunit.unit.frp")));
        return iUnits;
    }

    public static SSUnit decode(String iValue) {
        List<SSUnit> iUnits = SSDB.getInstance().getUnits();
        for (SSUnit iUnit : iUnits) {
            if (!iValue.equals(iUnit.iName) && !iValue.equals(iUnit.iDescription)) continue;
            return iUnit;
        }
        return null;
    }
}

