/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.UID;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.SSTriggerHandler;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSCustomerMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierMath;
import se.swedsoft.bookkeeping.calc.util.SSAutoIncrement;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAccountingYear;
import se.swedsoft.bookkeeping.data.SSAutoDist;
import se.swedsoft.bookkeeping.data.SSCompany;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProject;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSResultUnit;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.SSVoucherTemplate;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupZip;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSCompanyLock;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSDBUtils;
import se.swedsoft.bookkeeping.data.system.SSSystemCompany;
import se.swedsoft.bookkeeping.data.system.SSSystemData;
import se.swedsoft.bookkeeping.data.system.SSSystemYear;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.autodist.SSAutoDistFrame;
import se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.customer.SSCustomerFrame;
import se.swedsoft.bookkeeping.gui.indelivery.SSIndeliveryFrame;
import se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentFrame;
import se.swedsoft.bookkeeping.gui.inventory.SSInventoryFrame;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceFrame;
import se.swedsoft.bookkeeping.gui.order.SSOrderFrame;
import se.swedsoft.bookkeeping.gui.outdelivery.SSOutdeliveryFrame;
import se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentFrame;
import se.swedsoft.bookkeeping.gui.ownreport.SSOwnReportFrame;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceFrame;
import se.swedsoft.bookkeeping.gui.product.SSProductFrame;
import se.swedsoft.bookkeeping.gui.project.SSProjectFrame;
import se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderFrame;
import se.swedsoft.bookkeeping.gui.resultunit.SSResultUnitFrame;
import se.swedsoft.bookkeeping.gui.supplier.SSSupplierFrame;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceFrame;
import se.swedsoft.bookkeeping.gui.tender.SSTenderFrame;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.voucher.SSVoucherFrame;
import se.swedsoft.bookkeeping.gui.vouchertemplate.SSVoucherTemplateFrame;
import se.swedsoft.bookkeeping.importexport.excel.SSAccountPlanImporter;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.util.SSUtil;

public class SSDB {
    private static SSDB cInstance;
    private SSNewCompany iCurrentCompany;
    private SSNewAccountingYear iCurrentYear;
    List<SSProduct> iProducts;
    List<SSCustomer> iCustomers;
    List<SSSupplier> iSuppliers;
    List<SSAutoDist> iAutoDists;
    List<SSInpayment> iInpayments;
    List<SSTender> iTenders;
    List<SSOrder> iOrders;
    List<SSInvoice> iInvoices;
    List<SSCreditInvoice> iCreditInvoices;
    List<SSPeriodicInvoice> iPeriodicInvoices;
    List<SSOutpayment> iOutpayments;
    List<SSPurchaseOrder> iPurchaseOrders;
    List<SSSupplierInvoice> iSupplierInvoices;
    List<SSSupplierCreditInvoice> iSupplierCreditInvoices;
    List<SSInventory> iInventories;
    List<SSIndelivery> iIndeliveries;
    List<SSOutdelivery> iOutdeliveries;
    List<SSVoucher> iVouchers;
    List<SSOwnReport> iOwnReports;
    public static final Object iSyncObject;
    Connection iConnection;
    private Socket iSocket;
    private BufferedReader iIn;
    private PrintWriter iOut;
    private boolean iLocking;
    private Map<String, List<PropertyChangeListener>> iListenerMap = new HashMap<String, List<PropertyChangeListener>>();

    public static SSDB getInstance() {
        if (cInstance == null) {
            cInstance = new SSDB();
        }
        return cInstance;
    }

    private SSDB() {
    }

    public boolean getLocking() {
        return this.iLocking;
    }

    public void startupLocal(Connection pConnection) throws SQLException {
        ResultSet iResultSet;
        PreparedStatement iStatement;
        this.iConnection = pConnection;
        this.iConnection.setAutoCommit(false);
        this.iLocking = false;
        this.createNewTables();
        this.createLocalTriggers();
        this.checkCreateExampleCompany();
        this.checkImportDefaultAccountPlans();
        Integer iLastCompany = SSDBConfig.getCompanyId();
        Integer iLastYear = SSDBConfig.getYearId();
        if (iLastCompany != null) {
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_company WHERE id=?");
            iStatement.setObject(1, iLastCompany);
            iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewCompany iCompany = (SSNewCompany)iResultSet.getObject("company");
                this.setCurrentCompany(iCompany);
            }
            iResultSet.close();
            iStatement.close();
        }
        if (iLastYear != null && this.iCurrentCompany != null) {
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE id=?");
            iStatement.setObject(1, iLastYear);
            iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewAccountingYear iYear = (SSNewAccountingYear)iResultSet.getObject("accountingyear");
                this.setCurrentYear(iYear);
            }
            iResultSet.close();
            iStatement.close();
        }
    }

    public void startupRemote(Connection pConnection, String iServerAddress) throws SQLException {
        ResultSet iResultSet;
        PreparedStatement iStatement;
        this.iConnection = pConnection;
        this.iConnection.setAutoCommit(false);
        this.createNewTables();
        this.createServerTriggers();
        String iKey = SSDBConfig.getClientkey();
        try {
            if (iKey != null && iKey.length() != 0) {
                iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_license VALUES(?)");
                iStatement.setObject(1, iKey);
                iStatement.executeUpdate();
                iStatement.close();
            }
        }
        catch (SQLException e) {
            new SSErrorDialog(SSMainFrame.getInstance(), "database.duplicateclient");
            System.exit(0);
        }
        try {
            this.openSocket(iServerAddress);
            this.iLocking = true;
            SSTriggerHandler iTriggerHandler = new SSTriggerHandler();
            iTriggerHandler.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.iLocking = true;
        Integer iLastCompany = SSDBConfig.getCompanyId();
        Integer iLastYear = SSDBConfig.getYearId();
        if (iLastCompany != null) {
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_company WHERE id=?");
            iStatement.setObject(1, iLastCompany);
            iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewCompany iCompany = (SSNewCompany)iResultSet.getObject("company");
                this.setCurrentCompany(iCompany);
                SSCompanyLock.applyLock(iCompany);
            }
            iResultSet.close();
            iStatement.close();
        }
        if (iLastYear != null && this.iCurrentCompany != null) {
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE id=?");
            iStatement.setObject(1, iLastYear);
            iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewAccountingYear iYear = (SSNewAccountingYear)iResultSet.getObject("accountingyear");
                this.setCurrentYear(iYear);
                SSYearLock.applyLock(iYear);
            }
            iResultSet.close();
            iStatement.close();
        }
    }

    public void init(boolean iShowDialog) {
        if (this.iCurrentCompany == null) {
            return;
        }
        if (iShowDialog) {
            SSInitDialog.runProgress(SSMainFrame.getInstance(), "L\u00e4ser in data", new Runnable(){

                @Override
                public void run() {
                    SSDB.this.getProducts();
                    SSDB.this.getCustomers();
                    SSDB.this.getSuppliers();
                    SSDB.this.getAutoDists();
                    SSDB.this.getInpayments();
                    SSDB.this.getTenders();
                    SSDB.this.getOrders();
                    SSDB.this.getInvoices();
                    SSDB.this.getCreditInvoices();
                    SSDB.this.getPeriodicInvoices();
                    SSDB.this.getOutpayments();
                    SSDB.this.getPurchaseOrders();
                    SSDB.this.getSupplierInvoices();
                    SSDB.this.getSupplierCreditInvoices();
                    SSDB.this.getInventories();
                    SSDB.this.getIndeliveries();
                    SSDB.this.getOutdeliveries();
                    SSDB.this.getOwnReports();
                    SSInvoiceMath.iSaldoMap = null;
                    SSInvoiceMath.calculateSaldos();
                    SSCustomerMath.iInvoicesForCustomers = null;
                    SSCustomerMath.getInvoicesForCustomers();
                    SSSupplierInvoiceMath.iSaldoMap = null;
                    SSSupplierInvoiceMath.calculateSaldos();
                    SSSupplierMath.iInvoicesForSuppliers = null;
                    SSSupplierMath.getInvoicesForSuppliers();
                    SSDB.this.initYear(false);
                }
            });
        } else {
            this.getProducts();
            this.getCustomers();
            this.getSuppliers();
            this.getAutoDists();
            this.getInpayments();
            this.getTenders();
            this.getOrders();
            this.getInvoices();
            this.getCreditInvoices();
            this.getPeriodicInvoices();
            this.getOutpayments();
            this.getPurchaseOrders();
            this.getSupplierInvoices();
            this.getSupplierCreditInvoices();
            this.getInventories();
            this.getIndeliveries();
            this.getOutdeliveries();
            this.getOwnReports();
            SSInvoiceMath.iSaldoMap = null;
            SSInvoiceMath.calculateSaldos();
            SSCustomerMath.iInvoicesForCustomers = null;
            SSCustomerMath.getInvoicesForCustomers();
            SSSupplierInvoiceMath.iSaldoMap = null;
            SSSupplierInvoiceMath.calculateSaldos();
            SSSupplierMath.iInvoicesForSuppliers = null;
            SSSupplierMath.getInvoicesForSuppliers();
            this.initYear(false);
        }
    }

    public void initYear(boolean iShowLoadingDialog) {
        if (this.iCurrentYear == null) {
            return;
        }
        this.iVouchers = null;
        this.getCurrentYear();
        if (iShowLoadingDialog) {
            SSInitDialog.runProgress(SSMainFrame.getInstance(), "L\u00e4ser in data", new Runnable(){

                @Override
                public void run() {
                    SSDB.this.getVouchers();
                }
            });
        } else {
            this.getVouchers();
        }
    }

    public void shutdown() {
        if (!this.iLocking) {
            try {
                if (!this.iConnection.isClosed()) {
                    Statement iStatement = this.iConnection.createStatement();
                    iStatement.executeQuery("SHUTDOWN");
                    iStatement.close();
                    this.iConnection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            SSCompanyLock.removeLock(this.iCurrentCompany);
            SSYearLock.removeLock(this.iCurrentYear);
        }
    }

    public void shutdownCompact() {
        if (!this.iLocking) {
            try {
                Statement iStatement = this.iConnection.createStatement();
                iStatement.executeQuery("SHUTDOWN COMPACT");
                iStatement.close();
                this.iConnection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            SSCompanyLock.removeLock(this.iCurrentCompany);
            SSYearLock.removeLock(this.iCurrentYear);
        }
    }

    public void openSocket(String iIpAddress) throws IOException {
        Socket iOldSocket = this.iSocket;
        PrintWriter iOldWriter = this.iOut;
        BufferedReader iOldReader = this.iIn;
        this.iSocket = new Socket(iIpAddress, 2222);
        this.iOut = new PrintWriter(new OutputStreamWriter(this.iSocket.getOutputStream()));
        this.iIn = new BufferedReader(new InputStreamReader(this.iSocket.getInputStream()));
        if (iOldSocket != null) {
            iOldWriter.println("disconnect");
            iOldWriter.flush();
            iOldWriter.close();
            iOldReader.close();
            iOldSocket.close();
        }
    }

    public void setLocking(boolean iLock) {
        this.iLocking = iLock;
    }

    public void loadSelectedDatabase(String iAddress) {
        if (!this.iLocking && this.iConnection != null) {
            try {
                Statement iStatement = this.iConnection.createStatement();
                iStatement.executeQuery("SHUTDOWN");
                iStatement.close();
                this.iConnection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.iConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            }
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("ERROR: failed to load HSQLDB JDBC driver.");
            e.printStackTrace();
            return;
        }
        try {
            this.iConnection = DriverManager.getConnection("jdbc:hsqldb:hsql://" + iAddress + "/JFSDB", "sa", "");
            this.iLocking = true;
            this.iConnection.setAutoCommit(false);
            String iKey = SSDBConfig.getClientkey();
            try {
                if (iKey != null && iKey.length() != 0) {
                    PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_license VALUES(?)");
                    iStatement.setObject(1, iKey);
                    iStatement.executeUpdate();
                    this.iConnection.commit();
                    iStatement.close();
                }
            }
            catch (SQLException e) {
                new SSErrorDialog(SSMainFrame.getInstance(), "database.duplicateclient");
                System.exit(0);
            }
            this.createNewTables();
            this.dropTriggers();
            this.createServerTriggers();
            SSTriggerHandler iTriggerHandler = new SSTriggerHandler();
            iTriggerHandler.start();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void loadLocalDatabase() {
        try {
            if (this.iConnection != null) {
                this.iConnection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("ERROR: failed to load HSQLDB JDBC driver.");
            e.printStackTrace();
            return;
        }
        try {
            this.iConnection = DriverManager.getConnection("jdbc:hsqldb:file:db" + File.separator + "JFSDB", "sa", "");
            this.iConnection.setAutoCommit(false);
            this.iLocking = false;
            this.createNewTables();
            this.dropTriggers();
            this.createLocalTriggers();
            if (this.iOut != null) {
                this.iOut.println("disconnect");
                this.iOut.flush();
                this.iOut.close();
            }
            if (this.iIn != null) {
                this.iIn.close();
            }
            if (this.iSocket != null) {
                this.iSocket.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void checkCreateExampleCompany() {
        try {
            if (this.iConnection == null || this.iConnection.isClosed()) {
                return;
            }
            Statement iStatement = this.iConnection.createStatement();
            ResultSet iResultSet = iStatement.executeQuery("SELECT 0 FROM tbl_company");
            if (iResultSet.next()) {
                iStatement.close();
                return;
            }
            System.out.println("Creating example company.");
            String q = SSUtil.readResourceToString("sql/example.sql");
            iStatement.executeUpdate(q);
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void checkImportDefaultAccountPlans() {
        try {
            String[] defaults;
            if (this.iConnection == null || this.iConnection.isClosed()) {
                return;
            }
            Statement iStatement = this.iConnection.createStatement();
            ResultSet iResultSet = iStatement.executeQuery("SELECT 0 FROM tbl_accountplan");
            if (iResultSet.next()) {
                iStatement.close();
                return;
            }
            iStatement.close();
            System.out.println("Creating default account plans.");
            for (String s : defaults = new String[]{"BAS96(07)-AB & EF.xls", "BAS96(07)-Enskild n\u00e4ringsidkare.xls", "BAS96(07)-HB & KB.xls", "Bas2006(07)-AB & EF.xls", "Bas2006(07)-Enskild n\u00e4ringsidkare.xls", "Bas2006(07)-HB & KB.xls", "Bas2007(K1)-Enskild n\u00e4ringsidkare.xls"}) {
                System.out.println(s);
                String path = "account/default/" + s;
                InputStream is = ClassLoader.getSystemResourceAsStream(path);
                if (is == null) {
                    throw new RuntimeException("Resource not found: " + path);
                }
                try {
                    SSAccountPlanImporter.doImport(is);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SSImportException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void removeClient() {
        if (!this.iLocking || this.iConnection == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_license WHERE licensekey=?");
            iStatement.setObject(1, SSDBConfig.getClientkey());
            iStatement.executeUpdate();
            iStatement.close();
            this.iConnection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void restart() {
    }

    public void delete() {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SHUTDOWN");
            iStatement.executeUpdate();
            iStatement.close();
            this.iConnection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        File iPropFile = new File("db" + File.separator + "JFSDB.properties");
        File iScriptFile = new File("db" + File.separator + "JFSDB.script");
        File iDataFile = new File("db" + File.separator + "JFSDB.data");
        File iBackupFile = new File("db" + File.separator + "JFSDB.backup");
        File iLogFile = new File("db" + File.separator + "JFSDB.log");
        if (iPropFile.exists()) {
            iPropFile.delete();
        }
        if (iScriptFile.exists()) {
            iScriptFile.delete();
        }
        if (iDataFile.exists()) {
            iDataFile.delete();
        }
        if (iBackupFile.exists()) {
            iBackupFile.delete();
        }
        if (iLogFile.exists()) {
            iLogFile.delete();
        }
    }

    public void clear() {
    }

    public BufferedReader getReader() {
        return this.iIn;
    }

    public PrintWriter getWriter() {
        return this.iOut;
    }

    public Socket getSocket() {
        return this.iSocket;
    }

    public boolean LockDatabase() {
        if (!this.iLocking) {
            return true;
        }
        if (this.iOut == null || this.iIn == null || this.iSocket == null) {
            return false;
        }
        try {
            this.iOut.println("lockdatabase");
            this.iOut.flush();
            String iReply = this.iIn.readLine();
            if (iReply.equals("goahead")) {
                return true;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void UnlockDatabase() {
        if (!this.iLocking) {
            return;
        }
        if (this.iOut == null || this.iIn == null || this.iSocket == null) {
            return;
        }
        this.iOut.println("unlockdatabase");
        this.iOut.flush();
    }

    public void clearLists() {
        this.iProducts = null;
        this.iCustomers = null;
        this.iSuppliers = null;
        this.iAutoDists = null;
        this.iInpayments = null;
        this.iTenders = null;
        this.iOrders = null;
        this.iInvoices = null;
        this.iCreditInvoices = null;
        this.iPeriodicInvoices = null;
        this.iOutpayments = null;
        this.iPurchaseOrders = null;
        this.iSupplierInvoices = null;
        this.iSupplierCreditInvoices = null;
        this.iInventories = null;
        this.iIndeliveries = null;
        this.iOutdeliveries = null;
        this.iOwnReports = null;
    }

    public void setCurrentCompany(SSNewCompany iCompany) {
        this.iCurrentCompany = this.getCompany(iCompany);
        this.iProducts = null;
        this.iCustomers = null;
        this.iSuppliers = null;
        this.iAutoDists = null;
        this.iInpayments = null;
        this.iTenders = null;
        this.iOrders = null;
        this.iInvoices = null;
        this.iCreditInvoices = null;
        this.iPeriodicInvoices = null;
        this.iOutpayments = null;
        this.iPurchaseOrders = null;
        this.iSupplierInvoices = null;
        this.iSupplierCreditInvoices = null;
        this.iInventories = null;
        this.iIndeliveries = null;
        this.iOutdeliveries = null;
        this.iOwnReports = null;
        this.notifyListeners("COMPANY", this.iCurrentCompany, null);
    }

    public SSNewCompany getCurrentCompany() {
        this.iCurrentCompany = this.getCompany(this.iCurrentCompany);
        return this.iCurrentCompany;
    }

    public void setCurrentYear(SSNewAccountingYear iYear) {
        this.iCurrentYear = iYear;
        this.iVouchers = null;
        this.notifyListeners("YEAR", this.iCurrentYear, null);
    }

    public SSNewAccountingYear getCurrentYear() {
        return this.getAccountingYear(this.iCurrentYear);
    }

    public List<SSNewCompany> getCompanies() {
        LinkedList<SSNewCompany> iCompanies = null;
        try {
            iCompanies = new LinkedList<SSNewCompany>();
            if (this.iConnection == null || this.iConnection.isClosed()) {
                return iCompanies;
            }
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_company");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iCompanies.add((SSNewCompany)iResultSet.getObject("company"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iCompanies;
    }

    public SSNewCompany getCompany(SSNewCompany pCompany) {
        try {
            if (pCompany == null || this.iConnection.isClosed()) {
                return null;
            }
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_company WHERE id=?");
            iStatement.setObject(1, pCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewCompany iCompany = (SSNewCompany)iResultSet.getObject("company");
                iResultSet.close();
                iStatement.close();
                return iCompany;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addCompany(SSNewCompany iCompany) {
        if (iCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_company VALUES(NULL,?)");
            iStatement.setObject(1, iCompany);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_company");
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iId = -1;
            while (iResultSet.next()) {
                if (!iResultSet.isLast()) continue;
                iId = iResultSet.getInt("id");
            }
            iResultSet.close();
            iStatement.close();
            iCompany.setId(iId);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            iStatement = this.iConnection.prepareStatement("UPDATE tbl_company SET company=? WHERE id=?");
            iStatement.setObject(1, iCompany);
            iStatement.setObject(2, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateCompany(SSNewCompany iCompany) {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_company SET company=? WHERE id=?");
            iStatement.setObject(1, iCompany);
            iStatement.setObject(2, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.notifyListeners("COMPANY", iCompany, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteCompany(SSNewCompany iCompany) {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_project WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_resultunit WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_product WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_customer WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_supplier WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_vouchertemplate WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_autodist WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_inpayment WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_tender WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_order WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_invoice WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_creditinvoice WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_periodicinvoice WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_outpayment WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_purchaseorder WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_supplierinvoice WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_suppliercreditinvoice WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_inventory WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_indelivery WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_outdelivery WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_ownreport WHERE companyid=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            for (SSNewAccountingYear iYear : this.getYearsForCompany(iCompany)) {
                this.deleteAccountingYear(iYear);
            }
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_company WHERE id=?");
            iStatement.setObject(1, iCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSNewAccountingYear> getYears() {
        LinkedList<SSNewAccountingYear> iYears = new LinkedList<SSNewAccountingYear>();
        if (this.iCurrentCompany != null) {
            try {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE companyid=?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                while (iResultSet.next()) {
                    iYears.add((SSNewAccountingYear)iResultSet.getObject("accountingyear"));
                }
                iResultSet.close();
                iStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.iConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            }
        }
        return iYears;
    }

    public List<SSNewAccountingYear> getYearsForCompany(SSNewCompany iCompany) {
        LinkedList<SSNewAccountingYear> iYears = new LinkedList<SSNewAccountingYear>();
        if (iCompany != null) {
            try {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE companyid=?");
                iStatement.setObject(1, iCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                while (iResultSet.next()) {
                    iYears.add((SSNewAccountingYear)iResultSet.getObject("accountingyear"));
                }
                iResultSet.close();
                iStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.iConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            }
        }
        return iYears;
    }

    public SSNewAccountingYear getAccountingYear(SSNewAccountingYear pAccountingYear) {
        try {
            if (pAccountingYear == null) {
                return null;
            }
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE id=?");
            iStatement.setObject(1, pAccountingYear.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewAccountingYear iAccountingYear = (SSNewAccountingYear)iResultSet.getObject("accountingyear");
                iResultSet.close();
                iStatement.close();
                return iAccountingYear;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addAccountingYear(SSNewAccountingYear iAccountingYear) {
        if (iAccountingYear == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_accountingyear VALUES(NULL,?,?)");
            iStatement.setObject(1, iAccountingYear);
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear");
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iId = -1;
            while (iResultSet.next()) {
                if (!iResultSet.isLast()) continue;
                iId = iResultSet.getInt("id");
            }
            iAccountingYear.setId(iId);
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("UPDATE tbl_accountingyear SET accountingyear=? WHERE id=?");
            iStatement.setObject(1, iAccountingYear);
            iStatement.setObject(2, iAccountingYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateAccountingYear(SSNewAccountingYear iAccountingYear) {
        if (iAccountingYear == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_accountingyear SET accountingyear=? WHERE id=?");
            iStatement.setObject(1, iAccountingYear);
            iStatement.setObject(2, iAccountingYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            if (iAccountingYear.equals(this.iCurrentYear)) {
                this.iCurrentYear = iAccountingYear;
                this.notifyListeners("YEAR", iAccountingYear, null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteAccountingYear(SSNewAccountingYear iAccountingYear) {
        if (iAccountingYear == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_voucher WHERE yearid=?");
            iStatement.setObject(1, iAccountingYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_accountingyear WHERE id=?");
            iStatement.setObject(1, iAccountingYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public SSNewAccountingYear getPreviousYear() {
        this.iCurrentYear = this.getCurrentYear();
        if (this.iCurrentYear == null) {
            return null;
        }
        List<SSNewAccountingYear> iYears = this.getYears();
        Date iFirstDayOfCurrent = this.iCurrentYear.getFrom();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(iFirstDayOfCurrent);
        iCalendar.add(5, -1);
        for (SSNewAccountingYear iAccountingYear : iYears) {
            Date iLastDayOfYear = iAccountingYear.getTo();
            Calendar iNewCalendar = Calendar.getInstance();
            iNewCalendar.setTime(iLastDayOfYear);
            if (iCalendar.get(1) != iNewCalendar.get(1) || iCalendar.get(2) != iNewCalendar.get(2) || iCalendar.get(5) != iNewCalendar.get(5)) continue;
            return iAccountingYear;
        }
        return null;
    }

    public SSNewAccountingYear getLastYear() {
        LinkedList<SSNewAccountingYear> iYears = new LinkedList<SSNewAccountingYear>();
        if (this.iCurrentCompany != null) {
            try {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountingyear WHERE companyid=?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                while (iResultSet.next()) {
                    iYears.add((SSNewAccountingYear)iResultSet.getObject("accountingyear"));
                }
                iResultSet.close();
                iStatement.close();
                Date iLastDate = null;
                SSNewAccountingYear iAccountingYear = null;
                for (SSNewAccountingYear iYear : iYears) {
                    Date iTo;
                    if (iLastDate == null) {
                        iLastDate = iYear.getTo();
                        iAccountingYear = iYear;
                    }
                    if (!(iTo = iYear.getTo()).after(iLastDate)) continue;
                    iLastDate = iTo;
                    iAccountingYear = iYear;
                }
                return iAccountingYear;
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.iConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            }
        }
        return null;
    }

    public void addPropertyChangeListener(String pProperty, PropertyChangeListener pPropertyChangeListener) {
        List<PropertyChangeListener> iPropertyChangeListeners = this.iListenerMap.get(pProperty);
        if (iPropertyChangeListeners == null) {
            iPropertyChangeListeners = new LinkedList<PropertyChangeListener>();
            this.iListenerMap.put(pProperty, iPropertyChangeListeners);
        }
        iPropertyChangeListeners.add(pPropertyChangeListener);
    }

    public void notifyListeners(String pProperty, Object pNewValue, Object pOldValue) {
        List<PropertyChangeListener> iPropertyChangeListeners = this.iListenerMap.get(pProperty);
        if (iPropertyChangeListeners == null) {
            return;
        }
        PropertyChangeEvent iPropertyChangeEvent = new PropertyChangeEvent(this, pProperty, pOldValue, pNewValue);
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners) {
            iPropertyChangeListener.propertyChange(iPropertyChangeEvent);
        }
    }

    public SSAutoIncrement getAutoIncrement() {
        return null;
    }

    public List<SSVoucher> getVouchers() {
        if (this.iVouchers != null) {
            return this.iVouchers;
        }
        this.iVouchers = new LinkedList<SSVoucher>();
        if (this.iCurrentYear == null) {
            return this.iVouchers;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_voucher WHERE yearid=? AND id>?");
                iStatement.setObject(1, this.iCurrentYear.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iVouchers.add((SSVoucher)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iVouchers;
    }

    public List<SSVoucher> getVouchers(SSNewAccountingYear iAccountingYear) {
        LinkedList<SSVoucher> iVoucherList = new LinkedList<SSVoucher>();
        if (iAccountingYear == null) {
            return iVoucherList;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_voucher WHERE yearid=? AND id>?");
                iStatement.setObject(1, iAccountingYear.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    iVoucherList.add((SSVoucher)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iVoucherList;
    }

    public SSVoucher getVoucher(SSVoucher pVoucher) {
        if (pVoucher == null || this.iCurrentYear == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_voucher WHERE number=? AND yearid=?");
            iStatement.setObject(1, pVoucher.getNumber());
            iStatement.setObject(2, this.iCurrentYear.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSVoucher iVoucher = (SSVoucher)iResultSet.getObject(3);
                iStatement.close();
                return iVoucher;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSVoucher> getVouchers(List<SSVoucher> pVouchers) {
        if (pVouchers == null || this.iCurrentYear == null) {
            return null;
        }
        LinkedList<SSVoucher> iVouchers = new LinkedList<SSVoucher>();
        try {
            for (SSVoucher iVoucher : pVouchers) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_voucher WHERE number=? AND yearid=?");
                iStatement.setObject(1, iVoucher.getNumber());
                iStatement.setObject(2, this.iCurrentYear.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iVouchers.add((SSVoucher)iResultSet.getObject("voucher"));
                }
                iStatement.close();
            }
            return iVouchers;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addVoucher(SSVoucher iVoucher, boolean iHasNumber) {
        if (iVoucher == null || this.iCurrentYear == null) {
            return;
        }
        try {
            PreparedStatement iStatement;
            this.LockDatabase();
            if (!iHasNumber) {
                iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_voucher WHERE yearid=?");
                iStatement.setObject(1, this.iCurrentYear.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    Integer iNumber = iResultSet.getInt("maxnum");
                    iVoucher.setNumber(iNumber + 1);
                } else {
                    iVoucher.setNumber(1);
                }
                iResultSet.close();
                iStatement.close();
            }
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_voucher VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iVoucher.getNumber());
            iStatement.setObject(2, iVoucher);
            iStatement.setObject(3, this.iCurrentYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public Integer getLastVoucherNumber() {
        if (this.iCurrentYear == null) {
            return 0;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_voucher WHERE yearid=?");
            iStatement.setObject(1, this.iCurrentYear.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iNumber = 0;
            if (iResultSet.next()) {
                iNumber = iResultSet.getInt("maxnum");
            }
            iResultSet.close();
            iStatement.close();
            return iNumber;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return 0;
        }
    }

    public void updateVoucher(SSVoucher iVoucher) {
        if (iVoucher == null || this.iCurrentYear == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_voucher SET voucher=? WHERE number=? AND yearid=?");
            iStatement.setObject(1, iVoucher);
            iStatement.setObject(2, iVoucher.getNumber());
            iStatement.setObject(3, this.iCurrentYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteVoucher(SSVoucher iVoucher) {
        if (iVoucher == null || this.iCurrentYear == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_voucher WHERE number=? AND yearid=?");
            iStatement.setObject(1, iVoucher.getNumber());
            iStatement.setObject(2, this.iCurrentYear.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSVoucherTemplate> getVoucherTemplates() {
        LinkedList<SSVoucherTemplate> iVoucherTemplates = new LinkedList<SSVoucherTemplate>();
        if (this.iCurrentCompany == null) {
            return iVoucherTemplates;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_vouchertemplate WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            int i = 0;
            while (iResultSet.next()) {
                iVoucherTemplates.add((SSVoucherTemplate)iResultSet.getObject(2));
                ++i;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iVoucherTemplates;
    }

    public List<SSVoucherTemplate> getVoucherTemplates(List<SSVoucherTemplate> pVoucherTemplates) {
        if (pVoucherTemplates == null) {
            return null;
        }
        LinkedList<SSVoucherTemplate> iVoucherTemplates = new LinkedList<SSVoucherTemplate>();
        if (this.iCurrentCompany == null) {
            return iVoucherTemplates;
        }
        try {
            for (SSVoucherTemplate iVoucherTemplate : pVoucherTemplates) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_vouchertemplate WHERE name=? AND companyid=?");
                iStatement.setObject(1, iVoucherTemplate.getDescription());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iVoucherTemplates.add((SSVoucherTemplate)iResultSet.getObject(2));
                }
                iStatement.close();
            }
            return iVoucherTemplates;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addVoucherTemplate(SSVoucherTemplate iVoucherTemplate) {
        if (iVoucherTemplate == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_vouchertemplate VALUES(?,?,?)");
            iStatement.setObject(1, iVoucherTemplate.getDescription());
            iStatement.setObject(2, iVoucherTemplate);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteVoucherTemplate(SSVoucherTemplate iVoucherTemplate) {
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_vouchertemplate WHERE name=? AND companyid=?");
            iStatement.setObject(1, iVoucherTemplate.getDescription());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSAccount> getAccounts() {
        return this.iCurrentYear == null ? new LinkedList() : this.iCurrentYear.getAccounts();
    }

    public SSAccountPlan getCurrentAccountPlan() {
        if (this.iCurrentYear != null) {
            return this.iCurrentYear.getAccountPlan();
        }
        return new SSAccountPlan("Default");
    }

    public List<SSAccountPlan> getAccountPlans() {
        LinkedList<SSAccountPlan> iAccountPlans = new LinkedList<SSAccountPlan>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountplan");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iAccountPlans.add((SSAccountPlan)iResultSet.getObject("accountplan"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iAccountPlans;
    }

    public SSAccountPlan getAccountPlan(SSAccountPlan pAccountPlan) {
        if (pAccountPlan == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountplan WHERE id=?");
            iStatement.setObject(1, pAccountPlan.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSAccountPlan iAccountPlan = (SSAccountPlan)iResultSet.getObject("accountplan");
                iStatement.close();
                return iAccountPlan;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addAccountPlan(SSAccountPlan iAccountPlan) {
        if (iAccountPlan == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_accountplan VALUES(NULL,?)");
            iStatement.setObject(1, iAccountPlan);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_accountplan");
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iId = -1;
            while (iResultSet.next()) {
                if (!iResultSet.isLast()) continue;
                iId = iResultSet.getInt("id");
            }
            iAccountPlan.setId(iId);
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("UPDATE tbl_accountplan SET accountplan=? WHERE id=?");
            iStatement.setObject(1, iAccountPlan);
            iStatement.setObject(2, iAccountPlan.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateAccountPlan(SSAccountPlan iAccountPlan) {
        if (iAccountPlan == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_accountplan SET accountplan=? WHERE id=?");
            iStatement.setObject(1, iAccountPlan);
            iStatement.setObject(2, iAccountPlan.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteAccountPlan(SSAccountPlan iAccountPlan) {
        if (iAccountPlan == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_accountplan WHERE id=?");
            iStatement.setObject(1, iAccountPlan.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSUnit> getUnits() {
        LinkedList<SSUnit> iUnits = new LinkedList<SSUnit>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_unit");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iUnits.add((SSUnit)iResultSet.getObject("unit"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iUnits;
    }

    public void addUnit(SSUnit iUnit) {
        if (iUnit == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_unit VALUES(?,?)");
            iStatement.setObject(1, iUnit.getName());
            iStatement.setObject(2, iUnit);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateUnit(SSUnit iUnit) {
        if (iUnit == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_unit SET unit=? WHERE name=?");
            iStatement.setObject(1, iUnit);
            iStatement.setObject(2, iUnit.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteUnit(SSUnit iUnit) {
        if (iUnit == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_unit WHERE name=?");
            iStatement.setObject(1, iUnit.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSCurrency> getCurrencies() {
        LinkedList<SSCurrency> iCurrencies = new LinkedList<SSCurrency>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_currency");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iCurrencies.add((SSCurrency)iResultSet.getObject("currency"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iCurrencies;
    }

    public SSCurrency getCurrency(SSCurrency iCurrency) {
        SSCurrency iUpdatedCurrency = new SSCurrency();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_currency WHERE code=?");
            iStatement.setObject(1, iCurrency.getName());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                iUpdatedCurrency = (SSCurrency)iResultSet.getObject("currency");
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iUpdatedCurrency;
    }

    public void addCurrency(SSCurrency iCurrency) {
        if (iCurrency == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_currency VALUES(?,?)");
            iStatement.setObject(1, iCurrency.getName());
            iStatement.setObject(2, iCurrency);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateCurrency(SSCurrency iCurrency) {
        if (iCurrency == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_currency SET currency=? WHERE code=?");
            iStatement.setObject(1, iCurrency);
            iStatement.setObject(2, iCurrency.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteCurrency(SSCurrency iCurrency) {
        if (iCurrency == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_currency WHERE code=?");
            iStatement.setObject(1, iCurrency.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSDeliveryWay> getDeliveryWays() {
        LinkedList<SSDeliveryWay> iDeliveryWays = new LinkedList<SSDeliveryWay>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_deliveryway");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iDeliveryWays.add((SSDeliveryWay)iResultSet.getObject("deliveryway"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iDeliveryWays;
    }

    public void addDeliveryWay(SSDeliveryWay iDeliveryWay) {
        if (iDeliveryWay == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_deliveryway VALUES(?,?)");
            iStatement.setObject(1, iDeliveryWay.getName());
            iStatement.setObject(2, iDeliveryWay);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateDeliveryWay(SSDeliveryWay iDeliveryWay) {
        if (iDeliveryWay == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_deliveryway SET deliveryway=? WHERE name=?");
            iStatement.setObject(1, iDeliveryWay);
            iStatement.setObject(2, iDeliveryWay.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteDeliveryWay(SSDeliveryWay iDeliveryWay) {
        if (iDeliveryWay == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_deliveryway WHERE name=?");
            iStatement.setObject(1, iDeliveryWay.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSDeliveryTerm> getDeliveryTerms() {
        LinkedList<SSDeliveryTerm> iDeliveryTerms = new LinkedList<SSDeliveryTerm>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_deliveryterm");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iDeliveryTerms.add((SSDeliveryTerm)iResultSet.getObject("deliveryterm"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iDeliveryTerms;
    }

    public void addDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        if (iDeliveryTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_deliveryterm VALUES(?,?)");
            iStatement.setObject(1, iDeliveryTerm.getName());
            iStatement.setObject(2, iDeliveryTerm);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        if (iDeliveryTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_deliveryterm SET deliveryterm=? WHERE name=?");
            iStatement.setObject(1, iDeliveryTerm);
            iStatement.setObject(2, iDeliveryTerm.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        if (iDeliveryTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_deliveryterm WHERE name=?");
            iStatement.setObject(1, iDeliveryTerm.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSPaymentTerm> getPaymentTerms() {
        LinkedList<SSPaymentTerm> iPaymentTerms = new LinkedList<SSPaymentTerm>();
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_paymentterm");
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iPaymentTerms.add((SSPaymentTerm)iResultSet.getObject("paymentterm"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iPaymentTerms;
    }

    public void addPaymentTerm(SSPaymentTerm iPaymentTerm) {
        if (iPaymentTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_paymentterm VALUES(?,?)");
            iStatement.setObject(1, iPaymentTerm.getName());
            iStatement.setObject(2, iPaymentTerm);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updatePaymentTerm(SSPaymentTerm iPaymentTerm) {
        if (iPaymentTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_paymentterm SET paymentterm=? WHERE name=?");
            iStatement.setObject(1, iPaymentTerm);
            iStatement.setObject(2, iPaymentTerm.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deletePaymentTerm(SSPaymentTerm iPaymentTerm) {
        if (iPaymentTerm == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_paymentterm WHERE name=?");
            iStatement.setObject(1, iPaymentTerm.getName());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSNewResultUnit> getResultUnits() {
        LinkedList<SSNewResultUnit> iResultUnits = new LinkedList<SSNewResultUnit>();
        if (this.iCurrentCompany == null) {
            return iResultUnits;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_resultunit WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iResultUnits.add((SSNewResultUnit)iResultSet.getObject("resultunit"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iResultUnits;
    }

    public SSNewResultUnit getResultUnit(SSNewResultUnit pResultUnit) {
        if (pResultUnit == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_resultunit WHERE number=? AND companyid=?");
            iStatement.setObject(1, pResultUnit.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewResultUnit iResultUnit = (SSNewResultUnit)iResultSet.getObject("resultunit");
                iStatement.close();
                return iResultUnit;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public SSNewResultUnit getResultUnit(String pResultUnitNumber) {
        if (pResultUnitNumber == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_resultunit WHERE number=? AND companyid=?");
            iStatement.setObject(1, pResultUnitNumber);
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewResultUnit iResultUnit = (SSNewResultUnit)iResultSet.getObject("resultunit");
                iStatement.close();
                return iResultUnit;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSNewResultUnit> getResultUnits(List<SSNewResultUnit> pResultUnits) {
        if (pResultUnits == null) {
            return null;
        }
        LinkedList<SSNewResultUnit> iResultUnits = new LinkedList<SSNewResultUnit>();
        if (this.iCurrentCompany == null) {
            return iResultUnits;
        }
        try {
            for (SSNewResultUnit iResultUnit : pResultUnits) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_resultunit WHERE number=? AND companyid=?");
                iStatement.setObject(1, iResultUnit.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iResultUnits.add((SSNewResultUnit)iResultSet.getObject("resultunit"));
                }
                iStatement.close();
            }
            return iResultUnits;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addResultUnit(SSNewResultUnit iResultUnit) {
        if (iResultUnit == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_resultunit VALUES(?,?,?)");
            iStatement.setObject(1, iResultUnit.getNumber());
            iStatement.setObject(2, iResultUnit);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateResultUnit(SSNewResultUnit iResultUnit) {
        if (iResultUnit == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_resultunit SET resultunit=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iResultUnit);
            iStatement.setObject(2, iResultUnit.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteResultUnit(SSNewResultUnit iResultUnit) {
        if (iResultUnit == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_resultunit WHERE number=? AND companyid=?");
            iStatement.setObject(1, iResultUnit.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSNewProject> getProjects() {
        LinkedList<SSNewProject> iProjects = new LinkedList<SSNewProject>();
        if (this.iCurrentCompany == null) {
            return iProjects;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_project WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            while (iResultSet.next()) {
                iProjects.add((SSNewProject)iResultSet.getObject("project"));
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return iProjects;
    }

    public SSNewProject getProject(SSNewProject pProject) {
        if (pProject == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_project WHERE number=? AND companyid=?");
            iStatement.setObject(1, pProject.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewProject iProject = (SSNewProject)iResultSet.getObject("project");
                iStatement.close();
                return iProject;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public SSNewProject getProject(String pProjectNumber) {
        if (pProjectNumber == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_project WHERE number=? AND companyid=?");
            iStatement.setObject(1, pProjectNumber);
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSNewProject iProject = (SSNewProject)iResultSet.getObject("project");
                iStatement.close();
                return iProject;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSNewProject> getProjects(List<SSNewProject> pProjects) {
        if (pProjects == null) {
            return null;
        }
        LinkedList<SSNewProject> iProjects = new LinkedList<SSNewProject>();
        if (this.iCurrentCompany == null) {
            return iProjects;
        }
        try {
            for (SSNewProject iProject : pProjects) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_project WHERE number=? AND companyid=?");
                iStatement.setObject(1, iProject.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iProjects.add((SSNewProject)iResultSet.getObject("project"));
                }
                iStatement.close();
            }
            return iProjects;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addProject(SSNewProject iProject) {
        if (iProject == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_project VALUES(?,?,?)");
            iStatement.setObject(1, iProject.getNumber());
            iStatement.setObject(2, iProject);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateProject(SSNewProject iProject) {
        if (iProject == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_project SET project=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iProject);
            iStatement.setObject(2, iProject.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteProject(SSNewProject iProject) {
        if (iProject == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_project WHERE number=? AND companyid=?");
            iStatement.setObject(1, iProject.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public synchronized void triggerAction(String iTriggerName, String iTableName, String iNumber) {
        try {
            if (iTriggerName.contains("PROJECT")) {
                if (SSProjectFrame.getInstance() != null) {
                    SSProjectFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.contains("RESULTUNIT")) {
                if (SSResultUnitFrame.getInstance() != null) {
                    SSResultUnitFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWPRODUCT") && this.iProducts != null) {
                SSProduct iProduct = new SSProduct();
                iProduct.setNumber(iNumber);
                iProduct = this.getProduct(iProduct);
                this.iProducts.add(iProduct);
                iProduct = null;
                if (SSProductFrame.getInstance() != null) {
                    SSProductFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("EDITPRODUCT") && this.iProducts != null) {
                SSProduct iProduct = new SSProduct();
                iProduct.setNumber(iNumber);
                iProduct = this.getProduct(iProduct);
                int iIndex = this.iProducts.lastIndexOf(iProduct);
                if (iIndex == -1) {
                    return;
                }
                this.iProducts.remove(iIndex);
                this.iProducts.add(iIndex, iProduct);
                iProduct = null;
                if (SSProductFrame.getInstance() != null) {
                    SSProductFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEPRODUCT") && this.iProducts != null) {
                SSProduct iProduct = new SSProduct();
                iProduct.setNumber(iNumber);
                this.iProducts.remove(iProduct);
                iProduct = null;
                if (SSProductFrame.getInstance() != null) {
                    SSProductFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWCUSTOMER") && this.iCustomers != null) {
                SSCustomer iCustomer = new SSCustomer();
                iCustomer.setNumber(iNumber);
                iCustomer = this.getCustomer(iCustomer);
                this.iCustomers.add(iCustomer);
                SSCustomerMath.iInvoicesForCustomers.put(iCustomer.getNumber(), new LinkedList());
                iCustomer = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("EDITCUSTOMER") && this.iCustomers != null) {
                SSCustomer iCustomer = new SSCustomer();
                iCustomer.setNumber(iNumber);
                iCustomer = this.getCustomer(iCustomer);
                int iIndex = this.iCustomers.lastIndexOf(iCustomer);
                if (iIndex == -1) {
                    return;
                }
                this.iCustomers.remove(iIndex);
                this.iCustomers.add(iIndex, iCustomer);
                iCustomer = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETECUSTOMER") && this.iCustomers != null) {
                SSCustomer iCustomer = new SSCustomer();
                iCustomer.setNumber(iNumber);
                this.iCustomers.remove(iCustomer);
                iCustomer = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWSUPPLIER") && this.iSuppliers != null) {
                SSSupplier iSupplier = new SSSupplier();
                iSupplier.setNumber(iNumber);
                iSupplier = this.getSupplier(iSupplier);
                this.iSuppliers.add(iSupplier);
                SSSupplierMath.iInvoicesForSuppliers.put(iSupplier.getNumber(), new LinkedList());
                iSupplier = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("EDITSUPPLIER") && this.iSuppliers != null) {
                SSSupplier iSupplier = new SSSupplier();
                iSupplier.setNumber(iNumber);
                iSupplier = this.getSupplier(iSupplier);
                int iIndex = this.iSuppliers.lastIndexOf(iSupplier);
                if (iIndex == -1) {
                    return;
                }
                this.iSuppliers.remove(iIndex);
                this.iSuppliers.add(iIndex, iSupplier);
                iSupplier = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETESUPPLIER") && this.iSuppliers != null) {
                SSSupplier iSupplier = new SSSupplier();
                iSupplier.setNumber(iNumber);
                this.iSuppliers.remove(iSupplier);
                iSupplier = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.contains("VOUCHERTEMPLATE")) {
                if (SSVoucherTemplateFrame.getInstance() != null) {
                    SSVoucherTemplateFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWAUTODIST") && this.iAutoDists != null) {
                Integer iAccount = Integer.parseInt(iNumber);
                SSAutoDist iAutoDist = new SSAutoDist();
                iAutoDist.setAccountNumber(iAccount);
                iAutoDist = this.getAutoDist(iAutoDist);
                this.iAutoDists.add(iAutoDist);
                iAutoDist = null;
                if (SSAutoDistFrame.getInstance() != null) {
                    SSAutoDistFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("EDITAUTODIST") && this.iAutoDists != null) {
                Integer iAccount = Integer.parseInt(iNumber);
                SSAutoDist iAutoDist = new SSAutoDist();
                iAutoDist.setAccountNumber(iAccount);
                iAutoDist = this.getAutoDist(iAutoDist);
                int iIndex = this.iAutoDists.lastIndexOf(iAutoDist);
                if (iIndex == -1) {
                    return;
                }
                this.iAutoDists.remove(iIndex);
                this.iAutoDists.add(iIndex, iAutoDist);
                iAutoDist = null;
                if (SSAutoDistFrame.getInstance() != null) {
                    SSAutoDistFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEAUTODIST") && this.iAutoDists != null) {
                Integer iAccount = Integer.parseInt(iNumber);
                SSAutoDist iAutoDist = new SSAutoDist();
                iAutoDist.setAccountNumber(iAccount);
                this.iAutoDists.remove(iAutoDist);
                iAutoDist = null;
                if (SSAutoDistFrame.getInstance() != null) {
                    SSAutoDistFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWINPAYMENT") && this.iInpayments != null) {
                SSInpayment iInpayment = new SSInpayment();
                iInpayment.setNumber(Integer.parseInt(iNumber));
                iInpayment = this.getInpayment(iInpayment);
                if (!this.iInpayments.contains(iInpayment)) {
                    this.iInpayments.add(iInpayment);
                }
                for (SSInpaymentRow iRow : iInpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).subtract(iRow.getValue()));
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                if (SSInpaymentFrame.getInstance() != null) {
                    SSInpaymentFrame.getInstance().updateFrame();
                }
                iInpayment = null;
            } else if (iTriggerName.equals("EDITINPAYMENT") && this.iInpayments != null) {
                SSInpayment iInpayment = new SSInpayment();
                iInpayment.setNumber(Integer.parseInt(iNumber));
                iInpayment = this.getInpayment(iInpayment);
                int iIndex = this.iInpayments.lastIndexOf(iInpayment);
                if (iIndex == -1) {
                    return;
                }
                SSInpayment iOldInpayment = this.iInpayments.get(iIndex);
                for (SSInpaymentRow iRow : iOldInpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                }
                this.iInpayments.remove(iIndex);
                this.iInpayments.add(iIndex, iInpayment);
                for (SSInpaymentRow iRow : iInpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).subtract(iRow.getValue()));
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                iInpayment = null;
                if (SSInpaymentFrame.getInstance() != null) {
                    SSInpaymentFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEINPAYMENT") && this.iInpayments != null) {
                SSInpayment iInpayment = new SSInpayment();
                iInpayment.setNumber(Integer.parseInt(iNumber));
                this.iInpayments.remove(iInpayment);
                iInpayment = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                if (SSInpaymentFrame.getInstance() != null) {
                    SSInpaymentFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWTENDER") && this.iTenders != null) {
                SSTender iTender = new SSTender();
                iTender.setNumber(Integer.parseInt(iNumber));
                iTender = this.getTender(iTender);
                if (!this.iTenders.contains(iTender)) {
                    this.iTenders.add(iTender);
                }
                if (SSTenderFrame.getInstance() != null) {
                    SSTenderFrame.getInstance().updateFrame();
                }
                iTender = null;
            } else if (iTriggerName.equals("EDITTENDER") && this.iTenders != null) {
                SSTender iTender = new SSTender();
                iTender.setNumber(Integer.parseInt(iNumber));
                iTender = this.getTender(iTender);
                int iIndex = this.iTenders.lastIndexOf(iTender);
                if (iIndex == -1) {
                    return;
                }
                this.iTenders.remove(iIndex);
                this.iTenders.add(iIndex, iTender);
                iTender = null;
                if (SSTenderFrame.getInstance() != null) {
                    SSTenderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETETENDER") && this.iTenders != null) {
                SSTender iTender = new SSTender();
                iTender.setNumber(Integer.parseInt(iNumber));
                this.iTenders.remove(iTender);
                iTender = null;
                if (SSTenderFrame.getInstance() != null) {
                    SSTenderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWORDER") && this.iOrders != null) {
                SSOrder iOrder = new SSOrder();
                iOrder.setNumber(Integer.parseInt(iNumber));
                iOrder = this.getOrder(iOrder);
                if (!this.iOrders.contains(iOrder)) {
                    this.iOrders.add(iOrder);
                }
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
                iOrder = null;
            } else if (iTriggerName.equals("EDITORDER") && this.iOrders != null) {
                SSOrder iOrder = new SSOrder();
                iOrder.setNumber(Integer.parseInt(iNumber));
                iOrder = this.getOrder(iOrder);
                int iIndex = this.iOrders.lastIndexOf(iOrder);
                if (iIndex == -1) {
                    return;
                }
                this.iOrders.remove(iIndex);
                this.iOrders.add(iIndex, iOrder);
                iOrder = null;
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEORDER") && this.iOrders != null) {
                SSOrder iOrder = new SSOrder();
                iOrder.setNumber(Integer.parseInt(iNumber));
                this.iOrders.remove(iOrder);
                iOrder = null;
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWINVOICE") && this.iInvoices != null) {
                SSInvoice iInvoice = new SSInvoice();
                iInvoice.setNumber(Integer.parseInt(iNumber));
                iInvoice = this.getInvoice(iInvoice);
                if (!this.iInvoices.contains(iInvoice)) {
                    this.iInvoices.add(iInvoice);
                }
                SSInvoiceMath.iSaldoMap.put(iInvoice.getNumber(), SSInvoiceMath.getSaldo(iInvoice));
                if (SSCustomerMath.iInvoicesForCustomers.containsKey(iInvoice.getCustomerNr())) {
                    SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).add(iInvoice);
                } else {
                    LinkedList<SSInvoice> iNumbers = new LinkedList<SSInvoice>();
                    iNumbers.add(iInvoice);
                    SSCustomerMath.iInvoicesForCustomers.put(iInvoice.getCustomerNr(), iNumbers);
                }
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                iInvoice = null;
            } else if (iTriggerName.equals("EDITINVOICE") && this.iInvoices != null) {
                SSInvoice iInvoice = new SSInvoice();
                iInvoice.setNumber(Integer.parseInt(iNumber));
                iInvoice = this.getInvoice(iInvoice);
                int iIndex = this.iInvoices.lastIndexOf(iInvoice);
                if (iIndex == -1) {
                    return;
                }
                this.iInvoices.remove(iIndex);
                this.iInvoices.add(iIndex, iInvoice);
                SSInvoiceMath.iSaldoMap.put(iInvoice.getNumber(), SSInvoiceMath.getSaldo(iInvoice));
                iIndex = SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).indexOf(iInvoice);
                if (iIndex != -1) {
                    SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).remove(iIndex);
                    SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).add(iIndex, iInvoice);
                }
                iInvoice = null;
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEINVOICE") && this.iInvoices != null) {
                SSInvoice iInvoice = new SSInvoice();
                iInvoice.setNumber(Integer.parseInt(iNumber));
                this.iInvoices.remove(iInvoice);
                SSInvoiceMath.iSaldoMap.remove(iInvoice.getNumber());
                iInvoice = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWCREDITINVOICE") && this.iCreditInvoices != null) {
                SSCreditInvoice iCreditInvoice = new SSCreditInvoice();
                iCreditInvoice.setNumber(Integer.parseInt(iNumber));
                iCreditInvoice = this.getCreditInvoice(iCreditInvoice);
                if (!this.iCreditInvoices.contains(iCreditInvoice)) {
                    this.iCreditInvoices.add(iCreditInvoice);
                }
                if (SSInvoiceMath.iSaldoMap.containsKey(iCreditInvoice.getCreditingNr())) {
                    SSInvoiceMath.iSaldoMap.put(iCreditInvoice.getCreditingNr(), SSInvoiceMath.iSaldoMap.get(iCreditInvoice.getCreditingNr()).subtract(SSCreditInvoiceMath.getTotalSum(iCreditInvoice)));
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                if (SSCreditInvoiceFrame.getInstance() != null) {
                    SSCreditInvoiceFrame.getInstance().updateFrame();
                }
                iCreditInvoice = null;
            } else if (iTriggerName.equals("EDITCREDITINVOICE") && this.iCreditInvoices != null) {
                SSCreditInvoice iCreditInvoice = new SSCreditInvoice();
                iCreditInvoice.setNumber(Integer.parseInt(iNumber));
                iCreditInvoice = this.getCreditInvoice(iCreditInvoice);
                int iIndex = this.iCreditInvoices.lastIndexOf(iCreditInvoice);
                if (iIndex == -1) {
                    return;
                }
                SSCreditInvoice iOldCreditInvoice = this.iCreditInvoices.get(iIndex);
                if (SSInvoiceMath.iSaldoMap.containsKey(iOldCreditInvoice.getCreditingNr())) {
                    SSInvoiceMath.iSaldoMap.put(iOldCreditInvoice.getCreditingNr(), SSInvoiceMath.iSaldoMap.get(iOldCreditInvoice.getCreditingNr()).add(SSCreditInvoiceMath.getTotalSum(iOldCreditInvoice)));
                }
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                this.iCreditInvoices.remove(iIndex);
                this.iCreditInvoices.add(iIndex, iCreditInvoice);
                if (SSInvoiceMath.iSaldoMap.containsKey(iCreditInvoice.getCreditingNr())) {
                    SSInvoiceMath.iSaldoMap.put(iCreditInvoice.getCreditingNr(), SSInvoiceMath.iSaldoMap.get(iCreditInvoice.getCreditingNr()).subtract(SSCreditInvoiceMath.getTotalSum(iCreditInvoice)));
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                iCreditInvoice = null;
                if (SSCreditInvoiceFrame.getInstance() != null) {
                    SSCreditInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETECREDITINVOICE") && this.iCreditInvoices != null) {
                SSCreditInvoice iCreditInvoice = new SSCreditInvoice();
                iCreditInvoice.setNumber(Integer.parseInt(iNumber));
                this.iCreditInvoices.remove(iCreditInvoice);
                iCreditInvoice = null;
                if (SSCustomerFrame.getInstance() != null) {
                    SSCustomerFrame.getInstance().updateFrame();
                }
                if (SSCreditInvoiceFrame.getInstance() != null) {
                    SSCreditInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWPERIODICINVOICE") && this.iPeriodicInvoices != null) {
                SSPeriodicInvoice iPeriodicInvoice = new SSPeriodicInvoice();
                iPeriodicInvoice.setNumber(Integer.parseInt(iNumber));
                iPeriodicInvoice = this.getPeriodicInvoice(iPeriodicInvoice);
                if (!this.iPeriodicInvoices.contains(iPeriodicInvoice)) {
                    this.iPeriodicInvoices.add(iPeriodicInvoice);
                }
                if (SSPeriodicInvoiceFrame.getInstance() != null) {
                    SSPeriodicInvoiceFrame.getInstance().updateFrame();
                }
                iPeriodicInvoice = null;
            } else if (iTriggerName.equals("EDITPERIODICINVOICE") && this.iPeriodicInvoices != null) {
                SSPeriodicInvoice iPeriodicInvoice = new SSPeriodicInvoice();
                iPeriodicInvoice.setNumber(Integer.parseInt(iNumber));
                iPeriodicInvoice = this.getPeriodicInvoice(iPeriodicInvoice);
                int iIndex = this.iPeriodicInvoices.lastIndexOf(iPeriodicInvoice);
                if (iIndex == -1) {
                    return;
                }
                this.iPeriodicInvoices.remove(iIndex);
                this.iPeriodicInvoices.add(iIndex, iPeriodicInvoice);
                iPeriodicInvoice = null;
                if (SSPeriodicInvoiceFrame.getInstance() != null) {
                    SSPeriodicInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEPERIODICINVOICE") && this.iPeriodicInvoices != null) {
                SSPeriodicInvoice iPeriodicInvoice = new SSPeriodicInvoice();
                iPeriodicInvoice.setNumber(Integer.parseInt(iNumber));
                this.iPeriodicInvoices.remove(iPeriodicInvoice);
                iPeriodicInvoice = null;
                if (SSPeriodicInvoiceFrame.getInstance() != null) {
                    SSPeriodicInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWOUTPAYMENT") && this.iOutpayments != null) {
                SSOutpayment iOutpayment = new SSOutpayment();
                iOutpayment.setNumber(Integer.parseInt(iNumber));
                iOutpayment = this.getOutpayment(iOutpayment);
                if (!this.iOutpayments.contains(iOutpayment)) {
                    this.iOutpayments.add(iOutpayment);
                }
                for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSSupplierInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSSupplierInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSSupplierInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).subtract(iRow.getValue()));
                }
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                if (SSOutpaymentFrame.getInstance() != null) {
                    SSOutpaymentFrame.getInstance().updateFrame();
                }
                iOutpayment = null;
            } else if (iTriggerName.equals("EDITOUTPAYMENT") && this.iOutpayments != null) {
                SSOutpayment iOutpayment = new SSOutpayment();
                iOutpayment.setNumber(Integer.parseInt(iNumber));
                iOutpayment = this.getOutpayment(iOutpayment);
                int iIndex = this.iOutpayments.lastIndexOf(iOutpayment);
                if (iIndex == -1) {
                    return;
                }
                SSOutpayment iOldOutpayment = this.iOutpayments.get(iIndex);
                for (SSOutpaymentRow iRow : iOldOutpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSSupplierInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSSupplierInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSSupplierInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                }
                this.iOutpayments.remove(iIndex);
                this.iOutpayments.add(iIndex, iOutpayment);
                for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSSupplierInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSSupplierInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSSupplierInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).subtract(iRow.getValue()));
                }
                iOutpayment = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                if (SSOutpaymentFrame.getInstance() != null) {
                    SSOutpaymentFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEOUTPAYMENT") && this.iOutpayments != null) {
                SSOutpayment iOutpayment = new SSOutpayment();
                iOutpayment.setNumber(Integer.parseInt(iNumber));
                this.iOutpayments.remove(iOutpayment);
                iOutpayment = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                if (SSOutpaymentFrame.getInstance() != null) {
                    SSOutpaymentFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWPURCHASEORDER") && this.iPurchaseOrders != null) {
                SSPurchaseOrder iPurchaseOrder = new SSPurchaseOrder();
                iPurchaseOrder.setNumber(Integer.parseInt(iNumber));
                iPurchaseOrder = this.getPurchaseOrder(iPurchaseOrder);
                if (!this.iPurchaseOrders.contains(iPurchaseOrder)) {
                    this.iPurchaseOrders.add(iPurchaseOrder);
                }
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
                if (SSPurchaseOrderFrame.getInstance() != null) {
                    SSPurchaseOrderFrame.getInstance().updateFrame();
                }
                iPurchaseOrder = null;
            } else if (iTriggerName.equals("EDITPURCHASEORDER") && this.iPurchaseOrders != null) {
                SSPurchaseOrder iPurchaseOrder = new SSPurchaseOrder();
                iPurchaseOrder.setNumber(Integer.parseInt(iNumber));
                iPurchaseOrder = this.getPurchaseOrder(iPurchaseOrder);
                int iIndex = this.iPurchaseOrders.lastIndexOf(iPurchaseOrder);
                if (iIndex == -1) {
                    return;
                }
                this.iPurchaseOrders.remove(iIndex);
                this.iPurchaseOrders.add(iIndex, iPurchaseOrder);
                iPurchaseOrder = null;
                if (SSPurchaseOrderFrame.getInstance() != null) {
                    SSPurchaseOrderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEPURCHASEORDER") && this.iPurchaseOrders != null) {
                SSPurchaseOrder iPurchaseOrder = new SSPurchaseOrder();
                iPurchaseOrder.setNumber(Integer.parseInt(iNumber));
                this.iPurchaseOrders.remove(iPurchaseOrder);
                iPurchaseOrder = null;
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderFrame.getInstance().updateFrame();
                }
                if (SSPurchaseOrderFrame.getInstance() != null) {
                    SSPurchaseOrderFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWSUPPLIERINVOICE") && this.iSupplierInvoices != null) {
                SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice();
                iSupplierInvoice.setNumber(Integer.parseInt(iNumber));
                iSupplierInvoice = this.getSupplierInvoice(iSupplierInvoice);
                if (!this.iSupplierInvoices.contains(iSupplierInvoice)) {
                    this.iSupplierInvoices.add(iSupplierInvoice);
                }
                SSSupplierInvoiceMath.iSaldoMap.put(iSupplierInvoice.getNumber(), SSSupplierInvoiceMath.getSaldo(iSupplierInvoice));
                if (SSSupplierMath.iInvoicesForSuppliers.containsKey(iSupplierInvoice.getSupplierNr())) {
                    SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).add(iSupplierInvoice);
                } else {
                    LinkedList<SSSupplierInvoice> iNumbers = new LinkedList<SSSupplierInvoice>();
                    iNumbers.add(iSupplierInvoice);
                    SSSupplierMath.iInvoicesForSuppliers.put(iSupplierInvoice.getSupplierNr(), iNumbers);
                }
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                iSupplierInvoice = null;
            } else if (iTriggerName.equals("EDITSUPPLIERINVOICE") && this.iSupplierInvoices != null) {
                SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice();
                iSupplierInvoice.setNumber(Integer.parseInt(iNumber));
                iSupplierInvoice = this.getSupplierInvoice(iSupplierInvoice);
                int iIndex = this.iSupplierInvoices.lastIndexOf(iSupplierInvoice);
                if (iIndex == -1) {
                    return;
                }
                this.iSupplierInvoices.remove(iIndex);
                this.iSupplierInvoices.add(iIndex, iSupplierInvoice);
                SSSupplierInvoiceMath.iSaldoMap.put(iSupplierInvoice.getNumber(), SSSupplierInvoiceMath.getSaldo(iSupplierInvoice));
                iIndex = SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).indexOf(iSupplierInvoice);
                if (iIndex != -1) {
                    SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).remove(iIndex);
                    SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).add(iIndex, iSupplierInvoice);
                }
                iSupplierInvoice = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETESUPPLIERINVOICE") && this.iSupplierInvoices != null) {
                SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice();
                iSupplierInvoice.setNumber(Integer.parseInt(iNumber));
                this.iSupplierInvoices.remove(iSupplierInvoice);
                SSSupplierInvoiceMath.iSaldoMap.remove(iSupplierInvoice.getNumber());
                iSupplierInvoice = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWSUPPLIERCREDITINVOICE") && this.iSupplierCreditInvoices != null) {
                SSSupplierCreditInvoice iSupplierCreditInvoice = new SSSupplierCreditInvoice();
                iSupplierCreditInvoice.setNumber(Integer.parseInt(iNumber));
                iSupplierCreditInvoice = this.getSupplierCreditInvoice(iSupplierCreditInvoice);
                if (!this.iSupplierCreditInvoices.contains(iSupplierCreditInvoice)) {
                    this.iSupplierCreditInvoices.add(iSupplierCreditInvoice);
                }
                if (SSSupplierInvoiceMath.iSaldoMap.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                    SSSupplierInvoiceMath.iSaldoMap.put(iSupplierCreditInvoice.getCreditingNr(), SSSupplierInvoiceMath.iSaldoMap.get(iSupplierCreditInvoice.getCreditingNr()).subtract(SSSupplierInvoiceMath.getTotalSum(iSupplierCreditInvoice)));
                }
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                if (SSSupplierCreditInvoiceFrame.getInstance() != null) {
                    SSSupplierCreditInvoiceFrame.getInstance().updateFrame();
                }
                iSupplierCreditInvoice = null;
            } else if (iTriggerName.equals("EDITSUPPLIERCREDITINVOICE") && this.iSupplierCreditInvoices != null) {
                SSSupplierCreditInvoice iSupplierCreditInvoice = new SSSupplierCreditInvoice();
                iSupplierCreditInvoice.setNumber(Integer.parseInt(iNumber));
                iSupplierCreditInvoice = this.getSupplierCreditInvoice(iSupplierCreditInvoice);
                int iIndex = this.iSupplierCreditInvoices.lastIndexOf(iSupplierCreditInvoice);
                if (iIndex == -1) {
                    return;
                }
                SSSupplierCreditInvoice iOldSupplierCreditInvoice = this.iSupplierCreditInvoices.get(iIndex);
                if (SSSupplierInvoiceMath.iSaldoMap.containsKey(iOldSupplierCreditInvoice.getCreditingNr())) {
                    SSSupplierInvoiceMath.iSaldoMap.put(iOldSupplierCreditInvoice.getCreditingNr(), SSSupplierInvoiceMath.iSaldoMap.get(iOldSupplierCreditInvoice.getCreditingNr()).add(SSSupplierInvoiceMath.getTotalSum(iOldSupplierCreditInvoice)));
                }
                this.iSupplierCreditInvoices.remove(iIndex);
                this.iSupplierCreditInvoices.add(iIndex, iSupplierCreditInvoice);
                if (SSSupplierInvoiceMath.iSaldoMap.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                    SSSupplierInvoiceMath.iSaldoMap.put(iSupplierCreditInvoice.getCreditingNr(), SSSupplierInvoiceMath.iSaldoMap.get(iSupplierCreditInvoice.getCreditingNr()).subtract(SSSupplierInvoiceMath.getTotalSum(iSupplierCreditInvoice)));
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                iSupplierCreditInvoice = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierCreditInvoiceFrame.getInstance() != null) {
                    SSSupplierCreditInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETESUPPLIERCREDITINVOICE") && this.iSupplierCreditInvoices != null) {
                SSSupplierCreditInvoice iSupplierCreditInvoice = new SSSupplierCreditInvoice();
                iSupplierCreditInvoice.setNumber(Integer.parseInt(iNumber));
                this.iSupplierCreditInvoices.remove(iSupplierCreditInvoice);
                iSupplierCreditInvoice = null;
                if (SSSupplierFrame.getInstance() != null) {
                    SSSupplierFrame.getInstance().updateFrame();
                }
                if (SSSupplierInvoiceFrame.getInstance() != null) {
                    SSSupplierInvoiceFrame.getInstance().updateFrame();
                }
                if (SSSupplierCreditInvoiceFrame.getInstance() != null) {
                    SSSupplierCreditInvoiceFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWINVENTORY") && this.iInventories != null) {
                SSInventory iInventory = new SSInventory();
                iInventory.setNumber(Integer.parseInt(iNumber));
                iInventory = this.getInventory(iInventory);
                if (!this.iInventories.contains(iInventory)) {
                    this.iInventories.add(iInventory);
                }
                if (SSInventoryFrame.getInstance() != null) {
                    SSInventoryFrame.getInstance().updateFrame();
                }
                iInventory = null;
            } else if (iTriggerName.equals("EDITINVENTORY") && this.iInventories != null) {
                SSInventory iInventory = new SSInventory();
                iInventory.setNumber(Integer.parseInt(iNumber));
                iInventory = this.getInventory(iInventory);
                int iIndex = this.iInventories.lastIndexOf(iInventory);
                if (iIndex == -1) {
                    return;
                }
                this.iInventories.remove(iIndex);
                this.iInventories.add(iIndex, iInventory);
                iInventory = null;
                if (SSInventoryFrame.getInstance() != null) {
                    SSInventoryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEINVENTORY") && this.iInventories != null) {
                SSInventory iInventory = new SSInventory();
                iInventory.setNumber(Integer.parseInt(iNumber));
                this.iInventories.remove(iInventory);
                iInventory = null;
                if (SSInventoryFrame.getInstance() != null) {
                    SSInventoryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWINDELIVERY") && this.iIndeliveries != null) {
                SSIndelivery iIndelivery = new SSIndelivery();
                iIndelivery.setNumber(Integer.parseInt(iNumber));
                iIndelivery = this.getIndelivery(iIndelivery);
                if (!this.iIndeliveries.contains(iIndelivery)) {
                    this.iIndeliveries.add(iIndelivery);
                }
                if (SSIndeliveryFrame.getInstance() != null) {
                    SSIndeliveryFrame.getInstance().updateFrame();
                }
                iIndelivery = null;
            } else if (iTriggerName.equals("EDITINDELIVERY") && this.iIndeliveries != null) {
                SSIndelivery iIndelivery = new SSIndelivery();
                iIndelivery.setNumber(Integer.parseInt(iNumber));
                iIndelivery = this.getIndelivery(iIndelivery);
                int iIndex = this.iIndeliveries.lastIndexOf(iIndelivery);
                if (iIndex == -1) {
                    return;
                }
                this.iIndeliveries.remove(iIndex);
                this.iIndeliveries.add(iIndex, iIndelivery);
                iIndelivery = null;
                if (SSIndeliveryFrame.getInstance() != null) {
                    SSIndeliveryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEINDELIVERY") && this.iIndeliveries != null) {
                SSIndelivery iIndelivery = new SSIndelivery();
                iIndelivery.setNumber(Integer.parseInt(iNumber));
                this.iIndeliveries.remove(iIndelivery);
                iIndelivery = null;
                if (SSIndeliveryFrame.getInstance() != null) {
                    SSIndeliveryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWOUTDELIVERY") && this.iOutdeliveries != null) {
                SSOutdelivery iOutdelivery = new SSOutdelivery();
                iOutdelivery.setNumber(Integer.parseInt(iNumber));
                iOutdelivery = this.getOutdelivery(iOutdelivery);
                if (!this.iOutdeliveries.contains(iOutdelivery)) {
                    this.iOutdeliveries.add(iOutdelivery);
                }
                if (SSOutdeliveryFrame.getInstance() != null) {
                    SSOutdeliveryFrame.getInstance().updateFrame();
                }
                iOutdelivery = null;
            } else if (iTriggerName.equals("EDITOUTDELIVERY") && this.iOutdeliveries != null) {
                SSOutdelivery iOutdelivery = new SSOutdelivery();
                iOutdelivery.setNumber(Integer.parseInt(iNumber));
                iOutdelivery = this.getOutdelivery(iOutdelivery);
                int iIndex = this.iOutdeliveries.lastIndexOf(iOutdelivery);
                if (iIndex == -1) {
                    return;
                }
                this.iOutdeliveries.remove(iIndex);
                this.iOutdeliveries.add(iIndex, iOutdelivery);
                iOutdelivery = null;
                if (SSOutdeliveryFrame.getInstance() != null) {
                    SSOutdeliveryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEOUTDELIVERY") && this.iOutdeliveries != null) {
                SSOutdelivery iOutdelivery = new SSOutdelivery();
                iOutdelivery.setNumber(Integer.parseInt(iNumber));
                this.iOutdeliveries.remove(iOutdelivery);
                iOutdelivery = null;
                if (SSOutdeliveryFrame.getInstance() != null) {
                    SSOutdeliveryFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWVOUCHER") && this.iVouchers != null) {
                SSVoucher iVoucher = new SSVoucher(Integer.parseInt(iNumber));
                if (!this.iVouchers.contains(iVoucher = this.getVoucher(iVoucher))) {
                    this.iVouchers.add(iVoucher);
                }
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().updateFrame();
                }
                iVoucher = null;
            } else if (iTriggerName.equals("EDITVOUCHER") && this.iVouchers != null) {
                SSVoucher iVoucher = new SSVoucher(Integer.parseInt(iNumber));
                int iIndex = this.iVouchers.lastIndexOf(iVoucher = this.getVoucher(iVoucher));
                if (iIndex == -1) {
                    return;
                }
                this.iVouchers.remove(iIndex);
                this.iVouchers.add(iIndex, iVoucher);
                iVoucher = null;
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEVOUCHER") && this.iVouchers != null) {
                SSVoucher iVoucher = new SSVoucher(Integer.parseInt(iNumber));
                this.iVouchers.remove(iVoucher);
                iVoucher = null;
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("NEWOWNREPORT") && this.iOwnReports != null) {
                SSOwnReport iOwnReport = new SSOwnReport();
                iOwnReport.setId(Integer.parseInt(iNumber));
                iOwnReport = this.getOwnReport(iOwnReport);
                if (!this.iOwnReports.contains(iOwnReport) && iOwnReport.getId() != -1) {
                    this.iOwnReports.add(iOwnReport);
                }
                if (SSOwnReportFrame.getInstance() != null) {
                    SSOwnReportFrame.getInstance().updateFrame();
                }
                iOwnReport = null;
            } else if (iTriggerName.equals("EDITOWNREPORT") && this.iOwnReports != null) {
                SSOwnReport iOwnReport = new SSOwnReport();
                iOwnReport.setId(Integer.parseInt(iNumber));
                iOwnReport = this.getOwnReport(iOwnReport);
                int iIndex = this.iOwnReports.lastIndexOf(iOwnReport);
                if (iIndex != -1) {
                    this.iOwnReports.remove(iIndex);
                    this.iOwnReports.add(iIndex, iOwnReport);
                } else {
                    this.iOwnReports.add(iOwnReport);
                }
                iOwnReport = null;
                if (SSOwnReportFrame.getInstance() != null) {
                    SSOwnReportFrame.getInstance().updateFrame();
                }
            } else if (iTriggerName.equals("DELETEOWNREPORT") && this.iOwnReports != null) {
                SSOwnReport iOwnReport = new SSOwnReport();
                iOwnReport.setId(Integer.parseInt(iNumber));
                this.iOwnReports.remove(iOwnReport);
                iOwnReport = null;
                if (SSOwnReportFrame.getInstance() != null) {
                    SSOwnReportFrame.getInstance().updateFrame();
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public List<SSProduct> getProducts() {
        if (this.iProducts != null) {
            return this.iProducts;
        }
        this.iProducts = new LinkedList<SSProduct>();
        if (this.iCurrentCompany == null) {
            return this.iProducts;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_product WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iProducts.add((SSProduct)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iProducts;
    }

    public SSProduct getProduct(SSProduct pProduct) {
        if (pProduct == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_product WHERE number=? AND companyid=?");
            iStatement.setObject(1, pProduct.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSProduct iProduct = (SSProduct)iResultSet.getObject(3);
                iStatement.close();
                return iProduct;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public SSProduct getProduct(String iProductNumber) {
        if (iProductNumber == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_product WHERE LOWER(number)=LOWER('" + iProductNumber + "') AND companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSProduct iProduct = (SSProduct)iResultSet.getObject(3);
                iStatement.close();
                return iProduct;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSProduct> getProducts(List<SSProduct> pProducts) {
        if (pProducts == null) {
            return null;
        }
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>();
        if (this.iProducts != null) {
            for (SSProduct iProduct : pProducts) {
                if (!this.iProducts.contains(iProduct)) continue;
                iProducts.add(iProduct);
            }
            return iProducts;
        }
        if (this.iCurrentCompany == null) {
            return iProducts;
        }
        try {
            for (SSProduct iProduct : pProducts) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_product WHERE number=? AND companyid=?");
                iStatement.setObject(1, iProduct.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iProducts.add((SSProduct)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iProducts;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addProduct(SSProduct iProduct) {
        if (iProduct == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_product VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iProduct.getNumber());
            iStatement.setObject(2, iProduct);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateProduct(SSProduct iProduct) {
        if (iProduct == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_product SET product=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iProduct);
            iStatement.setObject(2, iProduct.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteProduct(SSProduct iProduct) {
        if (iProduct == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_product WHERE number=? AND companyid=?");
            iStatement.setObject(1, iProduct.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSCustomer> getCustomers() {
        if (this.iCustomers != null) {
            return this.iCustomers;
        }
        this.iCustomers = new LinkedList<SSCustomer>();
        if (this.iCurrentCompany == null) {
            return this.iCustomers;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_customer WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iCustomers.add((SSCustomer)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iCustomers;
    }

    public SSCustomer getCustomer(SSCustomer pCustomer) {
        if (pCustomer == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_customer WHERE number=? AND companyid=?");
            iStatement.setObject(1, pCustomer.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSCustomer iCustomer = (SSCustomer)iResultSet.getObject(3);
                iStatement.close();
                return iCustomer;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public SSCustomer getCustomer(String iCustomerNumber) {
        if (iCustomerNumber == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_customer WHERE LOWER(number)=LOWER('" + iCustomerNumber + "') AND companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSCustomer iCustomer = (SSCustomer)iResultSet.getObject(3);
                iStatement.close();
                return iCustomer;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSCustomer> getCustomers(List<SSCustomer> pCustomers) {
        if (pCustomers == null) {
            return null;
        }
        LinkedList<SSCustomer> iCustomers = new LinkedList<SSCustomer>();
        if (this.iCustomers != null) {
            for (SSCustomer iCustomer : pCustomers) {
                if (!this.iCustomers.contains(iCustomer)) continue;
                iCustomers.add(iCustomer);
            }
            return iCustomers;
        }
        if (this.iCurrentCompany == null) {
            return iCustomers;
        }
        try {
            for (SSCustomer iCustomer : pCustomers) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_customer WHERE number=? AND companyid=?");
                iStatement.setObject(1, iCustomer.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iCustomers.add((SSCustomer)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iCustomers;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addCustomer(SSCustomer iCustomer) {
        if (iCustomer == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_customer VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iCustomer.getNumber());
            iStatement.setObject(2, iCustomer);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateCustomer(SSCustomer iCustomer) {
        if (iCustomer == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_customer SET customer=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iCustomer);
            iStatement.setObject(2, iCustomer.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteCustomer(SSCustomer iCustomer) {
        if (iCustomer == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_customer WHERE number=? AND companyid=?");
            iStatement.setObject(1, iCustomer.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSSupplier> getSuppliers() {
        if (this.iSuppliers != null) {
            return this.iSuppliers;
        }
        this.iSuppliers = new LinkedList<SSSupplier>();
        if (this.iCurrentCompany == null) {
            return this.iSuppliers;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplier WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iSuppliers.add((SSSupplier)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iSuppliers;
    }

    public SSSupplier getSupplier(SSSupplier pSupplier) {
        if (pSupplier == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplier WHERE number=? AND companyid=?");
            iStatement.setObject(1, pSupplier.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSSupplier iSupplier = (SSSupplier)iResultSet.getObject(3);
                iStatement.close();
                return iSupplier;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSSupplier> getSuppliers(List<SSSupplier> pSuppliers) {
        if (pSuppliers == null) {
            return null;
        }
        LinkedList<SSSupplier> iSuppliers = new LinkedList<SSSupplier>();
        if (this.iSuppliers != null) {
            for (SSSupplier iSupplier : pSuppliers) {
                if (!this.iSuppliers.contains(iSupplier)) continue;
                iSuppliers.add(iSupplier);
            }
            return iSuppliers;
        }
        if (this.iCurrentCompany == null) {
            return iSuppliers;
        }
        try {
            for (SSSupplier iSupplier : pSuppliers) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplier WHERE number=? AND companyid=?");
                iStatement.setObject(1, iSupplier.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iSuppliers.add((SSSupplier)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iSuppliers;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addSupplier(SSSupplier iSupplier) {
        if (iSupplier == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_supplier VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iSupplier.getNumber());
            iStatement.setObject(2, iSupplier);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateSupplier(SSSupplier iSupplier) {
        if (iSupplier == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_supplier SET supplier=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplier);
            iStatement.setObject(2, iSupplier.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteSupplier(SSSupplier iSupplier) {
        if (iSupplier == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_supplier WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplier.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSAutoDist> getAutoDists() {
        if (this.iAutoDists != null) {
            return this.iAutoDists;
        }
        this.iAutoDists = new LinkedList<SSAutoDist>();
        if (this.iCurrentCompany == null) {
            return this.iAutoDists;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_autodist WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iAutoDists.add((SSAutoDist)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iAutoDists;
    }

    public SSAutoDist getAutoDist(SSAutoDist pAutoDist) {
        if (pAutoDist == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_autodist WHERE number=? AND companyid=?");
            iStatement.setObject(1, pAutoDist.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSAutoDist iAutoDist = (SSAutoDist)iResultSet.getObject(3);
                iStatement.close();
                return iAutoDist;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSAutoDist> getAutoDists(List<SSAutoDist> pAutoDists) {
        if (pAutoDists == null) {
            return null;
        }
        LinkedList<SSAutoDist> iAutoDists = new LinkedList<SSAutoDist>();
        if (this.iAutoDists != null) {
            for (SSAutoDist iAutoDist : pAutoDists) {
                if (!this.iAutoDists.contains(iAutoDist)) continue;
                iAutoDists.add(iAutoDist);
            }
            return iAutoDists;
        }
        if (this.iCurrentCompany == null) {
            return iAutoDists;
        }
        try {
            for (SSAutoDist iAutoDist : pAutoDists) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_autodist WHERE number=? AND companyid=?");
                iStatement.setObject(1, iAutoDist.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iAutoDists.add((SSAutoDist)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iAutoDists;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addAutoDist(SSAutoDist iAutoDist) {
        if (iAutoDist == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_autodist VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iAutoDist.getNumber());
            iStatement.setObject(2, iAutoDist);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateAutoDist(SSAutoDist iAutoDist, SSAutoDist iOriginal) {
        if (iAutoDist == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_autodist SET autodist=?, number=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iAutoDist);
            iStatement.setObject(2, iAutoDist.getNumber());
            iStatement.setObject(3, iOriginal.getNumber());
            iStatement.setObject(4, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteAutoDist(SSAutoDist iAutoDist) {
        if (iAutoDist == null || this.iCurrentCompany == null) {
            return;
        }
        if (this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_autodist WHERE number=? AND companyid=?");
            iStatement.setObject(1, iAutoDist.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSTender> getTenders() {
        if (this.iTenders != null) {
            return this.iTenders;
        }
        this.iTenders = new LinkedList<SSTender>();
        if (this.iCurrentCompany == null) {
            return this.iTenders;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_tender WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iTenders.add((SSTender)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iTenders;
    }

    public SSTender getTender(SSTender pTender) {
        if (pTender == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_tender WHERE number=? AND companyid=?");
            iStatement.setObject(1, pTender.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSTender iTender = (SSTender)iResultSet.getObject(3);
                iStatement.close();
                return iTender;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSTender> getTenders(List<SSTender> pTenders) {
        if (pTenders == null) {
            return null;
        }
        LinkedList<SSTender> iTenders = new LinkedList<SSTender>();
        if (this.iTenders != null) {
            for (SSTender iTender : pTenders) {
                if (!this.iTenders.contains(iTender)) continue;
                iTenders.add(iTender);
            }
            return iTenders;
        }
        if (this.iCurrentCompany == null) {
            return iTenders;
        }
        try {
            for (SSTender iTender : pTenders) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_tender WHERE number=? AND companyid=?");
                iStatement.setObject(1, iTender.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iTenders.add((SSTender)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iTenders;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addTender(SSTender iTender) {
        if (iTender == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_tender WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("tender");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iTender.setNumber(iNumber + 1);
                } else {
                    iTender.setNumber(iCompanyNumber + 1);
                }
            } else {
                iTender.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_tender VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iTender.getNumber());
            iStatement.setObject(2, iTender);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateTender(SSTender iTender) {
        if (iTender == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_tender SET tender=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iTender);
            iStatement.setObject(2, iTender.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteTender(SSTender iTender) {
        if (iTender == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_tender WHERE number=? AND companyid=?");
            iStatement.setObject(1, iTender.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSOrder> getOrders() {
        if (this.iOrders != null) {
            return this.iOrders;
        }
        this.iOrders = new LinkedList<SSOrder>();
        if (this.iCurrentCompany == null) {
            return this.iOrders;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_order WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iOrders.add((SSOrder)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iOrders;
    }

    public SSOrder getOrder(SSOrder pOrder) {
        if (pOrder == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_order WHERE number=? AND companyid=?");
            iStatement.setObject(1, pOrder.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSOrder iOrder = (SSOrder)iResultSet.getObject(3);
                iStatement.close();
                return iOrder;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSOrder> getOrders(List<SSOrder> pOrders) {
        if (pOrders == null) {
            return null;
        }
        LinkedList<SSOrder> iOrders = new LinkedList<SSOrder>();
        if (this.iOrders != null) {
            for (SSOrder iOrder : pOrders) {
                if (!this.iOrders.contains(iOrder)) continue;
                iOrders.add(iOrder);
            }
            return iOrders;
        }
        if (this.iCurrentCompany == null) {
            return iOrders;
        }
        try {
            for (SSOrder iOrder : pOrders) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_order WHERE number=? AND companyid=?");
                iStatement.setObject(1, iOrder.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iOrders.add((SSOrder)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iOrders;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addOrder(SSOrder iOrder) {
        if (iOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_order WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("order");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iOrder.setNumber(iNumber + 1);
                } else {
                    iOrder.setNumber(iCompanyNumber + 1);
                }
            } else {
                iOrder.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_order VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iOrder.getNumber());
            iStatement.setObject(2, iOrder);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateOrder(SSOrder iOrder) {
        if (iOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_order SET iorder=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOrder);
            iStatement.setObject(2, iOrder.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteOrder(SSOrder iOrder) {
        if (iOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_order WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOrder.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSInvoice> getInvoices() {
        if (this.iInvoices != null) {
            return this.iInvoices;
        }
        this.iInvoices = new LinkedList<SSInvoice>();
        if (this.iCurrentCompany == null) {
            return this.iInvoices;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_invoice WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iInvoices.add((SSInvoice)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iInvoices;
    }

    public SSInvoice getInvoice(SSInvoice pInvoice) {
        if (pInvoice == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_invoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, pInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSInvoice iInvoice = (SSInvoice)iResultSet.getObject(3);
                iStatement.close();
                return iInvoice;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSInvoice> getInvoices(List<SSInvoice> pInvoices) {
        if (pInvoices == null) {
            return null;
        }
        LinkedList<SSInvoice> iInvoices = new LinkedList<SSInvoice>();
        if (this.iInvoices != null) {
            for (SSInvoice iInvoice : pInvoices) {
                if (!this.iInvoices.contains(iInvoice)) continue;
                iInvoices.add(iInvoice);
            }
            return iInvoices;
        }
        if (this.iCurrentCompany == null) {
            return iInvoices;
        }
        try {
            for (SSInvoice iInvoice : pInvoices) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_invoice WHERE number=? AND companyid=?");
                iStatement.setObject(1, iInvoice.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iInvoices.add((SSInvoice)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iInvoices;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addInvoice(SSInvoice iInvoice) {
        if (iInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_invoice WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("invoice");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iInvoice.setNumber(iNumber + 1);
                } else {
                    iInvoice.setNumber(iCompanyNumber + 1);
                }
            } else {
                iInvoice.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_invoice VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iInvoice.getNumber());
            iStatement.setObject(2, iInvoice);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateInvoice(SSInvoice iInvoice) {
        if (iInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_invoice SET invoice=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInvoice);
            iStatement.setObject(2, iInvoice.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteInvoice(SSInvoice iInvoice) {
        if (iInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_invoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSInpayment> getInpayments() {
        if (this.iInpayments != null) {
            return this.iInpayments;
        }
        this.iInpayments = new LinkedList<SSInpayment>();
        if (this.iCurrentCompany == null) {
            return this.iInpayments;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_inpayment WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iInpayments.add((SSInpayment)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iInpayments;
    }

    public SSInpayment getInpayment(SSInpayment pInpayment) {
        if (pInpayment == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_inpayment WHERE number=? AND companyid=?");
            iStatement.setObject(1, pInpayment.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSInpayment iInpayment = (SSInpayment)iResultSet.getObject(3);
                iStatement.close();
                return iInpayment;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addInpayment(SSInpayment iInpayment) {
        if (iInpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_inpayment WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("inpayment");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iInpayment.setNumber(iNumber + 1);
                } else {
                    iInpayment.setNumber(iCompanyNumber + 1);
                }
            } else {
                iInpayment.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_inpayment VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iInpayment.getNumber());
            iStatement.setObject(2, iInpayment);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateInpayment(SSInpayment iInpayment) {
        if (iInpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_inpayment SET inpayment=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInpayment);
            iStatement.setObject(2, iInpayment.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteInpayment(SSInpayment iInpayment) {
        if (iInpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_inpayment WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInpayment.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSOutpayment> getOutpayments() {
        if (this.iOutpayments != null) {
            return this.iOutpayments;
        }
        this.iOutpayments = new LinkedList<SSOutpayment>();
        if (this.iCurrentCompany == null) {
            return this.iOutpayments;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_outpayment WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iOutpayments.add((SSOutpayment)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iOutpayments;
    }

    public SSOutpayment getOutpayment(SSOutpayment pOutpayment) {
        if (pOutpayment == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_outpayment WHERE number=? AND companyid=?");
            iStatement.setObject(1, pOutpayment.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSOutpayment iOutpayment = (SSOutpayment)iResultSet.getObject(3);
                iStatement.close();
                return iOutpayment;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addOutpayment(SSOutpayment iOutpayment) {
        if (iOutpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_outpayment WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("outpayment");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iOutpayment.setNumber(iNumber + 1);
                } else {
                    iOutpayment.setNumber(iCompanyNumber + 1);
                }
            } else {
                iOutpayment.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_outpayment VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iOutpayment.getNumber());
            iStatement.setObject(2, iOutpayment);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateOutpayment(SSOutpayment iOutpayment) {
        if (iOutpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_outpayment SET outpayment=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOutpayment);
            iStatement.setObject(2, iOutpayment.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteOutpayment(SSOutpayment iOutpayment) {
        if (iOutpayment == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_outpayment WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOutpayment.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSCreditInvoice> getCreditInvoices() {
        if (this.iCreditInvoices != null) {
            return this.iCreditInvoices;
        }
        this.iCreditInvoices = new LinkedList<SSCreditInvoice>();
        if (this.iCurrentCompany == null) {
            return this.iCreditInvoices;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_creditinvoice WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iCreditInvoices.add((SSCreditInvoice)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iCreditInvoices;
    }

    public SSCreditInvoice getCreditInvoice(SSCreditInvoice pCreditInvoice) {
        if (pCreditInvoice == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_creditinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, pCreditInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSCreditInvoice iCreditInvoice = (SSCreditInvoice)iResultSet.getObject(3);
                iStatement.close();
                return iCreditInvoice;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSCreditInvoice> getCreditInvoices(List<SSCreditInvoice> pCreditInvoices) {
        if (pCreditInvoices == null) {
            return null;
        }
        LinkedList<SSCreditInvoice> iCreditInvoices = new LinkedList<SSCreditInvoice>();
        if (this.iCreditInvoices != null) {
            for (SSCreditInvoice iCreditInvoice : pCreditInvoices) {
                if (!this.iCreditInvoices.contains(iCreditInvoice)) continue;
                iCreditInvoices.add(iCreditInvoice);
            }
            return iCreditInvoices;
        }
        if (this.iCurrentCompany == null) {
            return iCreditInvoices;
        }
        try {
            for (SSCreditInvoice iCreditInvoice : pCreditInvoices) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_creditinvoice WHERE number=? AND companyid=?");
                iStatement.setObject(1, iCreditInvoice.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iCreditInvoices.add((SSCreditInvoice)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iCreditInvoices;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addCreditInvoice(SSCreditInvoice iCreditInvoice) {
        if (iCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_creditinvoice WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("creditinvoice");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iCreditInvoice.setNumber(iNumber + 1);
                } else {
                    iCreditInvoice.setNumber(iCompanyNumber + 1);
                }
            } else {
                iCreditInvoice.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_creditinvoice VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iCreditInvoice.getNumber());
            iStatement.setObject(2, iCreditInvoice);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateCreditInvoice(SSCreditInvoice iCreditInvoice) {
        if (iCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_creditinvoice SET creditinvoice=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iCreditInvoice);
            iStatement.setObject(2, iCreditInvoice.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteCreditInvoice(SSCreditInvoice iCreditInvoice) {
        if (iCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_creditinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, iCreditInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSPeriodicInvoice> getPeriodicInvoices() {
        if (this.iPeriodicInvoices != null) {
            return this.iPeriodicInvoices;
        }
        this.iPeriodicInvoices = new LinkedList<SSPeriodicInvoice>();
        if (this.iCurrentCompany == null) {
            return this.iPeriodicInvoices;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_periodicinvoice WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iPeriodicInvoices.add((SSPeriodicInvoice)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iPeriodicInvoices;
    }

    public SSPeriodicInvoice getPeriodicInvoice(SSPeriodicInvoice pPeriodicInvoice) {
        if (pPeriodicInvoice == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_periodicinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, pPeriodicInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSPeriodicInvoice iPeriodicInvoice = (SSPeriodicInvoice)iResultSet.getObject(3);
                iStatement.close();
                return iPeriodicInvoice;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        if (iPeriodicInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_periodicinvoice WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("periodicinvoice");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iPeriodicInvoice.setNumber(iNumber + 1);
                } else {
                    iPeriodicInvoice.setNumber(iCompanyNumber + 1);
                }
            } else {
                iPeriodicInvoice.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_periodicinvoice VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iPeriodicInvoice.getNumber());
            iStatement.setObject(2, iPeriodicInvoice);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updatePeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        if (iPeriodicInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_periodicinvoice SET periodicinvoice=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iPeriodicInvoice);
            iStatement.setObject(2, iPeriodicInvoice.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deletePeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        if (iPeriodicInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_periodicinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, iPeriodicInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSPurchaseOrder> getPurchaseOrders() {
        if (this.iPurchaseOrders != null) {
            return this.iPurchaseOrders;
        }
        this.iPurchaseOrders = new LinkedList<SSPurchaseOrder>();
        if (this.iCurrentCompany == null) {
            return this.iPurchaseOrders;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_purchaseorder WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iPurchaseOrders.add((SSPurchaseOrder)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iPurchaseOrders;
    }

    public SSPurchaseOrder getPurchaseOrder(SSPurchaseOrder pPurchaseOrder) {
        if (pPurchaseOrder == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_purchaseorder WHERE number=? AND companyid=?");
            iStatement.setObject(1, pPurchaseOrder.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSPurchaseOrder iPurchaseOrder = (SSPurchaseOrder)iResultSet.getObject(3);
                iStatement.close();
                return iPurchaseOrder;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSPurchaseOrder> getPurchaseOrders(List<SSPurchaseOrder> pPurchaseOrders) {
        if (pPurchaseOrders == null) {
            return null;
        }
        LinkedList<SSPurchaseOrder> iPurchaseOrders = new LinkedList<SSPurchaseOrder>();
        if (this.iPurchaseOrders != null) {
            for (SSPurchaseOrder iPurchaseOrder : pPurchaseOrders) {
                if (!this.iPurchaseOrders.contains(iPurchaseOrder)) continue;
                iPurchaseOrders.add(iPurchaseOrder);
            }
            return iPurchaseOrders;
        }
        if (this.iCurrentCompany == null) {
            return iPurchaseOrders;
        }
        try {
            for (SSPurchaseOrder iPurchaseOrder : pPurchaseOrders) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_purchaseorder WHERE number=? AND companyid=?");
                iStatement.setObject(1, iPurchaseOrder.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iPurchaseOrders.add((SSPurchaseOrder)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iPurchaseOrders;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addPurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        if (iPurchaseOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_purchaseorder WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("purchaseorder");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iPurchaseOrder.setNumber(iNumber + 1);
                } else {
                    iPurchaseOrder.setNumber(iCompanyNumber + 1);
                }
            } else {
                iPurchaseOrder.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_purchaseorder VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iPurchaseOrder.getNumber());
            iStatement.setObject(2, iPurchaseOrder);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updatePurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        if (iPurchaseOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_purchaseorder SET purchaseorder=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iPurchaseOrder);
            iStatement.setObject(2, iPurchaseOrder.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deletePurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        if (iPurchaseOrder == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_purchaseorder WHERE number=? AND companyid=?");
            iStatement.setObject(1, iPurchaseOrder.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSSupplierInvoice> getSupplierInvoices() {
        if (this.iSupplierInvoices != null) {
            return this.iSupplierInvoices;
        }
        this.iSupplierInvoices = new LinkedList<SSSupplierInvoice>();
        if (this.iCurrentCompany == null) {
            return this.iSupplierInvoices;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplierinvoice WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iSupplierInvoices.add((SSSupplierInvoice)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iSupplierInvoices;
    }

    public SSSupplierInvoice getSupplierInvoice(SSSupplierInvoice pSupplierInvoice) {
        if (pSupplierInvoice == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplierinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, pSupplierInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSSupplierInvoice iSupplierInvoice = (SSSupplierInvoice)iResultSet.getObject(3);
                iStatement.close();
                return iSupplierInvoice;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSSupplierInvoice> getSupplierInvoices(List<SSSupplierInvoice> pSupplierInvoices) {
        if (pSupplierInvoices == null) {
            return null;
        }
        LinkedList<SSSupplierInvoice> iSupplierInvoices = new LinkedList<SSSupplierInvoice>();
        if (this.iSupplierInvoices != null) {
            for (SSSupplierInvoice iSupplierInvoice : pSupplierInvoices) {
                if (!this.iSupplierInvoices.contains(iSupplierInvoice)) continue;
                iSupplierInvoices.add(iSupplierInvoice);
            }
            return iSupplierInvoices;
        }
        if (this.iCurrentCompany == null) {
            return iSupplierInvoices;
        }
        try {
            for (SSSupplierInvoice iSupplierInvoice : pSupplierInvoices) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_supplierinvoice WHERE number=? AND companyid=?");
                iStatement.setObject(1, iSupplierInvoice.getNumber());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iSupplierInvoices.add((SSSupplierInvoice)iResultSet.getObject(3));
                }
                iStatement.close();
            }
            return iSupplierInvoices;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addSupplierInvoice(SSSupplierInvoice iSupplierInvoice) {
        if (iSupplierInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_supplierinvoice WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("supplierinvoice");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iSupplierInvoice.setNumber(iNumber + 1);
                } else {
                    iSupplierInvoice.setNumber(iCompanyNumber + 1);
                }
            } else {
                iSupplierInvoice.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_supplierinvoice VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iSupplierInvoice.getNumber());
            iStatement.setObject(2, iSupplierInvoice);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateSupplierInvoice(SSSupplierInvoice iSupplierInvoice) {
        if (iSupplierInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_supplierinvoice SET supplierinvoice=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplierInvoice);
            iStatement.setObject(2, iSupplierInvoice.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteSupplierInvoice(SSSupplierInvoice iSupplierInvoice) {
        if (iSupplierInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_supplierinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplierInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSSupplierCreditInvoice> getSupplierCreditInvoices() {
        if (this.iSupplierCreditInvoices != null) {
            return this.iSupplierCreditInvoices;
        }
        this.iSupplierCreditInvoices = new LinkedList<SSSupplierCreditInvoice>();
        if (this.iCurrentCompany == null) {
            return this.iSupplierCreditInvoices;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_suppliercreditinvoice WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iSupplierCreditInvoices.add((SSSupplierCreditInvoice)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iSupplierCreditInvoices;
    }

    public SSSupplierCreditInvoice getSupplierCreditInvoice(SSSupplierCreditInvoice pSupplierCreditInvoice) {
        if (pSupplierCreditInvoice == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_suppliercreditinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, pSupplierCreditInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSSupplierCreditInvoice iSupplierCreditInvoice = (SSSupplierCreditInvoice)iResultSet.getObject(3);
                iStatement.close();
                return iSupplierCreditInvoice;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addSupplierCreditInvoice(SSSupplierCreditInvoice iSupplierCreditInvoice) {
        if (iSupplierCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_suppliercreditinvoice WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("suppliercreditinvoice");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iSupplierCreditInvoice.setNumber(iNumber + 1);
                } else {
                    iSupplierCreditInvoice.setNumber(iCompanyNumber + 1);
                }
            } else {
                iSupplierCreditInvoice.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_suppliercreditinvoice VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iSupplierCreditInvoice.getNumber());
            iStatement.setObject(2, iSupplierCreditInvoice);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateSupplierCreditInvoice(SSSupplierCreditInvoice iSupplierCreditInvoice) {
        if (iSupplierCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_suppliercreditinvoice SET suppliercreditinvoice=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplierCreditInvoice);
            iStatement.setObject(2, iSupplierCreditInvoice.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteSupplierCreditInvoice(SSSupplierCreditInvoice iSupplierCreditInvoice) {
        if (iSupplierCreditInvoice == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_suppliercreditinvoice WHERE number=? AND companyid=?");
            iStatement.setObject(1, iSupplierCreditInvoice.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSInventory> getInventories() {
        if (this.iInventories != null) {
            return this.iInventories;
        }
        this.iInventories = new LinkedList<SSInventory>();
        if (this.iCurrentCompany == null) {
            return this.iInventories;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_inventory WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iInventories.add((SSInventory)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iInventories;
    }

    public SSInventory getInventory(SSInventory pInventory) {
        if (pInventory == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_inventory WHERE number=? AND companyid=?");
            iStatement.setObject(1, pInventory.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSInventory iInventory = (SSInventory)iResultSet.getObject(3);
                iStatement.close();
                return iInventory;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addInventory(SSInventory iInventory) {
        if (iInventory == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_inventory WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("inventory");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iInventory.setNumber(iNumber + 1);
                } else {
                    iInventory.setNumber(iCompanyNumber + 1);
                }
            } else {
                iInventory.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_inventory VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iInventory.getNumber());
            iStatement.setObject(2, iInventory);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateInventory(SSInventory iInventory) {
        if (iInventory == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_inventory SET inventory=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInventory);
            iStatement.setObject(2, iInventory.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteInventory(SSInventory iInventory) {
        if (iInventory == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_inventory WHERE number=? AND companyid=?");
            iStatement.setObject(1, iInventory.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSIndelivery> getIndeliveries() {
        if (this.iIndeliveries != null) {
            return this.iIndeliveries;
        }
        this.iIndeliveries = new LinkedList<SSIndelivery>();
        if (this.iCurrentCompany == null) {
            return this.iIndeliveries;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_indelivery WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iIndeliveries.add((SSIndelivery)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iIndeliveries;
    }

    public SSIndelivery getIndelivery(SSIndelivery pIndelivery) {
        if (pIndelivery == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_indelivery WHERE number=? AND companyid=?");
            iStatement.setObject(1, pIndelivery.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSIndelivery iIndelivery = (SSIndelivery)iResultSet.getObject(3);
                iStatement.close();
                return iIndelivery;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addIndelivery(SSIndelivery iIndelivery) {
        if (iIndelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_indelivery WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("indelivery");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iIndelivery.setNumber(iNumber + 1);
                } else {
                    iIndelivery.setNumber(iCompanyNumber + 1);
                }
            } else {
                iIndelivery.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_indelivery VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iIndelivery.getNumber());
            iStatement.setObject(2, iIndelivery);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateIndelivery(SSIndelivery iIndelivery) {
        if (iIndelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_indelivery SET indelivery=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iIndelivery);
            iStatement.setObject(2, iIndelivery.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteIndelivery(SSIndelivery iIndelivery) {
        if (iIndelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_indelivery WHERE number=? AND companyid=?");
            iStatement.setObject(1, iIndelivery.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSOutdelivery> getOutdeliveries() {
        if (this.iOutdeliveries != null) {
            return this.iOutdeliveries;
        }
        this.iOutdeliveries = new LinkedList<SSOutdelivery>();
        if (this.iCurrentCompany == null) {
            return this.iOutdeliveries;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_outdelivery WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iOutdeliveries.add((SSOutdelivery)iResultSet.getObject(3));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iOutdeliveries;
    }

    public SSOutdelivery getOutdelivery(SSOutdelivery pOutdelivery) {
        if (pOutdelivery == null || this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_outdelivery WHERE number=? AND companyid=?");
            iStatement.setObject(1, pOutdelivery.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSOutdelivery iOutdelivery = (SSOutdelivery)iResultSet.getObject(3);
                iStatement.close();
                return iOutdelivery;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public void addOutdelivery(SSOutdelivery iOutdelivery) {
        if (iOutdelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            this.LockDatabase();
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT MAX(number) AS maxnum FROM tbl_outdelivery WHERE companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iCompanyNumber = this.getCurrentCompany().getAutoIncrement().getNumber("outdelivery");
            if (iResultSet.next()) {
                Integer iNumber = iResultSet.getInt("maxnum");
                if (iNumber > iCompanyNumber) {
                    iOutdelivery.setNumber(iNumber + 1);
                } else {
                    iOutdelivery.setNumber(iCompanyNumber + 1);
                }
            } else {
                iOutdelivery.setNumber(iCompanyNumber + 1);
            }
            iResultSet.close();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_outdelivery VALUES(NULL,?,?,?)");
            iStatement.setObject(1, iOutdelivery.getNumber());
            iStatement.setObject(2, iOutdelivery);
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.UnlockDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.UnlockDatabase();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateOutdelivery(SSOutdelivery iOutdelivery) {
        if (iOutdelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_outdelivery SET outdelivery=? WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOutdelivery);
            iStatement.setObject(2, iOutdelivery.getNumber());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteOutdelivery(SSOutdelivery iOutdelivery) {
        if (iOutdelivery == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_outdelivery WHERE number=? AND companyid=?");
            iStatement.setObject(1, iOutdelivery.getNumber());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public List<SSOwnReport> getOwnReports() {
        if (this.iOwnReports != null) {
            return this.iOwnReports;
        }
        this.iOwnReports = new LinkedList<SSOwnReport>();
        if (this.iCurrentCompany == null) {
            return this.iOwnReports;
        }
        try {
            ResultSet iResultSet;
            PreparedStatement iStatement;
            int i;
            Integer iMax = -1;
            do {
                iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_ownreport WHERE companyid=? AND id>?");
                iStatement.setObject(1, this.iCurrentCompany.getId());
                iStatement.setObject(2, iMax);
                iStatement.setMaxRows(1024);
                iResultSet = iStatement.executeQuery();
                i = 0;
                while (iResultSet.next()) {
                    iMax = iResultSet.getInt(1);
                    this.iOwnReports.add((SSOwnReport)iResultSet.getObject(2));
                    ++i;
                }
            } while (i == 1024);
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return this.iOwnReports;
    }

    public SSOwnReport getOwnReport(SSOwnReport pOwnReport) {
        if (pOwnReport == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_ownreport WHERE id=? AND companyid=?");
            iStatement.setObject(1, pOwnReport.getId());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSOwnReport iOwnReport = (SSOwnReport)iResultSet.getObject(2);
                iStatement.close();
                return iOwnReport;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public SSOwnReport getOwnReport(Integer iOwnReportNumber) {
        if (iOwnReportNumber == null) {
            return null;
        }
        if (this.iCurrentCompany == null) {
            return null;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_ownreport WHERE id=" + iOwnReportNumber + " AND companyid=?");
            iStatement.setObject(1, this.iCurrentCompany.getId());
            ResultSet iResultSet = iStatement.executeQuery();
            if (iResultSet.next()) {
                SSOwnReport iOwnReport = (SSOwnReport)iResultSet.getObject(2);
                iStatement.close();
                return iOwnReport;
            }
            iResultSet.close();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
        return null;
    }

    public List<SSOwnReport> getOwnReports(List<SSOwnReport> pOwnReports) {
        if (pOwnReports == null) {
            return null;
        }
        LinkedList<SSOwnReport> iOwnReports = new LinkedList<SSOwnReport>();
        if (this.iOwnReports != null) {
            for (SSOwnReport iOwnReport : pOwnReports) {
                if (!this.iOwnReports.contains(iOwnReport)) continue;
                iOwnReports.add(iOwnReport);
            }
            return iOwnReports;
        }
        if (this.iCurrentCompany == null) {
            return iOwnReports;
        }
        try {
            for (SSOwnReport iOwnReport : pOwnReports) {
                PreparedStatement iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_ownreport WHERE id=? AND companyid=?");
                iStatement.setObject(1, iOwnReport.getId());
                iStatement.setObject(2, this.iCurrentCompany.getId());
                ResultSet iResultSet = iStatement.executeQuery();
                if (iResultSet.next()) {
                    iOwnReports.add((SSOwnReport)iResultSet.getObject(2));
                }
                iStatement.close();
            }
            return iOwnReports;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
            return null;
        }
    }

    public void addOwnReport(SSOwnReport iOwnReport) {
        if (iOwnReport == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("INSERT INTO tbl_ownreport VALUES(NULL,?,?)");
            iStatement.setObject(1, iOwnReport);
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            iStatement = this.iConnection.prepareStatement("SELECT * FROM tbl_ownreport");
            ResultSet iResultSet = iStatement.executeQuery();
            Integer iId = -1;
            while (iResultSet.next()) {
                if (!iResultSet.isLast()) continue;
                iId = iResultSet.getInt("id");
            }
            iResultSet.close();
            iStatement.close();
            iOwnReport.setId(iId);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            iStatement = this.iConnection.prepareStatement("UPDATE tbl_ownreport SET ownreport=? WHERE id=?");
            iStatement.setObject(1, iOwnReport);
            iStatement.setObject(2, iOwnReport.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void updateOwnReport(SSOwnReport iOwnReport) {
        if (iOwnReport == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("UPDATE tbl_ownreport SET ownreport=? WHERE id=? AND companyid=?");
            iStatement.setObject(1, iOwnReport);
            iStatement.setObject(2, iOwnReport.getId());
            iStatement.setObject(3, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void deleteOwnReport(SSOwnReport iOwnReport) {
        if (iOwnReport == null || this.iCurrentCompany == null) {
            return;
        }
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DELETE FROM tbl_ownreport WHERE id=? AND companyid=?");
            iStatement.setObject(1, iOwnReport.getId());
            iStatement.setObject(2, this.iCurrentCompany.getId());
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.iConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
        }
    }

    public void createServerTriggers() {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("CREATE TRIGGER NEWPROJECT  AFTER INSERT ON tbl_project FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITPROJECT  AFTER UPDATE ON tbl_project FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEPROJECT  AFTER DELETE ON tbl_project FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWRESULTUNIT  AFTER INSERT ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITRESULTUNIT  AFTER UPDATE ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETERESULTUNIT  AFTER DELETE ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWPRODUCT  AFTER INSERT ON tbl_product FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITPRODUCT  AFTER UPDATE ON tbl_product FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEPRODUCT  AFTER DELETE ON tbl_product FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWCUSTOMER  AFTER INSERT ON tbl_customer FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITCUSTOMER  AFTER UPDATE ON tbl_customer FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETECUSTOMER  AFTER DELETE ON tbl_customer FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWSUPPLIER  AFTER INSERT ON tbl_supplier FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITSUPPLIER  AFTER UPDATE ON tbl_supplier FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETESUPPLIER  AFTER DELETE ON tbl_supplier FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWVOUCHERTEMPLATE  AFTER INSERT ON tbl_vouchertemplate FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEVOUCHERTEMPLATE  AFTER DELETE ON tbl_vouchertemplate FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWAUTODIST  AFTER INSERT ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITAUTODIST  AFTER UPDATE ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEAUTODIST  AFTER DELETE ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWINPAYMENT  AFTER INSERT ON tbl_inpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITINPAYMENT  AFTER UPDATE ON tbl_inpayment FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEINPAYMENT  AFTER DELETE ON tbl_inpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWTENDER  AFTER INSERT ON tbl_tender FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITTENDER  AFTER UPDATE ON tbl_tender FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETETENDER  AFTER DELETE ON tbl_tender FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWORDER  AFTER INSERT ON tbl_order FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITORDER  AFTER UPDATE ON tbl_order FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEORDER  AFTER DELETE ON tbl_order FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWINVOICE  AFTER INSERT ON tbl_invoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITINVOICE  AFTER UPDATE ON tbl_invoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEINVOICE  AFTER DELETE ON tbl_invoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWCREDITINVOICE  AFTER INSERT ON tbl_creditinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITCREDITINVOICE  AFTER UPDATE ON tbl_creditinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETECREDITINVOICE  AFTER DELETE ON tbl_creditinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWPERIODICINVOICE  AFTER INSERT ON tbl_periodicinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITPERIODICINVOICE  AFTER UPDATE ON tbl_periodicinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEPERIODICINVOICE  AFTER DELETE ON tbl_periodicinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWOUTPAYMENT  AFTER INSERT ON tbl_outpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITOUTPAYMENT  AFTER UPDATE ON tbl_outpayment FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEOUTPAYMENT  AFTER DELETE ON tbl_outpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWPURCHASEORDER  AFTER INSERT ON tbl_purchaseorder FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITPURCHASEORDER  AFTER UPDATE ON tbl_purchaseorder FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEPURCHASEORDER  AFTER DELETE ON tbl_purchaseorder FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWSUPPLIERINVOICE  AFTER INSERT ON tbl_supplierinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITSUPPLIERINVOICE  AFTER UPDATE ON tbl_supplierinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETESUPPLIERINVOICE  AFTER DELETE ON tbl_supplierinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWSUPPLIERCREDITINVOICE  AFTER INSERT ON tbl_suppliercreditinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITSUPPLIERCREDITINVOICE  AFTER UPDATE ON tbl_suppliercreditinvoice FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETESUPPLIERCREDITINVOICE  AFTER DELETE ON tbl_suppliercreditinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWINVENTORY  AFTER INSERT ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITINVENTORY  AFTER UPDATE ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEINVENTORY  AFTER DELETE ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWINDELIVERY  AFTER INSERT ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITINDELIVERY  AFTER UPDATE ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEINDELIVERY  AFTER DELETE ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWOUTDELIVERY  AFTER INSERT ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITOUTDELIVERY  AFTER UPDATE ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEOUTDELIVERY  AFTER DELETE ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWVOUCHER  AFTER INSERT ON tbl_voucher FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITVOUCHER  AFTER UPDATE ON tbl_voucher FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEVOUCHER  AFTER DELETE ON tbl_voucher FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.SSServer\";CREATE TRIGGER NEWOWNREPORT  AFTER INSERT ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER EDITOWNREPORT  AFTER UPDATE ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.SSServer\";CREATE TRIGGER DELETEOWNREPORT  AFTER DELETE ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.SSServer\";");
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void createLocalTriggers() {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("CREATE TRIGGER NEWPROJECT  AFTER INSERT ON tbl_project FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITPROJECT  AFTER UPDATE ON tbl_project FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEPROJECT  AFTER DELETE ON tbl_project FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWRESULTUNIT  AFTER INSERT ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITRESULTUNIT  AFTER UPDATE ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETERESULTUNIT  AFTER DELETE ON tbl_resultunit FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWPRODUCT  AFTER INSERT ON tbl_product FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITPRODUCT  AFTER UPDATE ON tbl_product FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEPRODUCT  AFTER DELETE ON tbl_product FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWCUSTOMER  AFTER INSERT ON tbl_customer FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITCUSTOMER  AFTER UPDATE ON tbl_customer FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETECUSTOMER  AFTER DELETE ON tbl_customer FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWSUPPLIER  AFTER INSERT ON tbl_supplier FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITSUPPLIER  AFTER UPDATE ON tbl_supplier FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETESUPPLIER  AFTER DELETE ON tbl_supplier FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWVOUCHERTEMPLATE  AFTER INSERT ON tbl_vouchertemplate FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEVOUCHERTEMPLATE  AFTER DELETE ON tbl_vouchertemplate FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWAUTODIST  AFTER INSERT ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITAUTODIST  AFTER UPDATE ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEAUTODIST  AFTER DELETE ON tbl_autodist FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWINPAYMENT  AFTER INSERT ON tbl_inpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITINPAYMENT  AFTER UPDATE ON tbl_inpayment FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEINPAYMENT  AFTER DELETE ON tbl_inpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWTENDER  AFTER INSERT ON tbl_tender FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITTENDER  AFTER UPDATE ON tbl_tender FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETETENDER  AFTER DELETE ON tbl_tender FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWORDER  AFTER INSERT ON tbl_order FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITORDER  AFTER UPDATE ON tbl_order FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEORDER  AFTER DELETE ON tbl_order FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWINVOICE  AFTER INSERT ON tbl_invoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITINVOICE  AFTER UPDATE ON tbl_invoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEINVOICE  AFTER DELETE ON tbl_invoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWCREDITINVOICE  AFTER INSERT ON tbl_creditinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITCREDITINVOICE  AFTER UPDATE ON tbl_creditinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETECREDITINVOICE  AFTER DELETE ON tbl_creditinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWPERIODICINVOICE  AFTER INSERT ON tbl_periodicinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITPERIODICINVOICE  AFTER UPDATE ON tbl_periodicinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEPERIODICINVOICE  AFTER DELETE ON tbl_periodicinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWOUTPAYMENT  AFTER INSERT ON tbl_outpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITOUTPAYMENT  AFTER UPDATE ON tbl_outpayment FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEOUTPAYMENT  AFTER DELETE ON tbl_outpayment FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWPURCHASEORDER  AFTER INSERT ON tbl_purchaseorder FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITPURCHASEORDER  AFTER UPDATE ON tbl_purchaseorder FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEPURCHASEORDER  AFTER DELETE ON tbl_purchaseorder FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWSUPPLIERINVOICE  AFTER INSERT ON tbl_supplierinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITSUPPLIERINVOICE  AFTER UPDATE ON tbl_supplierinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETESUPPLIERINVOICE  AFTER DELETE ON tbl_supplierinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWSUPPLIERCREDITINVOICE  AFTER INSERT ON tbl_suppliercreditinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITSUPPLIERCREDITINVOICE  AFTER UPDATE ON tbl_suppliercreditinvoice FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETESUPPLIERCREDITINVOICE  AFTER DELETE ON tbl_suppliercreditinvoice FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWINVENTORY  AFTER INSERT ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITINVENTORY  AFTER UPDATE ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEINVENTORY  AFTER DELETE ON tbl_inventory FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWINDELIVERY  AFTER INSERT ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITINDELIVERY  AFTER UPDATE ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEINDELIVERY  AFTER DELETE ON tbl_indelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWOUTDELIVERY  AFTER INSERT ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITOUTDELIVERY  AFTER UPDATE ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEOUTDELIVERY  AFTER DELETE ON tbl_outdelivery FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWVOUCHER  AFTER INSERT ON tbl_voucher FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITVOUCHER  AFTER UPDATE ON tbl_voucher FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEVOUCHER  AFTER DELETE ON tbl_voucher FOR EACH ROW QUEUE 10000 CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER NEWOWNREPORT  AFTER INSERT ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER EDITOWNREPORT  AFTER UPDATE ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";CREATE TRIGGER DELETEOWNREPORT  AFTER DELETE ON tbl_ownreport FOR EACH ROW CALL \"se.swedsoft.bookkeeping.SSTriggerHandler\";");
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void createTriggers() {
        if (this.iLocking) {
            this.createServerTriggers();
        } else {
            this.createLocalTriggers();
        }
    }

    public void dropTriggers() {
        try {
            PreparedStatement iStatement = this.iConnection.prepareStatement("DROP TRIGGER NEWPROJECT;DROP TRIGGER EDITPROJECT;DROP TRIGGER DELETEPROJECT;DROP TRIGGER NEWRESULTUNIT;DROP TRIGGER EDITRESULTUNIT;DROP TRIGGER DELETERESULTUNIT;DROP TRIGGER NEWPRODUCT;DROP TRIGGER EDITPRODUCT;DROP TRIGGER DELETEPRODUCT;DROP TRIGGER NEWCUSTOMER;DROP TRIGGER EDITCUSTOMER;DROP TRIGGER DELETECUSTOMER;DROP TRIGGER NEWSUPPLIER;DROP TRIGGER EDITSUPPLIER;DROP TRIGGER DELETESUPPLIER;DROP TRIGGER NEWVOUCHERTEMPLATE;DROP TRIGGER DELETEVOUCHERTEMPLATE;DROP TRIGGER NEWAUTODIST;DROP TRIGGER EDITAUTODIST;DROP TRIGGER DELETEAUTODIST;DROP TRIGGER NEWINPAYMENT;DROP TRIGGER EDITINPAYMENT;DROP TRIGGER DELETEINPAYMENT;DROP TRIGGER NEWTENDER;DROP TRIGGER EDITTENDER;DROP TRIGGER DELETETENDER;DROP TRIGGER NEWORDER;DROP TRIGGER EDITORDER;DROP TRIGGER DELETEORDER;DROP TRIGGER NEWINVOICE;DROP TRIGGER EDITINVOICE;DROP TRIGGER DELETEINVOICE;DROP TRIGGER NEWCREDITINVOICE;DROP TRIGGER EDITCREDITINVOICE;DROP TRIGGER DELETECREDITINVOICE;DROP TRIGGER NEWPERIODICINVOICE;DROP TRIGGER EDITPERIODICINVOICE;DROP TRIGGER DELETEPERIODICINVOICE;DROP TRIGGER NEWOUTPAYMENT;DROP TRIGGER EDITOUTPAYMENT;DROP TRIGGER DELETEOUTPAYMENT;DROP TRIGGER NEWPURCHASEORDER;DROP TRIGGER EDITPURCHASEORDER;DROP TRIGGER DELETEPURCHASEORDER;DROP TRIGGER NEWSUPPLIERINVOICE;DROP TRIGGER EDITSUPPLIERINVOICE;DROP TRIGGER DELETESUPPLIERINVOICE;DROP TRIGGER NEWSUPPLIERCREDITINVOICE;DROP TRIGGER EDITSUPPLIERCREDITINVOICE;DROP TRIGGER DELETESUPPLIERCREDITINVOICE;DROP TRIGGER NEWINVENTORY;DROP TRIGGER EDITINVENTORY;DROP TRIGGER DELETEINVENTORY;DROP TRIGGER NEWINDELIVERY;DROP TRIGGER EDITINDELIVERY;DROP TRIGGER DELETEINDELIVERY;DROP TRIGGER NEWOUTDELIVERY;DROP TRIGGER EDITOUTDELIVERY;DROP TRIGGER DELETEOUTDELIVERY;DROP TRIGGER NEWVOUCHER;DROP TRIGGER EDITVOUCHER;DROP TRIGGER DELETEVOUCHER;DROP TRIGGER NEWOWNREPORT;DROP TRIGGER EDITOWNREPORT;DROP TRIGGER DELETEOWNREPORT;");
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void readOldDatabase() {
        final File iFile = new File(Path.get(Path.APP_BASE), "db/bookkeeper.db");
        if (!iFile.exists()) {
            return;
        }
        SSInitDialog.runProgress(SSMainFrame.getInstance(), "Konverterar databasen", new Runnable(){

            @Override
            public void run() {
                SSDBUtils.backup(iFile);
                SSSystemData iData = null;
                try {
                    iData = (SSSystemData)SSDBUtils.LoadFromFile(iFile);
                    SSDBUtils.removeBackup(iFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    SSDBUtils.restoreBackup(iFile);
                }
                if (iData == null) {
                    return;
                }
                LinkedList<SSBackupZip.ArchiveFile> iFiles = new LinkedList<SSBackupZip.ArchiveFile>();
                iFiles.add(new SSBackupZip.ArchiveFile(iFile));
                for (SSSystemCompany iSystemCompany : iData.getSystemCompanies()) {
                    File iCompanyFile = SSDB.this.getFile(iSystemCompany.getId());
                    SSDB.this.LoadCompany(iCompanyFile);
                    iFiles.add(new SSBackupZip.ArchiveFile(iCompanyFile));
                    for (SSSystemYear iSystemYear : iSystemCompany.getYears()) {
                        File iYearFile = SSDB.this.getFile(iSystemYear.getId());
                        SSDB.this.LoadYear(iYearFile);
                        iFiles.add(new SSBackupZip.ArchiveFile(iYearFile));
                        SSDB.this.setCurrentYear(null);
                    }
                    SSDB.this.setCurrentCompany(null);
                }
                if (!iData.getAccountPlans().isEmpty()) {
                    try {
                        PreparedStatement iStatement = SSDB.this.iConnection.prepareStatement("DELETE FROM tbl_accountplan");
                        iStatement.executeUpdate();
                        iStatement.close();
                        SSDB.this.iConnection.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        try {
                            SSDB.this.iConnection.rollback();
                        }
                        catch (SQLException iSystemCompany) {
                            // empty catch block
                        }
                        SSErrorDialog.showDialog(SSMainFrame.getInstance(), "SQL Error", e.getMessage());
                    }
                }
                for (SSAccountPlan iAccountPlan : iData.getAccountPlans()) {
                    SSDB.this.addAccountPlan(iAccountPlan);
                }
                try {
                    SSBackupZip.compressFiles(Path.get(Path.APP_BASE) + "/db/databas_v1.zip", iFiles);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (SSBackupZip.ArchiveFile iArchiveFile : iFiles) {
                    if (!iArchiveFile.getFile().exists()) continue;
                    iArchiveFile.getFile().delete();
                }
                if (SSDB.this.iLocking) {
                    SSDB.this.createServerTriggers();
                } else {
                    SSDB.this.createLocalTriggers();
                }
                SSFrameManager.getInstance().close();
            }
        });
    }

    private void LoadCompany(File iFile) {
        SSDBUtils.backup(iFile);
        try {
            SSCompany iCompany = (SSCompany)SSDBUtils.LoadFromFile(iFile);
            SSDBUtils.removeBackup(iFile);
            SSNewCompany iNewCompany = new SSNewCompany(iCompany);
            this.addCompany(iNewCompany);
            this.setCurrentCompany(this.getCompany(iNewCompany));
            for (SSCurrency iCurrency : iCompany.getCurrencies()) {
                if (this.getCurrencies().contains(iCurrency)) continue;
                this.addCurrency(iCurrency);
            }
            for (SSUnit iUnit : iCompany.getUnits()) {
                if (this.getUnits().contains(iUnit)) continue;
                this.addUnit(iUnit);
            }
            for (SSDeliveryWay iDeliveryWay : iCompany.getDeliveryWays()) {
                if (this.getDeliveryWays().contains(iDeliveryWay)) continue;
                this.addDeliveryWay(iDeliveryWay);
            }
            for (SSDeliveryTerm iDeliveryTerm : iCompany.getDeliveryTerms()) {
                if (this.getDeliveryTerms().contains(iDeliveryTerm)) continue;
                this.addDeliveryTerm(iDeliveryTerm);
            }
            for (SSPaymentTerm iPaymentTerm : iCompany.getPaymentTerms()) {
                if (this.getPaymentTerms().contains(iPaymentTerm)) continue;
                this.addPaymentTerm(iPaymentTerm);
            }
            for (SSProject iOldProject : iCompany.getProjects()) {
                SSNewProject iProject = new SSNewProject(iOldProject);
                this.addProject(iProject);
            }
            for (SSResultUnit iOldResultUnit : iCompany.getResultUnits()) {
                SSNewResultUnit iResultUnit = new SSNewResultUnit(iOldResultUnit);
                this.addResultUnit(iResultUnit);
            }
            for (SSProduct iProduct : iCompany.getProducts()) {
                iProduct.fixResultUnitAndProject();
                this.addProduct(iProduct);
            }
            for (SSCustomer iCustomer : iCompany.getCustomers()) {
                this.addCustomer(iCustomer);
            }
            for (SSSupplier iSupplier : iCompany.getSuppliers()) {
                this.addSupplier(iSupplier);
            }
            for (SSAutoDist iAutoDist : iCompany.getAutoDists()) {
                this.addAutoDist(iAutoDist);
            }
            for (SSVoucherTemplate iVoucherTemplate : iCompany.getVoucherTemplates()) {
                this.addVoucherTemplate(iVoucherTemplate);
            }
            for (SSInpayment iInpayment : iCompany.getInpayments()) {
                this.addInpayment(iInpayment);
            }
            for (SSTender iTender : iCompany.getTenders()) {
                this.addTender(iTender);
            }
            for (SSOrder iOrder : iCompany.getOrders()) {
                this.addOrder(iOrder);
            }
            for (SSInvoice iInvoice : iCompany.getInvoices()) {
                for (SSSaleRow sSSaleRow : iInvoice.getRows()) {
                    sSSaleRow.fixResultUnitAndProject();
                }
                this.addInvoice(iInvoice);
            }
            for (SSCreditInvoice iCreditInvoice : iCompany.getCreditInvoices()) {
                for (SSSaleRow sSSaleRow : iCreditInvoice.getRows()) {
                    sSSaleRow.fixResultUnitAndProject();
                }
                this.addCreditInvoice(iCreditInvoice);
            }
            for (SSPeriodicInvoice iPeriodicInvoice : iCompany.getPeriodicInvoices()) {
                for (SSSaleRow sSSaleRow : iPeriodicInvoice.getTemplate().getRows()) {
                    sSSaleRow.fixResultUnitAndProject();
                }
                this.addPeriodicInvoice(iPeriodicInvoice);
            }
            for (SSOutpayment iOutpayment : iCompany.getOutpayments()) {
                this.addOutpayment(iOutpayment);
            }
            for (SSPurchaseOrder iPurchaseOrder : iCompany.getPurchaseOrders()) {
                this.addPurchaseOrder(iPurchaseOrder);
            }
            for (SSSupplierInvoice iSupplierInvoice : iCompany.getSupplierInvoices()) {
                for (SSSupplierInvoiceRow sSSupplierInvoiceRow : iSupplierInvoice.getRows()) {
                    sSSupplierInvoiceRow.fixResultUnitAndProject();
                }
                this.addSupplierInvoice(iSupplierInvoice);
            }
            for (SSSupplierCreditInvoice iSupplierCreditInvoice : iCompany.getSupplierCreditinvoices()) {
                for (SSSupplierInvoiceRow sSSupplierInvoiceRow : iSupplierCreditInvoice.getRows()) {
                    sSSupplierInvoiceRow.fixResultUnitAndProject();
                }
                this.addSupplierCreditInvoice(iSupplierCreditInvoice);
            }
            for (SSIndelivery iIndelivery : iCompany.getIndeliveries()) {
                this.addIndelivery(iIndelivery);
            }
            for (SSOutdelivery iOutdelivery : iCompany.getOutdeliveries()) {
                this.addOutdelivery(iOutdelivery);
            }
            for (SSInventory iInventory : iCompany.getInventories()) {
                this.addInventory(iInventory);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            SSDBUtils.restoreBackup(iFile);
        }
    }

    private void LoadYear(File iFile) {
        SSDBUtils.backup(iFile);
        try {
            SSAccountingYear iAccountingYear = (SSAccountingYear)SSDBUtils.LoadFromFile(iFile);
            SSNewAccountingYear iNewAccountingYear = new SSNewAccountingYear(iAccountingYear);
            this.addAccountingYear(iNewAccountingYear);
            this.setCurrentYear(this.getAccountingYear(iNewAccountingYear));
            for (SSVoucher iVoucher : iAccountingYear.getVouchers()) {
                for (SSVoucherRow iRow : iVoucher.getRows()) {
                    iRow.fixResultUnitAndProject();
                }
                this.addVoucher(iVoucher, true);
            }
            SSDBUtils.removeBackup(iFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            SSDBUtils.restoreBackup(iFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            SSDBUtils.restoreBackup(iFile);
        }
    }

    public File getFile(UID pIdentifier) {
        String iFileName = pIdentifier.toString();
        iFileName = iFileName.replace(":", ".");
        iFileName = iFileName.replace("-", ".");
        return new File(Path.get(Path.APP_BASE), "db/" + iFileName + ".data");
    }

    public void createNewTables() {
        try {
            if (this.iConnection == null || this.iConnection.isClosed()) {
                return;
            }
            String q = SSUtil.readResourceToString("sql/create_tables.sql");
            PreparedStatement iStatement = this.iConnection.prepareStatement(q);
            iStatement.executeUpdate();
            this.iConnection.commit();
            iStatement.close();
            this.dropTriggers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.system.SSDB");
        sb.append("{iAutoDists=").append(this.iAutoDists);
        sb.append(", iConnection=").append(this.iConnection);
        sb.append(", iCreditInvoices=").append(this.iCreditInvoices);
        sb.append(", iCurrentCompany=").append(this.iCurrentCompany);
        sb.append(", iCurrentYear=").append(this.iCurrentYear);
        sb.append(", iCustomers=").append(this.iCustomers);
        sb.append(", iIn=").append(this.iIn);
        sb.append(", iIndeliveries=").append(this.iIndeliveries);
        sb.append(", iInpayments=").append(this.iInpayments);
        sb.append(", iInventories=").append(this.iInventories);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iListenerMap=").append(this.iListenerMap);
        sb.append(", iLocking=").append(this.iLocking);
        sb.append(", iOrders=").append(this.iOrders);
        sb.append(", iOut=").append(this.iOut);
        sb.append(", iOutdeliveries=").append(this.iOutdeliveries);
        sb.append(", iOutpayments=").append(this.iOutpayments);
        sb.append(", iOwnReports=").append(this.iOwnReports);
        sb.append(", iPeriodicInvoices=").append(this.iPeriodicInvoices);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iPurchaseOrders=").append(this.iPurchaseOrders);
        sb.append(", iSocket=").append(this.iSocket);
        sb.append(", iSupplierCreditInvoices=").append(this.iSupplierCreditInvoices);
        sb.append(", iSupplierInvoices=").append(this.iSupplierInvoices);
        sb.append(", iSuppliers=").append(this.iSuppliers);
        sb.append(", iTenders=").append(this.iTenders);
        sb.append(", iVouchers=").append(this.iVouchers);
        sb.append('}');
        return sb.toString();
    }

    static {
        iSyncObject = new Object();
    }
}

