/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.io.Serializable;
import java.rmi.server.UID;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSSystemYear;

public class SSSystemCompany
implements Serializable {
    static final long serialVersionUID = 1L;
    private UID iID;
    private String iName;
    private boolean iCurrent;
    private List<SSSystemYear> iYears;
    private transient SSNewCompany iCompany;

    public SSSystemCompany() {
        this.iID = new UID();
        this.iName = "";
        this.iCompany = null;
        this.iYears = new LinkedList<SSSystemYear>();
        this.iCurrent = false;
    }

    public SSSystemCompany(SSNewCompany pCompany) {
        this.iCompany = pCompany;
        this.iCurrent = false;
        this.iID = new UID();
        this.iName = pCompany.getName();
        this.iYears = new LinkedList<SSSystemYear>();
    }

    public UID getId() {
        return this.iID;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public boolean isCurrent() {
        return this.iCurrent;
    }

    public void setCurrent(boolean pCurrent) {
        this.iCurrent = pCurrent;
    }

    public SSNewCompany getData() {
        return this.iCompany;
    }

    public void setData(SSNewCompany iCompany) {
        if (iCompany != null) {
            this.iName = iCompany.getName();
        }
        this.iCompany = iCompany;
    }

    public List<SSSystemYear> getYears() {
        return this.iYears;
    }

    public void setYears(List<SSSystemYear> pYears) {
        this.iYears = pYears;
    }

    public SSSystemYear getCurrentYear() {
        for (SSSystemYear iYear : this.iYears) {
            if (!iYear.isCurrent()) continue;
            return iYear;
        }
        return null;
    }

    public void setCurrentyear(SSSystemYear iNew) {
        if (iNew == null) {
            return;
        }
        for (SSSystemYear iYear : this.iYears) {
            if (iYear.isCurrent()) {
                iYear.setCurrent(false);
            }
            if (!iYear.getId().equals(iNew.getId())) continue;
            iYear.setData(iNew.getData());
            iYear.setCurrent(true);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SSSystemCompany) {
            SSSystemCompany iSystemCompany = (SSSystemCompany)other;
            return this.iID.equals(iSystemCompany.iID);
        }
        if (other instanceof SSNewCompany) {
            SSNewCompany iCompany = (SSNewCompany)other;
            return this.iID.equals(iCompany.getId());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSSystemCompany (");
        sb.append(this.iID);
        sb.append("): ");
        sb.append(this.iName);
        return sb.toString();
    }
}

