/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.io.Serializable;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.util.Date;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSSystemYear
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private UID iID;
    private Date iDateFrom;
    private Date iDateTo;
    private String iAccountPlan;
    private boolean iCurrent;
    private transient SSNewAccountingYear iYear;

    public SSSystemYear() {
        this.iID = new UID();
        this.iDateFrom = new Date();
        this.iDateTo = new Date();
        this.iCurrent = false;
        this.iAccountPlan = null;
    }

    public SSSystemYear(SSNewAccountingYear pYear) {
        this.iYear = pYear;
        this.iCurrent = false;
        this.iID = new UID();
        this.iDateFrom = pYear.getFrom();
        this.iDateTo = pYear.getTo();
        this.iAccountPlan = pYear.getAccountPlan() != null ? pYear.getAccountPlan().getName() : null;
    }

    public UID getId() {
        return this.iID;
    }

    public Date getFrom() {
        return this.iDateFrom;
    }

    public void setFrom(Date iDateFrom) {
        this.iDateFrom = iDateFrom;
    }

    public Date getTo() {
        return this.iDateTo;
    }

    public void setTo(Date iDateTo) {
        this.iDateTo = iDateTo;
    }

    public String getAccountPlan() {
        return this.iAccountPlan;
    }

    public void setAccountPlan(String iAccountPlan) {
        this.iAccountPlan = iAccountPlan;
    }

    public void setAccountPlan(SSAccountPlan iAccountPlan) {
        this.iAccountPlan = iAccountPlan == null ? null : iAccountPlan.getName();
    }

    public SSNewAccountingYear getData() {
        return this.iYear;
    }

    public void setData(SSNewAccountingYear iAccountingYear) {
        this.iYear = iAccountingYear;
    }

    public void setCurrentYear(SSNewAccountingYear iAccountingYear) {
        this.iDateFrom = iAccountingYear.getFrom();
        this.iDateTo = iAccountingYear.getTo();
        this.iCurrent = true;
        this.iAccountPlan = iAccountingYear.getAccountPlan() != null ? iAccountingYear.getAccountPlan().getName() : null;
        this.iYear = iAccountingYear;
    }

    public boolean isCurrent() {
        return this.iCurrent;
    }

    public void setCurrent(boolean pCurrent) {
        this.iCurrent = pCurrent;
    }

    public boolean equals(Object other) {
        if (other instanceof SSSystemYear) {
            return this.iID.equals(((SSSystemYear)other).iID);
        }
        if (other instanceof SSNewAccountingYear) {
            return this.iID.equals(((SSNewAccountingYear)other).getId());
        }
        return false;
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append("SSSystemYear (");
        sb.append(this.iID);
        sb.append("): ");
        sb.append(iFormat.format(this.iDateFrom));
        sb.append("- ");
        sb.append(iFormat.format(this.iDateTo));
        sb.append(", ");
        sb.append(this.iAccountPlan);
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        DateFormat format = DateFormat.getDateInstance(3);
        return format.format(this.iDateFrom) + " - " + format.format(this.iDateTo);
    }
}

