/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import se.swedsoft.bookkeeping.app.Path;

public class SSConfig
implements Serializable {
    static final long serialVersionUID = 1L;
    private static SSConfig cInstance;
    private static File CONFIG_FILE;
    private Map<String, Object> iSettings = new HashMap<String, Object>();

    public static SSConfig getInstance() {
        if (cInstance == null) {
            if (CONFIG_FILE.exists()) {
                SSConfig.loadConfig();
            } else {
                SSConfig.newConfig();
            }
        }
        return cInstance;
    }

    private SSConfig() {
    }

    public synchronized Object get(String pProperty) {
        return this.iSettings.get(pProperty);
    }

    public synchronized Object get(String pProperty, Object pDefault) {
        Object iValue = this.iSettings.get(pProperty);
        return iValue != null ? iValue : pDefault;
    }

    public synchronized void set(String pProperty, Object pValue) {
        this.iSettings.put(pProperty, pValue);
        SSConfig.storeConfig();
    }

    private static synchronized void newConfig() {
        cInstance = new SSConfig();
    }

    private static synchronized void loadConfig() {
        ObjectInputStream iObjectInputStream = null;
        try {
            iObjectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(CONFIG_FILE)));
            cInstance = (SSConfig)iObjectInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (iObjectInputStream != null) {
                try {
                    iObjectInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static synchronized void storeConfig() {
        try {
            ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CONFIG_FILE)));
            iObjectOutputStream.writeObject(cInstance);
            iObjectOutputStream.flush();
            iObjectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.util.SSConfig");
        sb.append("{iSettings=").append(this.iSettings);
        sb.append('}');
        return sb.toString();
    }

    static {
        CONFIG_FILE = new File(Path.get(Path.USER_CONF), "bookkeeping.config");
    }
}

