/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.util;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import se.swedsoft.bookkeeping.data.util.SSMailServerException;
import se.swedsoft.bookkeeping.util.SSUtil;

public class SSMailServer
implements Serializable {
    private final String name;
    private final String username;
    private final String password;
    private final URI address;
    private final boolean isAuth;
    static final long serialVersionUID = 1L;

    public static SSMailServer makeIfValid(String name, String host, int port, boolean isAuth, String username, String password) throws SSMailServerException {
        if (!SSUtil.isInRage(port, 1, 65563)) {
            SSMailServer.onError("mailserver.port_error");
        }
        URI tempAddress = null;
        try {
            tempAddress = new URI(null, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            SSMailServer.onError("mailserver.format_error");
        }
        if (!SSMailServer.isValidAddress(tempAddress)) {
            SSMailServer.onError("mailserver.parts_error");
        }
        return new SSMailServer(name, tempAddress, isAuth, username, password);
    }

    public SSMailServer(String name, URI address, boolean isAuth, String username, String password) {
        SSUtil.verifyNotNull("argument to SSMailServer constructor", name, address);
        if (isAuth) {
            SSUtil.verifyNotNull("argument to SSMailServer constructor", username, password);
        }
        this.name = name;
        this.isAuth = isAuth;
        this.username = username;
        this.password = password;
        this.address = address;
    }

    public static void onError(String msg) throws SSMailServerException {
        throw new SSMailServerException("Error when creating SSMailServer", msg);
    }

    public static boolean isValidAddress(URI a) {
        return a.getHost() != null && !a.isAbsolute() && SSMailServer.isNullOrEmpty(a.getPath()) && SSMailServer.isNullOrEmpty(a.getQuery()) && SSMailServer.isNullOrEmpty(a.getFragment());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static void verifyNotNull(Object o, String msg) {
        if (o == null) {
            throw new NullPointerException(msg + " must not be null");
        }
    }

    private String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuth() {
        return this.isAuth;
    }

    public URI getURI() {
        return this.address;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.util.SSMailServer");
        sb.append("{address=").append(this.address);
        sb.append(", isAuth=").append(this.isAuth);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

