/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SymetricCrypter {
    private SecretKeySpec key;
    private Cipher cipher;

    public SymetricCrypter(byte[] keyBytes) {
        this.key = new SecretKeySpec(keyBytes, "DES");
        try {
            this.cipher = Cipher.getInstance("DES/ECB/PKCS5PADDING");
        }
        catch (NoSuchAlgorithmException e) {
            SymetricCrypter.onError(e);
        }
        catch (NoSuchPaddingException e) {
            SymetricCrypter.onError(e);
        }
    }

    private static void onError(Throwable cause) {
        throw new CrypterException("An error occured in Crypter class", cause);
    }

    public byte[] encrypt(byte[] clearText) {
        return this.runAlgorithm(1, clearText);
    }

    public String encrypt(String clearText) {
        return new String(Base64.encodeBase64(this.encrypt(clearText.getBytes())));
    }

    public String decrypt(String cipherText) {
        return new String(this.decrypt(Base64.decodeBase64(cipherText.getBytes())));
    }

    public byte[] decrypt(byte[] cipherText) {
        return this.runAlgorithm(2, cipherText);
    }

    public byte[] runAlgorithm(int mode, byte[] data) {
        try {
            this.cipher.init(mode, this.key);
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            SymetricCrypter.onError(e);
        }
        catch (BadPaddingException e) {
            SymetricCrypter.onError(e);
        }
        catch (InvalidKeyException e) {
            SymetricCrypter.onError(e);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.util.SymetricCrypter");
        sb.append("{cipher=").append(this.cipher);
        sb.append(", key=").append(this.key);
        sb.append('}');
        return sb.toString();
    }

    public static class CrypterException
    extends RuntimeException {
        public CrypterException(String message) {
            super(message);
        }

        public CrypterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

