/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import se.swedsoft.bookkeeping.data.util.SSConfig;
import se.swedsoft.bookkeeping.gui.SSMainMenu;
import se.swedsoft.bookkeeping.gui.company.SSCompanyFrame;
import se.swedsoft.bookkeeping.gui.status.SSMainStatusBar;
import se.swedsoft.bookkeeping.gui.status.SSStatusBar;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSImage;

public class SSMainFrame
extends JFrame {
    private static SSMainFrame cInstance;
    private static ResourceBundle bundle;
    private JDesktopPane iDesktop;
    private JPanel iStatusBar;

    public static SSMainFrame getInstance() {
        if (cInstance == null) {
            cInstance = new SSMainFrame();
        }
        return cInstance;
    }

    private SSMainFrame() {
        super("Fribok");
        this.setDefaultCloseOperation(3);
        Dimension iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Integer iExtendedsState = (Integer)SSConfig.getInstance().get("mainframe.extendedstate", 0);
        Integer iWidth = (Integer)SSConfig.getInstance().get("mainframe.width", 1024);
        Integer iHeight = (Integer)SSConfig.getInstance().get("mainframe.height", 750);
        int x = Math.max((int)(iScreenSize.getWidth() - (double)iWidth.intValue()) / 2, 0);
        int y = Math.max((int)(iScreenSize.getHeight() - (double)iHeight.intValue()) / 2, 0);
        int w = Math.min(iWidth, (int)iScreenSize.getWidth());
        int h = Math.min(iHeight, (int)iScreenSize.getHeight());
        this.setBounds(x, y, w, h);
        this.setExtendedState(iExtendedsState);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SSMainFrame.this.saveSizeAndLocation();
            }
        });
        SSMainMenu iMainMenu = new SSMainMenu(this);
        this.setIconImage(SSImage.getImage("ICON_LOGO"));
        this.setJMenuBar(iMainMenu.getMenuBar());
        this.getContentPane().setLayout(new BorderLayout());
        this.iDesktop = new JDesktopPane();
        this.iStatusBar = this.getStatusBar();
        this.add((Component)this.iDesktop, "Center");
        this.add((Component)this.iStatusBar, "South");
    }

    private JPanel getStatusBar() {
        SSMainStatusBar iPanels = new SSMainStatusBar();
        SSStatusBar iStatusBar = new SSStatusBar();
        iStatusBar.addPanel(iPanels.getNameLabel());
        iStatusBar.addSpacer();
        iStatusBar.addPanel(iPanels.getMemLabel());
        iStatusBar.addPanel(iPanels.getReadonlyLabel());
        iStatusBar.addSeparator();
        iStatusBar.addPanel(iPanels.getCompanyLabel());
        iStatusBar.addSeparator();
        iStatusBar.addPanel(iPanels.getYearLabel());
        return iStatusBar;
    }

    public void saveSizeAndLocation() {
        Integer iExtendedsState = this.getExtendedState();
        Integer iWidth = this.getWidth();
        Integer iHeight = this.getHeight();
        SSConfig.getInstance().set("mainframe.extendedstate", iExtendedsState);
        SSConfig.getInstance().set("mainframe.width", iWidth);
        SSConfig.getInstance().set("mainframe.height", iHeight);
    }

    public void showCompanyFrame() {
        SSCompanyFrame.showFrame(this, 500, 300);
        try {
            SSCompanyFrame.getInstance().setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public JDesktopPane getDesktopPane() {
        return this.iDesktop;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.SSMainFrame");
        sb.append("{iDesktop=").append(this.iDesktop);
        sb.append(", iStatusBar=").append(this.iStatusBar);
        sb.append('}');
        return sb.toString();
    }

    static {
        bundle = SSBundle.getBundle();
    }
}

