/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInventoryRow;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.backup.SSBackupDatabase;
import se.swedsoft.bookkeeping.data.system.SSCompanyLock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.about.dialog.SSAboutDialog;
import se.swedsoft.bookkeeping.gui.accountingyear.SSAccountingYearFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.SSStartingAmountFrame;
import se.swedsoft.bookkeeping.gui.accountplans.SSAccountPlanDialog;
import se.swedsoft.bookkeeping.gui.accountplans.SSAccountPlanFrame;
import se.swedsoft.bookkeeping.gui.autodist.SSAutoDistFrame;
import se.swedsoft.bookkeeping.gui.backup.SSBackupDialog;
import se.swedsoft.bookkeeping.gui.backup.SSBackupFrame;
import se.swedsoft.bookkeeping.gui.budget.SSBudgetFrame;
import se.swedsoft.bookkeeping.gui.company.SSCompanyDialog;
import se.swedsoft.bookkeeping.gui.company.SSCompanyFrame;
import se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.customer.SSCustomerFrame;
import se.swedsoft.bookkeeping.gui.help.SSHelpFrame;
import se.swedsoft.bookkeeping.gui.indelivery.SSIndeliveryFrame;
import se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentFrame;
import se.swedsoft.bookkeeping.gui.inventory.SSInventoryFrame;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceFrame;
import se.swedsoft.bookkeeping.gui.order.SSOrderFrame;
import se.swedsoft.bookkeeping.gui.outdelivery.SSOutdeliveryFrame;
import se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentFrame;
import se.swedsoft.bookkeeping.gui.ownreport.SSOwnReportFrame;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceFrame;
import se.swedsoft.bookkeeping.gui.product.SSProductFrame;
import se.swedsoft.bookkeeping.gui.project.SSProjectFrame;
import se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderFrame;
import se.swedsoft.bookkeeping.gui.purchasesuggestion.dialog.SSPurchaseSuggestionDialog;
import se.swedsoft.bookkeeping.gui.resultunit.SSResultUnitFrame;
import se.swedsoft.bookkeeping.gui.sie.dialog.SSExportSIEDialog;
import se.swedsoft.bookkeeping.gui.supplier.SSSupplierFrame;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceFrame;
import se.swedsoft.bookkeeping.gui.tender.SSTenderFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSClearTransactionsDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSConfirmDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInputDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSBackupFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSSIEFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterALL;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterBGMAX;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterTXT;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.frame.SSInternalFrame;
import se.swedsoft.bookkeeping.gui.util.menu.SSMenuLoader;
import se.swedsoft.bookkeeping.gui.voucher.SSVoucherFrame;
import se.swedsoft.bookkeeping.gui.vouchertemplate.SSVoucherTemplateFrame;
import se.swedsoft.bookkeeping.importexport.bgmax.SSBgMaxImporter;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxFile;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEType;
import se.swedsoft.bookkeeping.importexport.supplierpayments.SSSupplierPaymentImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.SSReportFactory;
import se.swedsoft.bookkeeping.print.dialog.SSInventoryBasisDialog;
import se.swedsoft.bookkeeping.print.report.SSAccountPlanPrinter;
import se.swedsoft.bookkeeping.print.report.SSInventoryBasisPrinter;
import se.swedsoft.bookkeeping.print.report.SSStartingAmountPrinter;
import se.swedsoft.bookkeeping.util.BrowserLaunch;

public class SSMainMenu {
    private static final String MENU_RES = "/MainMenu.xml";
    private static final ResourceBundle bundle = SSBundle.getBundle();
    private SSMainFrame iMainFrame;
    private SSMenuLoader iMenuLoader;
    private List<JMenuItem> iWindowItems;

    public SSMainMenu(SSMainFrame pMainFrame) {
        this.iMainFrame = pMainFrame;
        this.iMenuLoader = new SSMenuLoader();
        InputStream stream = this.getClass().getResourceAsStream(MENU_RES);
        this.iMenuLoader.loadMenus(stream);
        this.iMenuLoader.setEnabled("Company", false);
        this.iMenuLoader.setEnabled("Year", false);
        this.loadActions();
        SSDB.getInstance().addPropertyChangeListener("YEAR", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSMainMenu.this.iMenuLoader.setEnabled("Year", evt.getNewValue() != null);
            }
        });
        SSDB.getInstance().addPropertyChangeListener("COMPANY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    SSMainMenu.this.iMenuLoader.setEnabled("Company", false);
                    SSMainMenu.this.iMenuLoader.setEnabled("Year", false);
                } else {
                    SSMainMenu.this.iMenuLoader.setEnabled("Company", true);
                }
            }
        });
    }

    public JMenuBar getMenuBar() {
        return this.iMenuLoader.getMenuBar("MainMenu");
    }

    private void loadActions() {
        this.loadFileActions();
        this.loadRegisterActions();
        this.loadInvoiceActions();
        this.bgcmenuActions();
        this.addStockActions();
        this.loadBookkeepingActions();
        this.loadPrintBookkeepingActions();
        this.loadHelpActions();
        this.loadWindowActions();
    }

    private void loadFileActions() {
        this.iMenuLoader.addActionListener("filemenu.companies", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.showFrame(SSMainMenu.this.iMainFrame, 500, 300);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.company.settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyDialog.editCurrentDialog(SSMainMenu.this.iMainFrame, SSDB.getInstance().getCurrentCompany(), null);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.accountplans", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlanFrame.showFrame(SSMainMenu.this.iMainFrame, 640, 480);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.import.sie", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                SSPostLock.applyLock("sieimport" + iCurrentCompany.getId());
                SSCompanyLock.removeLock(iCurrentCompany);
                if (SSCompanyLock.isLocked(iCurrentCompany)) {
                    SSCompanyLock.applyLock(iCurrentCompany);
                    SSPostLock.removeLock("sieimport" + iCurrentCompany.getId());
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "companyframe.siecompanyopen");
                    return;
                }
                SSCompanyLock.applyLock(iCurrentCompany);
                SSSIEFileChooser iFileChooser = SSSIEFileChooser.getInstance();
                int iResponce = iFileChooser.showOpenDialog(SSMainMenu.this.iMainFrame);
                boolean iShowDialog = false;
                if (iResponce == 0) {
                    iShowDialog = true;
                    SSSIEImporter iImporter = new SSSIEImporter(iFileChooser.getSelectedFile());
                    try {
                        iImporter.doImport();
                    }
                    catch (SSImportException ex) {
                        SSPostLock.removeLock("sieimport" + iCurrentCompany.getId());
                        iShowDialog = false;
                        new SSErrorDialog(SSMainMenu.this.iMainFrame, "importexceptiondialog", ex.getMessage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        iShowDialog = false;
                        SSPostLock.removeLock("sieimport" + iCurrentCompany.getId());
                    }
                }
                SSPostLock.removeLock("sieimport" + iCurrentCompany.getId());
                if (iShowDialog) {
                    new SSInformationDialog(SSMainMenu.this.iMainFrame, "sieimport.importdone");
                }
            }
        });
        this.iMenuLoader.addActionListener("filemenu.import.vouchers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "voucheriscreated");
                    return;
                }
                SSSIEFileChooser iFileChooser = SSSIEFileChooser.getInstance();
                if (iFileChooser.showOpenDialog(SSMainMenu.this.iMainFrame) == 0) {
                    SSSIEImporter iImporter = new SSSIEImporter(iFileChooser.getSelectedFile());
                    try {
                        iImporter.doImportVouchers();
                    }
                    catch (SSImportException ex) {
                        SSPostLock.removeLock(lockString);
                        new SSErrorDialog(SSMainMenu.this.iMainFrame, "importexceptiondialog", ex.getMessage());
                    }
                    if (SSVoucherFrame.getInstance() != null) {
                        SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                    }
                    SSPostLock.removeLock(lockString);
                } else {
                    SSPostLock.removeLock(lockString);
                }
            }
        });
        this.iMenuLoader.addActionListener("filemenu.export.sie", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExportSIEDialog.showDialog(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.export.vouchers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSIEFileChooser iFileChooser = SSSIEFileChooser.getInstance();
                iFileChooser.setDefaultFileName();
                if (iFileChooser.showSaveDialog(SSMainMenu.this.iMainFrame) == 0) {
                    try {
                        SSSIEExporter iExporter = new SSSIEExporter(SIEType.SIE_4I, "Format SIE 4I");
                        iExporter.exportSIE(iFileChooser.getSelectedFile());
                    }
                    catch (SSExportException ex) {
                        new SSErrorDialog(SSMainMenu.this.iMainFrame, "exportexceptiondialog", ex.getMessage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.iMenuLoader.addActionListener("filemenu.backup.all", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMainMenu.this.createBackupDialog();
            }
        });
        this.iMenuLoader.addActionListener("filemenu.backup.restore", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSDB.getInstance().getLocking()) {
                    new SSInformationDialog(SSMainMenu.this.iMainFrame, "backupframe.runningonserver");
                    return;
                }
                SSBackupFrame.showFrame(SSMainMenu.this.iMainFrame, 600, 400);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.network.settings.db", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String iIpAddress = SSInputDialog.showDialog();
                if (iIpAddress == null) {
                    return;
                }
                try {
                    if (iIpAddress.length() == 0) {
                        throw new IOException("Could not connect to server on address null");
                    }
                    SSDB.getInstance().openSocket(iIpAddress);
                }
                catch (IOException ex) {
                    SSQueryDialog iDialog = new SSQueryDialog(SSMainFrame.getInstance(), "noserverfound");
                    if (SSDBConfig.getClientkey() != null && SSDBConfig.getClientkey().length() != 0) {
                        SSDB.getInstance().removeClient();
                    }
                    if (iDialog.getResponce() == 0) {
                        if (SSDB.getInstance().getLocking()) {
                            SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
                            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
                        }
                        SSDB.getInstance().setLocking(true);
                        SSDBConfig.setServerAddress(null);
                        SSDB.getInstance().setCurrentCompany(null);
                        SSDB.getInstance().setCurrentYear(null);
                        SSFrameManager.getInstance().close();
                        SSDB.getInstance().loadLocalDatabase();
                        SSCompanyFrame.showFrame(SSMainMenu.this.iMainFrame, 500, 300);
                    }
                    return;
                }
                if (SSDB.getInstance().getLocking()) {
                    SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
                    SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
                }
                SSDBConfig.setServerAddress(iIpAddress);
                SSDB.getInstance().setCurrentCompany(null);
                SSDB.getInstance().setCurrentYear(null);
                SSFrameManager.getInstance().close();
                SSDB.getInstance().loadSelectedDatabase(iIpAddress);
                SSCompanyFrame.showFrame(SSMainMenu.this.iMainFrame, 500, 300);
            }
        });
        this.iMenuLoader.addActionListener("filemenu.exit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMainMenu.this.iMainFrame.saveSizeAndLocation();
                System.exit(0);
            }
        });
    }

    private void loadRegisterActions() {
        this.iMenuLoader.addActionListener("registermenu.accountingyear", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.showFrame(SSMainMenu.this.iMainFrame, 500, 300);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.accountplan", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSAccountPlan iAccountPlan = yearData.getAccountPlan();
                SSAccountPlanDialog.editCurrentDialog(SSMainMenu.this.iMainFrame, iAccountPlan, null);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.project", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProjectFrame.showFrame(SSMainMenu.this.iMainFrame, 400, 300);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.resultunit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSResultUnitFrame.showFrame(SSMainMenu.this.iMainFrame, 400, 300);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.product", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductFrame.showFrame(SSMainMenu.this.iMainFrame, 640, 480);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.customer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomerFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.supplier", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.vouchertemplates", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherTemplateFrame.showFrame(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("registermenu.autodist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAutoDistFrame.showFrame(SSMainMenu.this.iMainFrame, 488, 360);
            }
        });
    }

    private void loadInvoiceActions() {
        this.iMenuLoader.addActionListener("salemenu.inpayment", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInpaymentFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.outpayment", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutpaymentFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.creditinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoiceFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.periodicinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoiceFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.tender", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTenderFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.order", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrderFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.invoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoiceFrame.showFrame(SSMainMenu.this.iMainFrame, 880, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.purchaseorder", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrderFrame.showFrame(SSMainMenu.this.iMainFrame, 880, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.supplierinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoiceFrame.showFrame(SSMainMenu.this.iMainFrame, 880, 600);
            }
        });
        this.iMenuLoader.addActionListener("salemenu.suppliercreditinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoiceFrame.showFrame(SSMainMenu.this.iMainFrame, 880, 600);
            }
        });
    }

    private void bgcmenuActions() {
        this.iMenuLoader.addActionListener("bgcmenu.bgmax", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgMaxFile iBgMaxFile;
                SSFileChooser iFileChooser = new SSFileChooser();
                SSFilterBGMAX iFilter = new SSFilterBGMAX();
                iFileChooser.addChoosableFileFilter(iFilter);
                iFileChooser.addChoosableFileFilter(new SSFilterTXT());
                iFileChooser.addChoosableFileFilter(new SSFilterALL());
                iFileChooser.setFileFilter(iFilter);
                if (iFileChooser.showOpenDialog(SSMainMenu.this.iMainFrame) != 0) {
                    return;
                }
                try {
                    iBgMaxFile = SSBgMaxImporter.Import(iFileChooser.getSelectedFile());
                }
                catch (SSImportException ex) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "importexceptiondialog", ex.getMessage());
                    return;
                }
                if (iBgMaxFile == null) {
                    return;
                }
                List<SSInpayment> iInpayments = SSBgMaxImporter.getInpayments(SSMainMenu.this.iMainFrame, iBgMaxFile);
                if (iInpayments == null) {
                    return;
                }
                StringBuilder iNumbers = new StringBuilder();
                for (SSInpayment iInpayment : iInpayments) {
                    SSDB.getInstance().addInpayment(iInpayment);
                    if (iNumbers.length() > 0) {
                        iNumbers.append(", ");
                    }
                    iNumbers.append(iInpayment.getNumber());
                }
                SSInformationDialog.showDialog(SSMainMenu.this.iMainFrame, "bgmaximport.success", iNumbers.toString());
            }
        });
        this.iMenuLoader.addActionListener("bgcmenu.lbin", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SSOutpayment> iOutpayments;
                SSFileChooser iFileChooser = new SSFileChooser();
                SSFilterBGMAX iFilter = new SSFilterBGMAX();
                iFileChooser.addChoosableFileFilter(iFilter);
                iFileChooser.addChoosableFileFilter(new SSFilterTXT());
                iFileChooser.addChoosableFileFilter(new SSFilterALL());
                iFileChooser.setFileFilter(iFilter);
                if (iFileChooser.showOpenDialog(SSMainMenu.this.iMainFrame) != 0) {
                    return;
                }
                try {
                    iOutpayments = SSSupplierPaymentImporter.Import(iFileChooser.getSelectedFile());
                }
                catch (SSImportException ex) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "importexceptiondialog", ex.getMessage());
                    return;
                }
                StringBuilder iNumbers = new StringBuilder();
                for (SSOutpayment iOutpayment : iOutpayments) {
                    SSDB.getInstance().addOutpayment(iOutpayment);
                    if (iNumbers.length() > 0) {
                        iNumbers.append(", ");
                    }
                    iNumbers.append(iOutpayment.getNumber());
                }
                new SSInformationDialog(SSMainMenu.this.iMainFrame, "supplierpaymentimport.importcomplete", iNumbers.toString());
            }
        });
    }

    private void addStockActions() {
        this.iMenuLoader.addActionListener("stockmenu.indelivery", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSIndeliveryFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.outdelivery", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdeliveryFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.purchasesuggestion", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseSuggestionDialog.showDialog(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.inventory", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInventoryFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.inventorybasisreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInventoryBasisDialog iDialog = new SSInventoryBasisDialog(SSMainMenu.this.iMainFrame);
                iDialog.setLocationRelativeTo(SSMainMenu.this.iMainFrame);
                if (iDialog.showDialog() != 0) {
                    return;
                }
                final Date iDate = iDialog.getDate();
                final boolean iDateSelected = iDialog.isDateSelected();
                SSProgressDialog.runProgress(SSMainMenu.this.iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSInventoryBasisPrinter iPrinter = iDateSelected ? new SSInventoryBasisPrinter(iDate) : new SSInventoryBasisPrinter();
                        iPrinter.preview(SSMainMenu.this.iMainFrame);
                    }
                });
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.stockaccountreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.StockAccount(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("stockmenu.stockvaluereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.StockValue(SSMainMenu.this.iMainFrame);
            }
        });
    }

    private void loadBookkeepingActions() {
        this.iMenuLoader.addActionListener("bookkeepingmenu.startingamount", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "startingamount" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "startingamountopen");
                    return;
                }
                SSStartingAmountFrame.showFrame(SSMainMenu.this.iMainFrame, 500, 400);
            }
        });
        this.iMenuLoader.addActionListener("bookkeepingmenu.vouchers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("bookkeepingmenu.budget", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "budget" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "budgetopen");
                    return;
                }
                SSBudgetFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
    }

    private void loadPrintBookkeepingActions() {
        this.iMenuLoader.addActionListener("reportmenu.vouchers", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.buildVoucherReport(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.startingamounts", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
                if (iAccountingYear == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSProgressDialog.runProgress(SSMainMenu.this.iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSStartingAmountPrinter iPrinter = new SSStartingAmountPrinter(iAccountingYear);
                        iPrinter.preview(SSMainMenu.this.iMainFrame);
                    }
                });
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.accountplan", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSProgressDialog.runProgress(SSMainMenu.this.iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSAccountPlanPrinter iPrinter = new SSAccountPlanPrinter();
                        iPrinter.preview(SSMainMenu.this.iMainFrame);
                    }
                });
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.mainbook", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.MainbookReport(SSMainMenu.this.iMainFrame, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.resultreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSNewAccountingYear previousYearData = SSDB.getInstance().getPreviousYear();
                SSReportFactory.buildResultReport(SSMainMenu.this.iMainFrame, bundle, yearData, previousYearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.projectresult", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
                if (iAccountingYear == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.ProjectResultReport(SSMainMenu.this.iMainFrame, bundle, iAccountingYear);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.resultunitresult", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
                if (iAccountingYear == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.ResultUnitResultReport(SSMainMenu.this.iMainFrame, bundle, iAccountingYear);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.budget", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.buildBudgetReport(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.balancereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.buildBalanceReport(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.vatreport2007", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSMainMenu.this.iMainFrame, "voucheriscreated");
                    return;
                }
                SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
                if (iAccountingYear == null) {
                    SSPostLock.removeLock(lockString);
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.VATReport2007(SSMainMenu.this.iMainFrame, bundle, iAccountingYear);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.accountdiagram", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.buildAccountDiagramReport(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.simplestatement", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSReportFactory.SimplestatementReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.ownreports", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                if (yearData == null) {
                    SSNewAccountingYear.openWarningDialogNoYearData(SSMainMenu.this.iMainFrame);
                    return;
                }
                SSOwnReportFrame.showFrame(SSMainMenu.this.iMainFrame, 800, 600);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.orderlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.OrderListReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.accountsrecievable", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.AccountsRecievableReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.customerclaim", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.CustomerClaimReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.quarterreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.QuarterReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.invoicejornal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.InvoiceJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.creditinvoicejornal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.CreditInvoiceJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.inpaymentjournal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.InpaymentJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.supplierinvoicejornal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SupplierInvoiceJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.suppliercreditinvoicejornal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SupplierCreditInvoiceJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("journalmenu.outpaymentjournal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.OutpaymentJournal(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.accountspayable", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.AccountsPayableReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.supplierdept", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SupplierDebtReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.salereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SaleReport(SSMainMenu.this.iMainFrame);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.salevalues", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                SSReportFactory.Salevalues(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
        this.iMenuLoader.addActionListener("reportmenu.purchasevalues", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear yearData = SSDB.getInstance().getCurrentYear();
                SSReportFactory.Purchasevalues(SSMainMenu.this.iMainFrame, bundle, yearData);
            }
        });
    }

    private void loadHelpActions() {
        this.iMenuLoader.addActionListener("helpmenu.help", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHelpFrame.showFrame(SSMainMenu.this.iMainFrame, 980, 720);
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.support", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = SSBundle.getBundle().getString("application.url.support");
                BrowserLaunch.openURL(url);
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.updates", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = SSBundle.getBundle().getString("application.url.updates");
                BrowserLaunch.openURL(url);
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.clearlocks", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSConfirmDialog iDialog = new SSConfirmDialog("helpmenu.clearlocks.warning");
                if (iDialog.openDialog(SSMainMenu.this.iMainFrame) == 0) {
                    SSPostLock.clearLocks();
                }
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.compress", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSConfirmDialog iDialog = new SSConfirmDialog("helpmenu.compress.warning");
                if (iDialog.openDialog(SSMainMenu.this.iMainFrame) == 0) {
                    SSDB.getInstance().shutdownCompact();
                    System.exit(0);
                }
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.cleartransactions", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSClearTransactionsDialog iDialog = new SSClearTransactionsDialog(SSMainMenu.this.iMainFrame);
                iDialog.setLocationRelativeTo(SSMainMenu.this.iMainFrame);
                if (iDialog.showDialog() != 0) {
                    return;
                }
                final Date iDate = SSDateMath.ceil(iDialog.getDate());
                SSConfirmDialog iConfirmDialog = !SSDB.getInstance().getLocking() ? new SSConfirmDialog("helpmenu.cleartransactions.warning", new SimpleDateFormat("yyyy-MM-dd").format(iDate)) : new SSConfirmDialog("helpmenu.cleartransactions.was", new SimpleDateFormat("yyyy-MM-dd").format(iDate));
                if (iConfirmDialog.openDialog(SSMainMenu.this.iMainFrame) != 0) {
                    return;
                }
                if (!SSDB.getInstance().getLocking()) {
                    if (!SSMainMenu.this.createBackupDialog()) {
                        return;
                    }
                } else {
                    SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                    SSCompanyLock.removeLock(iCurrentCompany);
                    if (SSCompanyLock.isLocked(iCurrentCompany)) {
                        SSCompanyLock.applyLock(iCurrentCompany);
                        new SSErrorDialog(SSMainMenu.this.iMainFrame, "companyframe.companyopen");
                        return;
                    }
                    SSCompanyLock.applyLock(iCurrentCompany);
                }
                SSFrameManager.getInstance().close();
                SSDB.getInstance().dropTriggers();
                SSInitDialog.runProgress(SSMainFrame.getInstance(), "Rensar transaktioner...", new Runnable(){

                    @Override
                    public void run() {
                        BigDecimal iSaldo;
                        SSStock iStock = new SSStock(true);
                        HashMap<String, Integer> iStockStatusStart = new HashMap<String, Integer>();
                        for (SSProduct sSProduct : SSDB.getInstance().getProducts()) {
                            if (!sSProduct.isStockProduct()) continue;
                            iStockStatusStart.put(sSProduct.getNumber(), iStock.getQuantity(sSProduct));
                        }
                        Map<Integer, BigDecimal> iSaldoMap = SSInvoiceMath.getSaldos(iDate);
                        for (SSInpayment sSInpayment : SSDB.getInstance().getInpayments()) {
                            if (!sSInpayment.getDate().before(iDate)) continue;
                            LinkedList<SSInpaymentRow> iSavedRows = new LinkedList<SSInpaymentRow>();
                            for (SSInpaymentRow sSInpaymentRow : sSInpayment.getRows()) {
                                BigDecimal iSaldo3;
                                if (sSInpaymentRow.getInvoiceNr() == null || !iSaldoMap.containsKey(sSInpaymentRow.getInvoiceNr()) || (iSaldo3 = iSaldoMap.get(sSInpaymentRow.getInvoiceNr())).signum() == 0) continue;
                                iSavedRows.add(sSInpaymentRow);
                            }
                            sSInpayment.setRows(iSavedRows);
                            if (sSInpayment.getRows().isEmpty()) {
                                SSDB.getInstance().deleteInpayment(sSInpayment);
                                continue;
                            }
                            SSDB.getInstance().updateInpayment(sSInpayment);
                        }
                        for (SSTender sSTender : SSDB.getInstance().getTenders()) {
                            if (!sSTender.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteTender(sSTender);
                        }
                        for (SSOrder sSOrder : SSDB.getInstance().getOrders()) {
                            if (!sSOrder.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteOrder(sSOrder);
                        }
                        for (SSInvoice sSInvoice : SSDB.getInstance().getInvoices()) {
                            if (sSInvoice.getDate().before(iDate) && iSaldoMap.containsKey(sSInvoice.getNumber())) {
                                BigDecimal iSaldo2 = iSaldoMap.get(sSInvoice.getNumber());
                                if (iSaldo2.signum() != 0) continue;
                                SSDB.getInstance().deleteInvoice(sSInvoice);
                                continue;
                            }
                            if (!sSInvoice.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteInvoice(sSInvoice);
                        }
                        for (SSCreditInvoice sSCreditInvoice : SSDB.getInstance().getCreditInvoices()) {
                            if (sSCreditInvoice.getDate().before(iDate) && iSaldoMap.containsKey(sSCreditInvoice.getCreditingNr())) {
                                BigDecimal iSaldo2 = iSaldoMap.get(sSCreditInvoice.getCreditingNr());
                                if (iSaldo2.signum() != 0) continue;
                                SSDB.getInstance().deleteCreditInvoice(sSCreditInvoice);
                                continue;
                            }
                            if (!sSCreditInvoice.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteCreditInvoice(sSCreditInvoice);
                        }
                        for (SSPeriodicInvoice sSPeriodicInvoice : SSDB.getInstance().getPeriodicInvoices()) {
                            if (!sSPeriodicInvoice.getDate().before(iDate) || sSPeriodicInvoice.getNextDate() != null) continue;
                            SSDB.getInstance().deletePeriodicInvoice(sSPeriodicInvoice);
                        }
                        Map<Integer, BigDecimal> map = SSSupplierInvoiceMath.getSaldos(iDate);
                        for (SSOutpayment iOutpayment : SSDB.getInstance().getOutpayments()) {
                            if (!iOutpayment.getDate().before(iDate)) continue;
                            LinkedList<SSOutpaymentRow> iSavedRows = new LinkedList<SSOutpaymentRow>();
                            for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                                BigDecimal iSaldo4;
                                if (iRow.getInvoiceNr() == null || !map.containsKey(iRow.getInvoiceNr()) || (iSaldo4 = map.get(iRow.getInvoiceNr())).signum() == 0) continue;
                                iSavedRows.add(iRow);
                            }
                            iOutpayment.setRows(iSavedRows);
                            if (iOutpayment.getRows().isEmpty()) {
                                SSDB.getInstance().deleteOutpayment(iOutpayment);
                                continue;
                            }
                            SSDB.getInstance().updateOutpayment(iOutpayment);
                        }
                        for (SSPurchaseOrder iPurchaseOrder : SSDB.getInstance().getPurchaseOrders()) {
                            if (!iPurchaseOrder.getDate().before(iDate)) continue;
                            SSDB.getInstance().deletePurchaseOrder(iPurchaseOrder);
                        }
                        for (SSSupplierInvoice iSupplierInvoice : SSDB.getInstance().getSupplierInvoices()) {
                            if (iSupplierInvoice.getDate().before(iDate) && map.containsKey(iSupplierInvoice.getNumber())) {
                                iSaldo = map.get(iSupplierInvoice.getNumber());
                                if (iSaldo.signum() != 0) continue;
                                SSDB.getInstance().deleteSupplierInvoice(iSupplierInvoice);
                                continue;
                            }
                            if (!iSupplierInvoice.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteSupplierInvoice(iSupplierInvoice);
                        }
                        for (SSSupplierCreditInvoice iSupplierCreditInvoice : SSDB.getInstance().getSupplierCreditInvoices()) {
                            if (iSupplierCreditInvoice.getDate().before(iDate) && iSaldoMap.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                                iSaldo = iSaldoMap.get(iSupplierCreditInvoice.getCreditingNr());
                                if (iSaldo.signum() != 0) continue;
                                SSDB.getInstance().deleteSupplierCreditInvoice(iSupplierCreditInvoice);
                                continue;
                            }
                            if (!iSupplierCreditInvoice.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteSupplierCreditInvoice(iSupplierCreditInvoice);
                        }
                        for (SSIndelivery iIndelivery : SSDB.getInstance().getIndeliveries()) {
                            if (!iIndelivery.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteIndelivery(iIndelivery);
                        }
                        for (SSOutdelivery iOutdelivery : SSDB.getInstance().getOutdeliveries()) {
                            if (!iOutdelivery.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteOutdelivery(iOutdelivery);
                        }
                        for (SSInventory iInventory : SSDB.getInstance().getInventories()) {
                            if (!iInventory.getDate().before(iDate)) continue;
                            SSDB.getInstance().deleteInventory(iInventory);
                        }
                        SSDB.getInstance().clearLists();
                        SSDB.getInstance().init(false);
                        iStock = new SSStock(true);
                        SSInventory sSInventory = new SSInventory();
                        for (SSProduct iProduct : SSDB.getInstance().getProducts()) {
                            SSInventoryRow sSInventoryRow = new SSInventoryRow();
                            sSInventoryRow.setProduct(iProduct);
                            sSInventoryRow.setStockQuantity(iStock.getQuantity(iProduct));
                            if (!iStockStatusStart.containsKey(iProduct.getNumber())) continue;
                            sSInventoryRow.setInventoryQuantity((Integer)iStockStatusStart.get(iProduct.getNumber()));
                            sSInventory.getRows().add(sSInventoryRow);
                        }
                        sSInventory.setText("Lagerjustering vid transaktionsrensning");
                        SSDB.getInstance().addInventory(sSInventory);
                        SSDB.getInstance().shutdownCompact();
                        System.exit(0);
                    }
                });
            }
        });
        this.iMenuLoader.addActionListener("helpmenu.about", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAboutDialog.showDialog(SSMainMenu.this.iMainFrame);
            }
        });
    }

    private void loadWindowActions() {
        this.iWindowItems = new LinkedList<JMenuItem>();
        SSFrameManager.getInstance().addFrameListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenu iMenu = SSMainMenu.this.iMenuLoader.getMenu("Window");
                if (iMenu == null) {
                    return;
                }
                for (JMenuItem iMenuItem : SSMainMenu.this.iWindowItems) {
                    iMenu.remove(iMenuItem);
                }
                SSMainMenu.this.iWindowItems.clear();
                int iCounter = 0;
                for (final SSInternalFrame iFrame : SSFrameManager.getInstance().getFrames()) {
                    JMenuItem iMenuItem = new JMenuItem();
                    iMenuItem.setText(Integer.toString(iCounter) + ": " + iFrame.getTitle());
                    iMenuItem.setMnemonic((char)(48 + iCounter));
                    iMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            iFrame.deIconize();
                        }
                    });
                    iMenu.add(iMenuItem);
                    SSMainMenu.this.iWindowItems.add(iMenuItem);
                    ++iCounter;
                }
            }
        });
        this.iMenuLoader.addActionListener("windowmenu.cascade", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSFrameManager.getInstance().cascade();
            }
        });
        this.iMenuLoader.addActionListener("windowmenu.close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSFrameManager.getInstance().close();
            }
        });
    }

    private boolean createBackupDialog() {
        boolean result = false;
        if (SSDB.getInstance().getLocking()) {
            new SSInformationDialog(this.iMainFrame, "backupframe.runningonserver");
        } else {
            SSBackupFileChooser fc = SSBackupFileChooser.getInstance();
            SSBackupDatabase db = SSBackupDatabase.getInstance();
            SSBackupDialog backupDialog = new SSBackupDialog(this.iMainFrame, fc, db);
            SSBackupFrame.hideFrame();
            result = backupDialog.show();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.SSMainMenu");
        sb.append("{iMainFrame=").append(this.iMainFrame);
        sb.append(", iMenuLoader=").append(this.iMenuLoader);
        sb.append(", iWindowItems=").append(this.iWindowItems);
        sb.append('}');
        return sb.toString();
    }
}

