/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.panel.SSAccountingYearPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSNewAccountingYearDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSNewAccountingYearDialog() {
    }

    public static void showDialog(final SSMainFrame iMainFrame, SSDefaultTableModel<SSNewAccountingYear> pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("accountingyearframe.new.title"));
        final SSAccountingYearPanel iPanel = new SSAccountingYearPanel();
        iPanel.setAccountingYear(new SSNewAccountingYear());
        iPanel.setYearFromAndTo();
        iPanel.addOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear iAccountingYear = iPanel.getAccountingYear();
                SSDB.getInstance().addAccountingYear(iAccountingYear);
                int iResponce = SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "accountingyearframe.replaceyear", iAccountingYear.toRenderString());
                if (iResponce == 0) {
                    SSDB.getInstance().setCurrentYear(iAccountingYear);
                    SSDB.getInstance().initYear(true);
                    SSYearLock.applyLock(iAccountingYear);
                    SSDBConfig.setYearId(SSDB.getInstance().getCurrentCompany().getId(), iAccountingYear.getId());
                    SSFrameManager.getInstance().close();
                }
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

