/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.gui.accountingyear.util.SSStartingAmountTableModel;
import se.swedsoft.bookkeeping.gui.util.components.SSCurrencyTextField;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;

public class SSStartingAmountPanel {
    private JPanel iPanel;
    private SSTable iTable;
    private Map<SSAccount, BigDecimal> iInBalance;
    private SSDefaultTableModel<SSAccount> iModel;
    private SSCurrencyTextField iSumField;

    public SSStartingAmountPanel() {
        this.$$$setupUI$$$();
        this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        this.iModel = new SSStartingAmountTableModel(this.iInBalance);
        this.iTable.setModel(this.iModel);
        this.iTable.getColumnModel().getColumn(0).setPreferredWidth(55);
        this.iTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.iTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.iTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.iTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.iTable.getColumnModel().getColumn(2).setMinWidth(60);
        this.iTable.setDefaultEditor(BigDecimal.class, new SSBigDecimalCellEditor(2));
        this.iTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 2) {
                    SSStartingAmountPanel.this.updateSumField();
                }
            }
        });
    }

    public void setInBalance(Map<SSAccount, BigDecimal> pInBalance, List<SSAccount> pBalanceAccounts) {
        this.iInBalance.clear();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : pInBalance.entrySet()) {
            this.iInBalance.put(ssAccountBigDecimalEntry.getKey(), new BigDecimal(ssAccountBigDecimalEntry.getValue().doubleValue()));
        }
        this.iModel.setObjects(pBalanceAccounts);
        this.updateSumField();
    }

    public void setInBalance(Map<SSAccount, BigDecimal> pInBalance) {
        this.iInBalance.clear();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : pInBalance.entrySet()) {
            this.iInBalance.put(ssAccountBigDecimalEntry.getKey(), new BigDecimal(ssAccountBigDecimalEntry.getValue().doubleValue()));
        }
        this.updateSumField();
    }

    public Map<SSAccount, BigDecimal> getInBalance() {
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : this.iInBalance.entrySet()) {
            BigDecimal iValue = ssAccountBigDecimalEntry.getValue();
            if (iValue == null || iValue.signum() == 0) continue;
            iResult.put(ssAccountBigDecimalEntry.getKey(), iValue);
        }
        return iResult;
    }

    private void updateSumField() {
        BigDecimal iSum = new BigDecimal(0);
        for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : this.iInBalance.entrySet()) {
            BigDecimal iVal = ssAccountBigDecimalEntry.getValue();
            if (iVal == null) {
                iVal = new BigDecimal(0);
                this.iInBalance.put(ssAccountBigDecimalEntry.getKey(), iVal);
            }
            iSum = iSum.add(iVal);
        }
        this.iSumField.setValue(iSum);
        if (iSum.signum() == 0) {
            this.iSumField.setForeground(Color.BLACK);
        } else {
            this.iSumField.setForeground(Color.RED);
        }
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountingyear.panel.SSStartingAmountPanel");
        sb.append("{iInBalance=").append(this.iInBalance);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iSumField=").append(this.iSumField);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSCurrencyTextField sSCurrencyTextField;
        SSTable sSTable;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, 1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iSumField = sSCurrencyTextField = new SSCurrencyTextField();
        sSCurrencyTextField.setEditable(false);
        jPanel2.add((Component)sSCurrencyTextField, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, new Dimension(120, -1), null, new Dimension(-1, 20)));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("startingammountpanel.sumlabel"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, new Dimension(16, -1), null, new Dimension(16, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

