/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountplans.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAccountPlanType;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountplans.dialog.SSImportAccountplanDialog;
import se.swedsoft.bookkeeping.gui.accountplans.util.SSAccountPlanRowTableModel;
import se.swedsoft.bookkeeping.gui.accountplans.util.SSAccountPlanTypeModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public class SSAccountPlanPanel {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    protected JTextField iName;
    protected JTextField iBase;
    protected JLabel iBaseLabel;
    protected JTextField iAssessementYear;
    protected SSTableComboBox<SSAccountPlanType> iType;
    protected JButton iImportFields;
    private SSTable iTable;
    private SSAccountPlan iAccountPlan;
    private SSAccountPlanRowTableModel iModel;
    private JButton iDeleteRowButton;
    private SSInputVerifier iInputVerifier;

    public SSAccountPlanPanel(final SSMainFrame iMainFrame) {
        this.$$$setupUI$$$();
        this.iModel = new SSAccountPlanRowTableModel();
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_ACTIVE, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_NUMBER, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_VATCODE, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_SRUCODE, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_REPORTCODE, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSAccountPlanRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iDeleteRowButton.setIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.NORMAL));
        this.iDeleteRowButton.setDisabledIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.DISABLED));
        this.iDeleteRowButton.setRolloverIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.HIGHLIGHTED));
        AbstractAction iTraversal = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = SSAccountPlanPanel.this.iTable.getSelectedColumn();
                int row = SSAccountPlanPanel.this.iTable.getSelectedRow();
                if (SSAccountPlanPanel.this.iTable.isEditing()) {
                    col = SSAccountPlanPanel.this.iTable.getEditingColumn();
                    row = SSAccountPlanPanel.this.iTable.getEditingRow();
                    if (!SSAccountPlanPanel.this.iTable.getCellEditor(row, col).stopCellEditing()) {
                        return;
                    }
                }
                if (col >= 0 && col <= 4) {
                    SSAccountPlanPanel.this.iTable.changeSelection(row, col + 1, false, false);
                }
                if (col == 5) {
                    SSAccountPlanPanel.this.iTable.changeSelection(row + 1, 1, false, false);
                }
            }
        };
        AbstractAction iDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSAccountPlanPanel.this.iTable.isEditing()) {
                    return;
                }
                List iSelected = SSAccountPlanPanel.this.iModel.getSelectedRows(SSAccountPlanPanel.this.iTable);
                if (iSelected != null) {
                    int col = SSAccountPlanPanel.this.iTable.getSelectedColumn();
                    int row = SSAccountPlanPanel.this.iTable.getSelectedRow();
                    if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "accountplanpanel.delete", new Object[0]) != 0) {
                        return;
                    }
                    SSAccountPlanPanel.this.iModel.delete(iSelected);
                    SSAccountPlanPanel.this.iTable.changeSelection(row - 1, col, false, false);
                }
            }
        };
        this.iTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER_TRAVERSAL");
        this.iTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_ROW");
        this.iTable.getActionMap().put("ENTER_TRAVERSAL", iTraversal);
        this.iTable.getActionMap().put("DELETE_ROW", iDelete);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (SSAccountPlanPanel.this.iTable.getSelectedColumn() == -1) {
                    SSAccountPlanPanel.this.iTable.setColumnSelectionInterval(1, 1);
                }
            }
        });
        this.iDeleteRowButton.setEnabled(false);
        this.iTable.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SSAccountPlanPanel.this.iDeleteRowButton.setEnabled(SSAccountPlanPanel.this.iTable.getSelectedRowCount() > 0);
            }
        });
        this.iDeleteRowButton.addActionListener(iDelete);
        this.iType.setModel(SSAccountPlanTypeModel.getDropDownModel());
        this.iImportFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSImportAccountplanDialog iDialog = new SSImportAccountplanDialog(iMainFrame);
                iDialog.setLocationRelativeTo(iMainFrame);
                iDialog.setVisible(true);
                if (iDialog.getModalResult() != 0) {
                    return;
                }
                SSAccountPlan iSelected = iDialog.geAccountPlan();
                if (iSelected != null) {
                    SSAccountPlanPanel.this.getAccountPlan();
                    if (iDialog.isSRUSelected()) {
                        SSAccountPlanPanel.this.iAccountPlan.importSRUCodesFrom(iSelected);
                    }
                    if (iDialog.isVATSelected()) {
                        SSAccountPlanPanel.this.iAccountPlan.importVATCodesFrom(iSelected);
                    }
                    if (iDialog.isRECSelected()) {
                        SSAccountPlanPanel.this.iAccountPlan.importReportCodesFrom(iSelected);
                    }
                    SSAccountPlanPanel.this.setAccountPlan(SSAccountPlanPanel.this.iAccountPlan);
                }
            }
        });
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSAccountPlanPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSAccountPlanPanel.this.iName.requestFocusInWindow();
            }
        });
        this.iName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAccountPlanPanel.this.iAssessementYear.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iAssessementYear.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAccountPlanPanel.this.iType.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAccountPlanPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAccountPlanPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }

    protected SSAccount getSelectedRow() {
        int selected = this.iTable.getSelectedRow();
        return selected < 0 ? null : (SSAccount)this.iModel.getObject(selected);
    }

    public void setAccountPlan(SSAccountPlan pAccountPlan) {
        this.iAccountPlan = pAccountPlan;
        this.iModel.setObjects(pAccountPlan.getAccounts());
        this.iName.setText(pAccountPlan.getName());
        this.iBase.setText(pAccountPlan.getBaseName());
        this.iType.setSelected(pAccountPlan.getType());
        this.iAssessementYear.setText(pAccountPlan.getAssessementYear());
    }

    public SSAccountPlan getAccountPlan() {
        this.iAccountPlan.setName(this.iName.getText());
        this.iAccountPlan.setType(this.iType.getSelected());
        this.iAccountPlan.setAssessementYear(this.iAssessementYear.getText());
        HashSet<SSAccount> iAccounts = new HashSet<SSAccount>(this.iAccountPlan.getAccounts());
        this.iAccountPlan.setAccounts(new LinkedList<SSAccount>(iAccounts));
        return this.iAccountPlan;
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener e) {
        this.iButtonPanel.addOkActionListener(e);
    }

    public void addCancelAction(ActionListener e) {
        this.iButtonPanel.addCancelActionListener(e);
    }

    public void setShowBase(boolean iShowBase) {
        this.iBase.setVisible(iShowBase);
        this.iBaseLabel.setVisible(iShowBase);
    }

    public boolean isValid() {
        return this.iName.getText().length() != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountplans.panel.SSAccountPlanPanel");
        sb.append("{iAccountPlan=").append(this.iAccountPlan);
        sb.append(", iAssessementYear=").append(this.iAssessementYear);
        sb.append(", iBase=").append(this.iBase);
        sb.append(", iBaseLabel=").append(this.iBaseLabel);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iDeleteRowButton=").append(this.iDeleteRowButton);
        sb.append(", iImportFields=").append(this.iImportFields);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iName=").append(this.iName);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iType=").append(this.iType);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSTable sSTable;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel;
        JTextField jTextField3;
        JButton jButton;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), 4, 4, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 4, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 3, 5, 1, 5, 2, 3, 7, null, null, null));
        SSButton sSButton = new SSButton();
        this.iImportFields = sSButton;
        sSButton.setHorizontalAlignment(0);
        this.$$$loadButtonText$$$(sSButton, ResourceBundle.getBundle("book").getString("accountplanframe.importfield"));
        sSButton.setToolTipText(ResourceBundle.getBundle("book").getString("accountplanframe.importfield.tooltip"));
        sSButton.setIconName("ICON_IMPORT");
        jPanel3.add((Component)sSButton, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 0, null, new Dimension(130, -1), new Dimension(-1, 28)));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.iDeleteRowButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("accountplanframe.deleterow"));
        jButton.setToolTipText(ResourceBundle.getBundle("book").getString("voucherpanel.deleterow"));
        jPanel3.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 4, 0, 3, 0, null, new Dimension(130, -1), new Dimension(-1, 28)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("accountplanpanel.name"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iName = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.iBaseLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("accountplanpanel.base"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iBase = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("accountplanpanel.assessementyear"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iAssessementYear = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("accountplanpanel.type"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iType = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

