/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.autodist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSAutoDist;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.autodist.SSAutoDistDialog;
import se.swedsoft.bookkeeping.gui.autodist.util.SSAutoDistTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public class SSAutoDistFrame
extends SSDefaultTableFrame {
    private static SSAutoDistFrame cInstance;
    private SSTable iTable;
    private SSAutoDistTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSAutoDistFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSAutoDistFrame getInstance() {
        return cInstance;
    }

    private SSAutoDistFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("autodistframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "autodistframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAutoDistDialog.newDialog(SSAutoDistFrame.this.getMainFrame(), SSAutoDistFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "autodistframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAutoDist iSelected = (SSAutoDist)SSAutoDistFrame.this.iModel.getSelectedRow(SSAutoDistFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSAutoDistFrame.this.getAutoDist(iSelected);
                }
                if (iSelected != null) {
                    SSAutoDistDialog.editDialog(SSAutoDistFrame.this.getMainFrame(), iSelected, SSAutoDistFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSAutoDistFrame.this.getMainFrame(), "autodistframe.autodistgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "autodistframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAutoDist iSelected = (SSAutoDist)SSAutoDistFrame.this.iModel.getSelectedRow(SSAutoDistFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSAutoDistFrame.this.getAutoDist(iSelected);
                }
                if (iSelected != null) {
                    SSAutoDistDialog.copyDialog(SSAutoDistFrame.this.getMainFrame(), iSelected, SSAutoDistFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSAutoDistFrame.this.getMainFrame(), "autodistframe.autodistgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "autodistframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSAutoDistFrame.this.iTable.getSelectedRows();
                List toDelete = SSAutoDistFrame.this.iModel.getObjects(selected);
                SSAutoDistFrame.this.deleteSelectedAutoDists(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSAutoDistTableModel();
        this.iModel.addColumn(SSAutoDistTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSAutoDistTableModel.COLUMN_DESCRIPTION);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAutoDist iSelected = (SSAutoDist)SSAutoDistFrame.this.iModel.getSelectedRow(SSAutoDistFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSAutoDistFrame.this.getAutoDist(iSelected);
                if (iSelected != null) {
                    SSAutoDistDialog.editDialog(SSAutoDistFrame.this.getMainFrame(), iSelected, SSAutoDistFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSAutoDistFrame.this.getMainFrame(), "autodistframe.autodistgone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    public SSAutoDistTableModel getModel() {
        return this.iModel;
    }

    private void deleteSelectedAutoDists(List<SSAutoDist> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "autodistframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSAutoDist iAutoDist : delete) {
                if (SSPostLock.isLocked("autodist" + iAutoDist.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "autodistframe.autodistopen", iAutoDist.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteAutoDist(iAutoDist);
            }
        }
    }

    private SSAutoDist getAutoDist(SSAutoDist iAutoDist) {
        return SSDB.getInstance().getAutoDist(iAutoDist);
    }

    private List<SSAutoDist> getAutoDists(List<SSAutoDist> iAutoDists) {
        return SSDB.getInstance().getAutoDists(iAutoDists);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getAutoDists());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.autodist.SSAutoDistFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

