/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.autodist.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAutoDist;
import se.swedsoft.bookkeeping.data.SSAutoDistRow;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.autodist.util.SSAutoDistRowTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;

public class SSAutoDistPanel {
    private SSAutoDist iAutoDist;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private SSTable iTable;
    private JTextField iText;
    private SSTableComboBox<SSAccount> iAccount;
    private SSAutoDistRowTableModel iModel;
    private JTextField iAccountDescription;
    private SSBigDecimalTextField iAmount;

    public SSAutoDistPanel(SSDialog iDialog, boolean iEdit) {
        this.$$$setupUI$$$();
        this.iAccount.setEnabled(!iEdit);
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setSingleSelect();
        this.iButtonPanel.getOkButton().setEnabled(false);
        this.iModel = new SSAutoDistRowTableModel();
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_PERCENTAGE, true);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_DEBET, true);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_CREDIT, true);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSAutoDistRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iTable.setSingleSelect();
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSAutoDistRow iSelected = (SSAutoDistRow)SSAutoDistPanel.this.iModel.getSelectedRow(SSAutoDistPanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "autodistframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSAutoDistPanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 6) {
                    ++iPosition.x;
                }
                if (iPosition.x == 7) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSAutoDistPanel.this.iModel.getRowCount()) {
                        SSAutoDistPanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        this.iAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iAccount.setSearchColumns(0);
        this.iAccount.setAllowCustomValues(true);
        this.iAccount.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount iAccount) {
                SSAutoDistPanel.this.iAccountDescription.setText(iAccount.getDescription());
                SSAutoDistPanel.this.iButtonPanel.getOkButton().setEnabled(true);
            }
        });
        this.iAccount.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSAutoDistPanel.this.iAccount.getSelected() == null) {
                    SSAutoDistPanel.this.iButtonPanel.getOkButton().setEnabled(false);
                    SSAutoDistPanel.this.iAccountDescription.setText(null);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SSAutoDistPanel.this.iAccount.isEnabled()) {
                    SSAutoDistPanel.this.iAccount.getComponent(0).requestFocusInWindow();
                } else {
                    SSAutoDistPanel.this.iText.requestFocusInWindow();
                }
            }
        });
        this.iAccount.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAutoDistPanel.this.iText.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAutoDistPanel.this.iAmount.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iAmount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAutoDistPanel.this.iTable.requestFocusInWindow();
                            SSAutoDistPanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAutoDistPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSAutoDistPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public SSAutoDist getAutoDist() {
        this.iAutoDist.setDescrition(this.iText.getText());
        this.iAutoDist.setAccount(this.iAccount.getSelected());
        this.iAutoDist.setAmount(this.iAmount.getValue());
        this.iAutoDist.setRows(this.iModel.getObjects());
        return this.iAutoDist;
    }

    public void setAutoDist(SSAutoDist iAutoDist) {
        this.iAutoDist = iAutoDist;
        this.iModel.setObjects(iAutoDist.getRows());
        this.iAccount.setSelected(iAutoDist.getAccount());
        if (this.iAccount.getSelected() != null) {
            this.iAccountDescription.setText(this.iAccount.getSelected().getDescription());
            this.iButtonPanel.getOkButton().setEnabled(true);
        }
        this.iText.setText(iAutoDist.getDescription());
        this.iAmount.setValue(iAutoDist.getAmount());
    }

    public void addOkActionListener(ActionListener l) {
        this.iButtonPanel.addOkActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.iButtonPanel.addCancelActionListener(l);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.autodist.panel.SSAutoDistPanel");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iAccountDescription=").append(this.iAccountDescription);
        sb.append(", iAmount=").append(this.iAmount);
        sb.append(", iAutoDist=").append(this.iAutoDist);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iText=").append(this.iText);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        SSTable sSTable;
        SSBigDecimalTextField sSBigDecimalTextField;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("autodistframe.account"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("autodistframe.text"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iText = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, new Dimension(350, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iAccount = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(100, -1), null));
        this.iAccountDescription = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(10);
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, new Dimension(245, -1), null, new Dimension(245, -1)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("autodistframe.amount"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iAmount = sSBigDecimalTextField = new SSBigDecimalTextField();
        jPanel2.add((Component)sSBigDecimalTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 3, new Dimension(100, -1), null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

