/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.backup;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import se.swedsoft.bookkeeping.data.backup.SSBackup;
import se.swedsoft.bookkeeping.data.backup.SSBackupDatabase;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupFactory;

public class SSBackupDialog {
    private final JFrame parent;
    private final JFileChooser fileChooser;
    private final SSBackupDatabase backupDatabase;

    public SSBackupDialog(JFrame parent, JFileChooser fileChooser, SSBackupDatabase backupDatabase) {
        this.parent = parent;
        this.fileChooser = fileChooser;
        this.backupDatabase = backupDatabase;
    }

    public boolean show() {
        String defaultFileName = SSBackupFactory.getDefaultFileName();
        this.fileChooser.setSelectedFile(new File(defaultFileName));
        int result = this.fileChooser.showSaveDialog(this.parent);
        if (result == 0) {
            String filename = this.fileChooser.getSelectedFile().getAbsolutePath();
            SSBackup backup = SSBackupFactory.createBackup(filename);
            this.backupDatabase.add(backup);
            this.backupDatabase.notifyUpdated();
            return true;
        }
        return false;
    }
}

