/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.backup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.backup.SSBackup;
import se.swedsoft.bookkeeping.data.backup.SSBackupDatabase;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupFactory;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.backup.util.SSBackupTableModel;
import se.swedsoft.bookkeeping.gui.company.SSCompanyFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSBackupFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.util.SSException;

public class SSBackupFrame
extends SSDefaultTableFrame {
    private static SSBackupFrame cInstance;
    private SSBackupDatabase iDatabase;
    private SSTable iTable;
    private SSTableModel<SSBackup> iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSBackupFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static void hideFrame() {
        if (cInstance != null) {
            cInstance.setVisible(true);
        }
    }

    public static SSBackupFrame getInstance() {
        return cInstance;
    }

    private SSBackupFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        super(pMainFrame, SSBundle.getBundle().getString("backupframe.title"), pWidth, pHeight);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_IMPORT", "backupframe.restorebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBackup iBackup = SSBackupFrame.this.getSelected();
                if (iBackup == null) {
                    new SSErrorDialog(SSBackupFrame.this.getMainFrame(), "backupframe.selectone");
                    return;
                }
                if (!iBackup.exists()) {
                    SSBackupFrame.this.iDatabase.getBackups().remove(iBackup);
                    SSBackupFrame.this.iDatabase.notifyUpdated();
                    new SSErrorDialog(SSBackupFrame.this.getMainFrame(), "backupframe.missingfile");
                    return;
                }
                try {
                    SSBackupFactory.restoreBackup(iBackup.getFilename());
                    SSDB.getInstance().setCurrentCompany(null);
                    SSDB.getInstance().setCurrentYear(null);
                    SSBackupFrame.this.iModel.fireTableDataChanged();
                    SSFrameManager.getInstance().close();
                    SSCompanyFrame.showFrame(SSBackupFrame.this.getMainFrame(), 500, 300);
                }
                catch (SSException ex) {
                    new SSErrorDialog(SSBackupFrame.this.getMainFrame(), "exceptiondialog", ex.getLocalizedMessage());
                }
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_OPENITEM", "backupframe.openbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBackupFileChooser iFileChooser = SSBackupFileChooser.getInstance();
                if (iFileChooser.showOpenDialog(SSBackupFrame.this.getMainFrame()) != 0) {
                    return;
                }
                String iFileName = iFileChooser.getSelectedFile().getAbsolutePath();
                try {
                    SSBackupFactory.restoreBackup(iFileName);
                    SSDB.getInstance().setCurrentCompany(null);
                    SSDB.getInstance().setCurrentYear(null);
                    SSBackupFrame.this.iModel.fireTableDataChanged();
                    SSCompanyFrame.showFrame(SSBackupFrame.this.getMainFrame(), 500, 300);
                }
                catch (SSException ex) {
                    new SSErrorDialog(SSBackupFrame.this.getMainFrame(), "exceptiondialog", ex.getLocalizedMessage());
                }
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "backupframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBackupFrame.this.deleteSelectedBackup();
            }
        });
        toolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iDatabase = SSBackupDatabase.getInstance();
        List<SSBackup> iBackups = this.iDatabase.getBackups();
        Collections.sort(iBackups, new Comparator<SSBackup>(){

            @Override
            public int compare(SSBackup o1, SSBackup o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        this.iTable = new SSTable();
        this.iModel = new SSBackupTableModel(iBackups);
        this.iModel.addColumn(SSBackupTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSBackupTableModel.COLUMN_FILENAME);
        this.iModel.addColumn(SSBackupTableModel.COLUMN_TYPE);
        this.iModel.setupTable(this.iTable);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    private SSBackup getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return this.iModel.getObject(selected);
        }
        return null;
    }

    private void deleteSelectedBackup() {
        SSBackup iBackup = this.getSelected();
        if (iBackup == null) {
            new SSErrorDialog(this.getMainFrame(), "backupframe.selectone");
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "backupframe.delete", iBackup.getFilename());
        if (iDialog.getResponce() != 0) {
            return;
        }
        try {
            iBackup.delete();
            this.iDatabase.getBackups().remove(iBackup);
            this.iModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isCompanyFrame() {
        return false;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.backup.SSBackupFrame");
        sb.append("{iDatabase=").append(this.iDatabase);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

