/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.budget.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.gui.budget.util.SSBudgetTableModels;
import se.swedsoft.bookkeeping.gui.budget.util.SSMonthlyTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;

public class SSBudgetMainPanel {
    private JPanel iPanel;
    private SSDefaultTableModel<SSAccount> iBudgetTableModel;
    private SSMonthlyTableModel iMonthlyTableModel;
    private SSTable iBudgetTable;
    private SSTable iMonthlyTable;
    private JTextField iAccountDescription;
    private JTabbedPane iTabbedPane;
    private SSAccount iCurrentAccount;
    private SSBudget iBudget;
    private SSTableComboBoxOld<SSAccount> iAccountNumber;
    private JTextField iSumTextField;

    public SSBudgetMainPanel(SSBudget pBudget) {
        this.iBudget = pBudget;
        this.$$$setupUI$$$();
        this.iBudgetTableModel = SSBudgetTableModels.createBudgetTableModel(pBudget);
        this.iMonthlyTableModel = SSBudgetTableModels.createMonthlyTableModel(pBudget, null);
        List<SSAccount> iAccounts = pBudget.getAccounts();
        SSDefaultTableModel<SSAccount> iModel = new SSDefaultTableModel<SSAccount>(iAccounts){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSAccount account = (SSAccount)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = account.getNumber();
                        break;
                    }
                    case 1: {
                        value = account.getDescription();
                    }
                }
                return value;
            }
        };
        iModel.addColumn(SSBundle.getBundle().getString("accounttable.column.1"));
        iModel.addColumn(SSBundle.getBundle().getString("accounttable.column.2"));
        this.iAccountNumber.setModel(iModel);
        this.iAccountNumber.setSearchColumns(0);
        this.iAccountNumber.setColumnWidths(60, 270);
        this.iAccountNumber.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount selected) {
                SSBudgetMainPanel.this.iMonthlyTable.removeEditor();
                SSBudgetMainPanel.this.setCurrentAccount(selected);
            }
        });
        this.iBudgetTable.setModel(this.iBudgetTableModel);
        this.iBudgetTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.iBudgetTable.getColumnModel().getColumn(1).setPreferredWidth(600);
        this.iBudgetTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.iBudgetTable.getColumnModel().getColumn(2).setCellRenderer(new SSBigDecimalCellRenderer(2, true));
        this.iBudgetTable.getColumnModel().getColumn(2).setCellEditor(new SSBigDecimalCellEditor(2));
        this.iMonthlyTable.setDefaultEditor(BigDecimal.class, new SSBigDecimalCellEditor(2));
        this.iMonthlyTable.setModel(this.iMonthlyTableModel);
        this.iMonthlyTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.iMonthlyTable.getColumnModel().getColumn(1).setCellRenderer(new SSBigDecimalCellRenderer(2, true));
        this.iMonthlyTable.getColumnModel().getColumn(1).setCellEditor(new SSBigDecimalCellEditor(2));
        this.iBudgetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SSAccount account;
                if (SSBudgetMainPanel.this.iBudgetTable.getSelectedRowCount() > 0 && (account = (SSAccount)SSBudgetMainPanel.this.iBudgetTableModel.getObject(SSBudgetMainPanel.this.iBudgetTable.getSelectedRow())) != null) {
                    SSBudgetMainPanel.this.setCurrentAccount(account);
                }
            }
        });
        this.iBudgetTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SSBudgetMainPanel.this.iBudgetTable.getSelectedColumn() != 2) {
                    SSBudgetMainPanel.this.iTabbedPane.setSelectedIndex(1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.iBudgetTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSBudgetMainPanel.this.updateSumLabel();
            }
        });
        this.iMonthlyTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSBudgetMainPanel.this.updateSumLabel();
            }
        });
        this.updateSumLabel();
    }

    private void setCurrentAccount(SSAccount pAccount) {
        this.iCurrentAccount = pAccount;
        this.iMonthlyTableModel.setAccount(pAccount);
        this.updateSumLabel();
        this.iAccountDescription.setText(pAccount.getDescription());
        this.iAccountNumber.setSelected(pAccount);
    }

    private void updateSumLabel() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        format.setGroupingUsed(true);
        if (this.iCurrentAccount == null) {
            this.iSumTextField.setText(format.format(0L));
        } else {
            BigDecimal value = this.iBudget.getSumForAccount(this.iCurrentAccount);
            if (value == null) {
                this.iSumTextField.setText(format.format(0L));
            } else {
                this.iSumTextField.setText(format.format(value));
            }
        }
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public SSBudget getBudget() {
        return this.iBudget;
    }

    public void setBudget(SSBudget pBudget) {
        this.iBudget = pBudget;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.budget.panel.SSBudgetMainPanel");
        sb.append("{iAccountDescription=").append(this.iAccountDescription);
        sb.append(", iAccountNumber=").append(this.iAccountNumber);
        sb.append(", iBudget=").append(this.iBudget);
        sb.append(", iBudgetTable=").append(this.iBudgetTable);
        sb.append(", iBudgetTableModel=").append(this.iBudgetTableModel);
        sb.append(", iCurrentAccount=").append(this.iCurrentAccount);
        sb.append(", iMonthlyTable=").append(this.iMonthlyTable);
        sb.append(", iMonthlyTableModel=").append(this.iMonthlyTableModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iSumTextField=").append(this.iSumTextField);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        SSTable sSTable;
        JTextField jTextField2;
        SSTable sSTable2;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setFocusTraversalPolicyProvider(false);
        this.iTabbedPane = jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(1);
        jTabbedPane.setFocusTraversalPolicyProvider(true);
        jTabbedPane.setInheritsPopupMenu(true);
        jPanel.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("budgetframe.panel.resultatbudget.title"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iBudgetTable = sSTable2 = new SSTable();
        ((Component)sSTable2).setEnabled(true);
        jScrollPane.setViewportView(sSTable2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(true);
        jPanel3.setRequestFocusEnabled(false);
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("budgetframe.panel.monthlydistribution.title"), null, jPanel3, null);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setInheritsPopupMenu(true);
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("budgetframe.monthlytable.account"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iAccountDescription = jTextField2 = new JTextField();
        jTextField2.setFocusTraversalPolicyProvider(true);
        jTextField2.setEditable(false);
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        SSTableComboBoxOld sSTableComboBoxOld = new SSTableComboBoxOld();
        this.iAccountNumber = sSTableComboBoxOld;
        sSTableComboBoxOld.setInheritsPopupMenu(true);
        sSTableComboBoxOld.setFocusTraversalPolicyProvider(true);
        jPanel4.add(sSTableComboBoxOld, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 1, null, new Dimension(80, -1), new Dimension(-1, 20)));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel3.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iMonthlyTable = sSTable = new SSTable();
        jScrollPane2.setViewportView(sSTable);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("budgetframe.monthlytable.sum"));
        jLabel2.setVerticalAlignment(1);
        jLabel2.setVerticalTextPosition(1);
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iSumTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setFocusTraversalPolicyProvider(true);
        jTextField.setHorizontalAlignment(4);
        jTextField.setEditable(false);
        jTextField.setText("122");
        jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), new Dimension(100, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

