/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.budget.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.gui.budget.util.SSMonthlyTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSBudgetTableModels {
    private SSBudgetTableModels() {
    }

    public static SSDefaultTableModel<SSAccount> createBudgetTableModel(final SSBudget pBudget) {
        List<SSAccount> iAccounts = pBudget.getAccounts();
        SSDefaultTableModel<SSAccount> iTableModel = new SSDefaultTableModel<SSAccount>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return BigDecimal.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSAccount account = (SSAccount)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = account.getNumber();
                        break;
                    }
                    case 1: {
                        value = account.getDescription();
                        break;
                    }
                    case 2: {
                        value = pBudget.getSumForAccount(account);
                    }
                }
                return value;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                SSAccount account = (SSAccount)this.getObject(rowIndex);
                if (columnIndex == 2) {
                    pBudget.setSumForAccount(account, (BigDecimal)aValue);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 2;
            }
        };
        iTableModel.addColumn(SSBundle.getBundle().getString("budgetframe.budgettable.column.1"));
        iTableModel.addColumn(SSBundle.getBundle().getString("budgetframe.budgettable.column.2"));
        iTableModel.addColumn(SSBundle.getBundle().getString("budgetframe.budgettable.column.3"));
        iTableModel.setObjects(iAccounts);
        return iTableModel;
    }

    public static SSMonthlyTableModel createMonthlyTableModel(SSBudget pBudget, SSAccount pAccount) {
        List<SSMonth> iMonths = pBudget.getMonths();
        SSMonthlyTableModel iTableModel = new SSMonthlyTableModel(pBudget, pAccount);
        iTableModel.addColumn(SSBundle.getBundle().getString("budgetframe.monthlytable.column.1"));
        iTableModel.addColumn(SSBundle.getBundle().getString("budgetframe.monthlytable.column.2"));
        Collections.sort(iMonths, new Comparator<SSMonth>(){

            @Override
            public int compare(SSMonth o1, SSMonth o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        iTableModel.setObjects(iMonths);
        return iTableModel;
    }
}

