/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.company;

import java.util.ResourceBundle;
import javax.swing.JFrame;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSCompanyLock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.SSAccountingYearFrame;
import se.swedsoft.bookkeeping.gui.company.SSCompanyFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSCompanySettingsDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSCompanyDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSCompanyDialog() {
    }

    public static void editDialog(SSMainFrame iMainFrame, SSNewCompany pCompany, SSDefaultTableModel<SSNewCompany> pModel) {
        if (SSPostLock.isLocked(pCompany.getId())) {
            new SSErrorDialog(iMainFrame, "postlock.company");
            return;
        }
        SSPostLock.applyLock(pCompany.getId());
        SSCompanySettingsDialog iDialog = new SSCompanySettingsDialog(iMainFrame, bundle.getString("companyframe.edit.title"));
        iDialog.setSize(700, 550);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setCompany(pCompany);
        int iModalResult = iDialog.showDialog();
        if (iModalResult != 0) {
            if (iModalResult == -1) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "companyframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(pCompany.getId());
                    return;
                }
            } else {
                SSPostLock.removeLock(pCompany.getId());
                return;
            }
        }
        SSNewCompany iCompany = iDialog.getCompany();
        iCompany.setId(pCompany.getId());
        SSDB.getInstance().updateCompany(iCompany);
        if (SSCompanyFrame.getInstance() != null) {
            if (pModel != null) {
                pModel.fireTableDataChanged();
            }
            SSCompanyFrame.getInstance().updateFrame();
        }
        SSPostLock.removeLock(pCompany.getId());
    }

    public static void editCurrentDialog(SSMainFrame iMainFrame, SSNewCompany pCompany, SSDefaultTableModel<SSNewCompany> pModel) {
        if (SSPostLock.isLocked(pCompany.getId())) {
            new SSErrorDialog(iMainFrame, "postlock.company");
            return;
        }
        SSPostLock.applyLock(pCompany.getId());
        SSCompanySettingsDialog iDialog = new SSCompanySettingsDialog(iMainFrame, bundle.getString("companyframe.editcurrent.title"));
        iDialog.setSize(700, 550);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setCompany(pCompany);
        int iModalResult = iDialog.showDialog();
        if (iModalResult != 0) {
            if (iModalResult == -1) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "companyframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(pCompany.getId());
                    return;
                }
            } else {
                SSPostLock.removeLock(pCompany.getId());
                return;
            }
        }
        SSNewCompany iCompany = iDialog.getCompany();
        iCompany.setId(pCompany.getId());
        SSDB.getInstance().updateCompany(iCompany);
        if (SSCompanyFrame.getInstance() != null) {
            if (pModel != null) {
                pModel.fireTableDataChanged();
            }
            SSCompanyFrame.getInstance().updateFrame();
        }
        SSPostLock.removeLock(pCompany.getId());
    }

    public static void newDialog(SSMainFrame iMainFrame, SSDefaultTableModel<SSNewCompany> pModel) {
        SSCompanySettingsDialog iDialog = new SSCompanySettingsDialog(iMainFrame, bundle.getString("companyframe.new.title"));
        iDialog.setSize(700, 550);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setCompany(new SSNewCompany());
        int iModalResult = iDialog.showDialog();
        if (iModalResult != 0) {
            if (iModalResult == -1) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "companyframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
            } else {
                return;
            }
        }
        SSNewCompany iCompany = iDialog.getCompany();
        SSDB.getInstance().addCompany(iCompany);
        SSCompanyFrame.getInstance().updateFrame();
        SSQueryDialog iQDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "companyframe.replacecompany", iCompany.getName());
        if (iQDialog.getResponce() == 0) {
            SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
            SSDB.getInstance().setCurrentCompany(iCompany);
            SSDB.getInstance().init(true);
            SSDBConfig.setCompanyId(iCompany.getId());
            SSCompanyLock.applyLock(iCompany);
            SSDB.getInstance().setCurrentYear(null);
            pModel.fireTableDataChanged();
            SSFrameManager.getInstance().close();
            SSAccountingYearFrame.showFrame(iMainFrame, 500, 300, true);
        } else {
            pModel.fireTableDataChanged();
        }
        iDialog.closeDialog();
    }
}

