/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.company.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;

public class SSDefaultAccountPanel
extends JPanel {
    private Map<SSDefaultAccount, Integer> iDefaultAccounts;
    private Map<SSDefaultAccount, SSTableComboBox<SSAccount>> iComboBoxes;
    private Map<SSDefaultAccount, JTextField> iTextFields;
    private JPanel iPanel;
    private SSTableComboBox<SSAccount> iCustomerClaim;
    private SSTableComboBox<SSAccount> iInPayment;
    private SSTableComboBox<SSAccount> iOutPayment;
    private SSTableComboBox<SSAccount> iCash;
    private SSTableComboBox<SSAccount> iSupplierDebt;
    private SSTableComboBox<SSAccount> iTax1;
    private SSTableComboBox<SSAccount> iTax2;
    private SSTableComboBox<SSAccount> iTax3;
    private SSTableComboBox<SSAccount> iSales;
    private SSTableComboBox<SSAccount> iPurchases;
    private SSTableComboBox<SSAccount> iCurrencyProfit;
    private SSTableComboBox<SSAccount> iCurrencyLoss;
    private SSTableComboBox<SSAccount> iRounding;
    private SSTableComboBox<SSAccount> iInterestProfit;
    private SSTableComboBox<SSAccount> iIncommingTax;
    private JTextField iCustomerClaimText;
    private JTextField iInPaymentText;
    private JTextField iOutPaymentText;
    private JTextField iCashText;
    private JTextField iSupplierDebtText;
    private JTextField iTax1Text;
    private JTextField iTax2Text;
    private JTextField iTax3Text;
    private JTextField iSalesText;
    private JTextField iPurchasesText;
    private JTextField iCurrencyProfitText;
    private JTextField iCurrencyLossText;
    private JTextField iRoundingText;
    private JTextField iInterestProfitText;
    private JTextField iIncommingTaxText;

    public SSDefaultAccountPanel() {
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.iPanel, "Center");
        this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        this.iComboBoxes = new HashMap<SSDefaultAccount, SSTableComboBox<SSAccount>>();
        this.iComboBoxes.put(SSDefaultAccount.CustomerClaim, this.iCustomerClaim);
        this.iComboBoxes.put(SSDefaultAccount.InPayment, this.iInPayment);
        this.iComboBoxes.put(SSDefaultAccount.OutPayment, this.iOutPayment);
        this.iComboBoxes.put(SSDefaultAccount.Cash, this.iCash);
        this.iComboBoxes.put(SSDefaultAccount.SupplierDebt, this.iSupplierDebt);
        this.iComboBoxes.put(SSDefaultAccount.Tax1, this.iTax1);
        this.iComboBoxes.put(SSDefaultAccount.Tax2, this.iTax2);
        this.iComboBoxes.put(SSDefaultAccount.Tax3, this.iTax3);
        this.iComboBoxes.put(SSDefaultAccount.Sales, this.iSales);
        this.iComboBoxes.put(SSDefaultAccount.Purchases, this.iPurchases);
        this.iComboBoxes.put(SSDefaultAccount.CurrencyProfit, this.iCurrencyProfit);
        this.iComboBoxes.put(SSDefaultAccount.CurrencyLoss, this.iCurrencyLoss);
        this.iComboBoxes.put(SSDefaultAccount.Rounding, this.iRounding);
        this.iComboBoxes.put(SSDefaultAccount.InterestProfit, this.iInterestProfit);
        this.iComboBoxes.put(SSDefaultAccount.IncommingTax, this.iIncommingTax);
        this.iTextFields = new HashMap<SSDefaultAccount, JTextField>();
        this.iTextFields.put(SSDefaultAccount.CustomerClaim, this.iCustomerClaimText);
        this.iTextFields.put(SSDefaultAccount.InPayment, this.iInPaymentText);
        this.iTextFields.put(SSDefaultAccount.OutPayment, this.iOutPaymentText);
        this.iTextFields.put(SSDefaultAccount.Cash, this.iCashText);
        this.iTextFields.put(SSDefaultAccount.SupplierDebt, this.iSupplierDebtText);
        this.iTextFields.put(SSDefaultAccount.Tax1, this.iTax1Text);
        this.iTextFields.put(SSDefaultAccount.Tax2, this.iTax2Text);
        this.iTextFields.put(SSDefaultAccount.Tax3, this.iTax3Text);
        this.iTextFields.put(SSDefaultAccount.Sales, this.iSalesText);
        this.iTextFields.put(SSDefaultAccount.Purchases, this.iPurchasesText);
        this.iTextFields.put(SSDefaultAccount.CurrencyProfit, this.iCurrencyProfitText);
        this.iTextFields.put(SSDefaultAccount.CurrencyLoss, this.iCurrencyLossText);
        this.iTextFields.put(SSDefaultAccount.Rounding, this.iRoundingText);
        this.iTextFields.put(SSDefaultAccount.InterestProfit, this.iInterestProfitText);
        this.iTextFields.put(SSDefaultAccount.IncommingTax, this.iIncommingTaxText);
        for (int i = 0; i < SSDefaultAccount.values().length; ++i) {
            SSDefaultAccount iDefaultAccount = SSDefaultAccount.values()[i];
            SSTableComboBox<SSAccount> iComboBox = this.iComboBoxes.get(iDefaultAccount);
            iComboBox.setModel(SSAccountTableModel.getDropDownModel());
            iComboBox.setSearchColumns(0);
            iComboBox.setAllowCustomValues(true);
            iComboBox.addSelectionListener(new SelectionListener(iDefaultAccount));
        }
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        for (SSDefaultAccount iCurrent : SSDefaultAccount.values()) {
            SSTableComboBox<SSAccount> iComboBox = this.iComboBoxes.get(iCurrent);
            Integer iAccountNumber = iDefaultAccounts.get(iCurrent);
            if (iAccountNumber == null) {
                iAccountNumber = iCurrent.getDefaultAccountNumber();
            }
            if (iAccountPlan != null) {
                iComboBox.setSelected(iAccountPlan.getAccount(iAccountNumber), true);
                continue;
            }
            iComboBox.setText(iAccountNumber.toString());
        }
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        for (SSDefaultAccount iCurrent : SSDefaultAccount.values()) {
            Integer iAccountNumber;
            SSTableComboBox<SSAccount> iComboBox = this.iComboBoxes.get(iCurrent);
            if (iComboBox.getSelected() != null) {
                iAccountNumber = iComboBox.getSelected().getNumber();
            } else {
                try {
                    iAccountNumber = Integer.decode(iComboBox.getText());
                }
                catch (NumberFormatException e) {
                    iAccountNumber = iCurrent.getDefaultAccountNumber();
                }
            }
            this.iDefaultAccounts.put(iCurrent, iAccountNumber);
        }
        return this.iDefaultAccounts;
    }

    public void dispose() {
        this.iComboBoxes.clear();
        this.iComboBoxes = null;
        this.iTextFields.clear();
        this.iTextFields = null;
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iCustomerClaim.dispose();
        this.iCustomerClaim = null;
        this.iInPayment.dispose();
        this.iInPayment = null;
        this.iOutPayment.dispose();
        this.iOutPayment = null;
        this.iCash.dispose();
        this.iCash = null;
        this.iSupplierDebt.dispose();
        this.iSupplierDebt = null;
        this.iTax1.dispose();
        this.iTax1 = null;
        this.iTax2.dispose();
        this.iTax2 = null;
        this.iTax3.dispose();
        this.iTax3 = null;
        this.iSales.dispose();
        this.iSales = null;
        this.iPurchases.dispose();
        this.iPurchases = null;
        this.iCurrencyProfit.dispose();
        this.iCurrencyProfit = null;
        this.iCurrencyLoss.dispose();
        this.iCurrencyLoss = null;
        this.iRounding.dispose();
        this.iRounding = null;
        this.iInterestProfit.dispose();
        this.iInterestProfit = null;
        this.iIncommingTax.dispose();
        this.iIncommingTax = null;
        this.iCustomerClaimText.removeAll();
        this.iCustomerClaimText = null;
        this.iInPaymentText.removeAll();
        this.iInPaymentText = null;
        this.iOutPaymentText.removeAll();
        this.iOutPaymentText = null;
        this.iCashText.removeAll();
        this.iCashText = null;
        this.iSupplierDebtText.removeAll();
        this.iSupplierDebtText = null;
        this.iTax1Text.removeAll();
        this.iTax1Text = null;
        this.iTax2Text.removeAll();
        this.iTax2Text = null;
        this.iTax3Text.removeAll();
        this.iTax3Text = null;
        this.iSalesText.removeAll();
        this.iSalesText = null;
        this.iPurchasesText.removeAll();
        this.iPurchasesText = null;
        this.iCurrencyProfitText.removeAll();
        this.iCurrencyProfitText = null;
        this.iCurrencyLossText.removeAll();
        this.iCurrencyLossText = null;
        this.iRoundingText.removeAll();
        this.iRoundingText = null;
        this.iInterestProfitText.removeAll();
        this.iInterestProfitText = null;
        this.iIncommingTaxText.removeAll();
        this.iIncommingTaxText = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel");
        sb.append("{iCash=").append(this.iCash);
        sb.append(", iCashText=").append(this.iCashText);
        sb.append(", iComboBoxes=").append(this.iComboBoxes);
        sb.append(", iCurrencyLoss=").append(this.iCurrencyLoss);
        sb.append(", iCurrencyLossText=").append(this.iCurrencyLossText);
        sb.append(", iCurrencyProfit=").append(this.iCurrencyProfit);
        sb.append(", iCurrencyProfitText=").append(this.iCurrencyProfitText);
        sb.append(", iCustomerClaim=").append(this.iCustomerClaim);
        sb.append(", iCustomerClaimText=").append(this.iCustomerClaimText);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iIncommingTax=").append(this.iIncommingTax);
        sb.append(", iIncommingTaxText=").append(this.iIncommingTaxText);
        sb.append(", iInPayment=").append(this.iInPayment);
        sb.append(", iInPaymentText=").append(this.iInPaymentText);
        sb.append(", iInterestProfit=").append(this.iInterestProfit);
        sb.append(", iInterestProfitText=").append(this.iInterestProfitText);
        sb.append(", iOutPayment=").append(this.iOutPayment);
        sb.append(", iOutPaymentText=").append(this.iOutPaymentText);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPurchases=").append(this.iPurchases);
        sb.append(", iPurchasesText=").append(this.iPurchasesText);
        sb.append(", iRounding=").append(this.iRounding);
        sb.append(", iRoundingText=").append(this.iRoundingText);
        sb.append(", iSales=").append(this.iSales);
        sb.append(", iSalesText=").append(this.iSalesText);
        sb.append(", iSupplierDebt=").append(this.iSupplierDebt);
        sb.append(", iSupplierDebtText=").append(this.iSupplierDebtText);
        sb.append(", iTax1=").append(this.iTax1);
        sb.append(", iTax1Text=").append(this.iTax1Text);
        sb.append(", iTax2=").append(this.iTax2);
        sb.append(", iTax2Text=").append(this.iTax2Text);
        sb.append(", iTax3=").append(this.iTax3);
        sb.append(", iTax3Text=").append(this.iTax3Text);
        sb.append(", iTextFields=").append(this.iTextFields);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JTextField jTextField9;
        JTextField jTextField10;
        JTextField jTextField11;
        JTextField jTextField12;
        JTextField jTextField13;
        JTextField jTextField14;
        JTextField jTextField15;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(15, 3, new Insets(4, 4, 4, 4), 2, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.customerclaim"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCustomerClaim = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        this.iCustomerClaimText = jTextField15 = new JTextField();
        jTextField15.setEditable(false);
        jPanel2.add((Component)jTextField15, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iInPayment = sSTableComboBox2;
        jPanel2.add(sSTableComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox3 = new SSTableComboBox();
        this.iOutPayment = sSTableComboBox3;
        jPanel2.add(sSTableComboBox3, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox4 = new SSTableComboBox();
        this.iCash = sSTableComboBox4;
        jPanel2.add(sSTableComboBox4, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox5 = new SSTableComboBox();
        this.iSupplierDebt = sSTableComboBox5;
        jPanel2.add(sSTableComboBox5, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox6 = new SSTableComboBox();
        this.iTax1 = sSTableComboBox6;
        jPanel2.add(sSTableComboBox6, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox7 = new SSTableComboBox();
        this.iTax2 = sSTableComboBox7;
        jPanel2.add(sSTableComboBox7, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox8 = new SSTableComboBox();
        this.iTax3 = sSTableComboBox8;
        jPanel2.add(sSTableComboBox8, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox9 = new SSTableComboBox();
        this.iSales = sSTableComboBox9;
        jPanel2.add(sSTableComboBox9, new GridConstraints(8, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox10 = new SSTableComboBox();
        this.iPurchases = sSTableComboBox10;
        jPanel2.add(sSTableComboBox10, new GridConstraints(9, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox11 = new SSTableComboBox();
        this.iCurrencyProfit = sSTableComboBox11;
        jPanel2.add(sSTableComboBox11, new GridConstraints(10, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox12 = new SSTableComboBox();
        this.iCurrencyLoss = sSTableComboBox12;
        jPanel2.add(sSTableComboBox12, new GridConstraints(11, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        SSTableComboBox sSTableComboBox13 = new SSTableComboBox();
        this.iRounding = sSTableComboBox13;
        jPanel2.add(sSTableComboBox13, new GridConstraints(12, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        this.iInPaymentText = jTextField14 = new JTextField();
        jTextField14.setEditable(false);
        jPanel2.add((Component)jTextField14, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iOutPaymentText = jTextField13 = new JTextField();
        jTextField13.setEditable(false);
        jPanel2.add((Component)jTextField13, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iCashText = jTextField12 = new JTextField();
        jTextField12.setEditable(false);
        jPanel2.add((Component)jTextField12, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iSupplierDebtText = jTextField11 = new JTextField();
        jTextField11.setEditable(false);
        jPanel2.add((Component)jTextField11, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iTax1Text = jTextField10 = new JTextField();
        jTextField10.setEditable(false);
        jPanel2.add((Component)jTextField10, new GridConstraints(5, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iTax2Text = jTextField9 = new JTextField();
        jTextField9.setEditable(false);
        jPanel2.add((Component)jTextField9, new GridConstraints(6, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iTax3Text = jTextField8 = new JTextField();
        jTextField8.setEditable(false);
        jPanel2.add((Component)jTextField8, new GridConstraints(7, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iSalesText = jTextField7 = new JTextField();
        jTextField7.setEditable(false);
        jPanel2.add((Component)jTextField7, new GridConstraints(8, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iPurchasesText = jTextField6 = new JTextField();
        jTextField6.setEditable(false);
        jPanel2.add((Component)jTextField6, new GridConstraints(9, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iCurrencyProfitText = jTextField5 = new JTextField();
        jTextField5.setEditable(false);
        jPanel2.add((Component)jTextField5, new GridConstraints(10, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iCurrencyLossText = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        jPanel2.add((Component)jTextField4, new GridConstraints(11, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iRoundingText = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel2.add((Component)jTextField3, new GridConstraints(12, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        SSTableComboBox sSTableComboBox14 = new SSTableComboBox();
        this.iInterestProfit = sSTableComboBox14;
        jPanel2.add(sSTableComboBox14, new GridConstraints(13, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        this.iInterestProfitText = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(13, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        SSTableComboBox sSTableComboBox15 = new SSTableComboBox();
        this.iIncommingTax = sSTableComboBox15;
        jPanel2.add(sSTableComboBox15, new GridConstraints(14, 1, 1, 1, 8, 0, 3, 3, new Dimension(80, -1), new Dimension(80, -1), new Dimension(80, -1)));
        this.iIncommingTaxText = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(14, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.inpayment"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.outpayment"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.cash"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.supplierdebt"));
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.tax1"));
        jPanel2.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.tax2"));
        jPanel2.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.tax3"));
        jPanel2.add((Component)jLabel8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.sales"));
        jPanel2.add((Component)jLabel9, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.purchases"));
        jPanel2.add((Component)jLabel10, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.currencyprofit"));
        jPanel2.add((Component)jLabel11, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.currencyloss"));
        jPanel2.add((Component)jLabel12, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.rounding"));
        jPanel2.add((Component)jLabel13, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.interestprofit"));
        jPanel2.add((Component)jLabel14, new GridConstraints(13, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("companyframe.defaultaccount.incommingtax"));
        jPanel2.add((Component)jLabel15, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class SelectionListener
    implements SSSelectionListener<SSAccount> {
        private SSDefaultAccount iDefaultAccount;

        public SelectionListener(SSDefaultAccount iDefaultAccount) {
            this.iDefaultAccount = iDefaultAccount;
        }

        @Override
        public void selected(SSAccount selected) {
            JTextField iTextField = (JTextField)SSDefaultAccountPanel.this.iTextFields.get(this.iDefaultAccount);
            if (selected != null) {
                SSDefaultAccountPanel.this.iDefaultAccounts.put(this.iDefaultAccount, selected.getNumber());
            }
            if (iTextField != null) {
                if (selected != null) {
                    iTextField.setText(selected.getDescription());
                } else {
                    iTextField.setText("");
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel.SelectionListener");
            sb.append("{iDefaultAccount=").append(this.iDefaultAccount);
            sb.append('}');
            return sb.toString();
        }
    }
}

