/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.company.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.util.SSMailServer;
import se.swedsoft.bookkeeping.data.util.SSMailServerException;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSMailServerDialog
extends SSDialog {
    private JPanel contentPane;
    private JTextField addressText;
    private JLabel addressLabel;
    private JCheckBox authCheckbox;
    private JLabel userNameLabel;
    private JTextField usernameText;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JLabel portLabel;
    private JTextField portField;
    private SSButtonPanel iButtonPanel;
    private JDialog iParent;
    private SSMailServer iMailServer;
    private boolean shouldSave;

    public SSMailServerDialog(JDialog iParent) {
        super(iParent, SSBundle.getBundle().getString("companypanel.basic.server_dialog_title"));
        this.iParent = iParent;
        this.$$$setupUI$$$();
        this.setLocationRelativeTo(iParent);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.iButtonPanel.getOkButton());
        this.iButtonPanel.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMailServerDialog.this.onOK();
            }
        });
        this.iButtonPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMailServerDialog.this.onCancel();
            }
        });
        this.authCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SSMailServerDialog.this.onNewAuthState(e.getStateChange() == 1);
            }
        });
        this.pack();
    }

    private void loadFieldsFromServer(SSMailServer server) {
        this.addressText.setText(server.getURI().getHost());
        this.authCheckbox.setSelected(server.isAuth());
        this.usernameText.setText(server.getUsername());
        this.passwordField.setText(SSMail.crypter.decrypt(server.getPassword()));
        this.portField.setText(Integer.toString(server.getURI().getPort()));
        this.onNewAuthState(server.isAuth());
    }

    private SSMailServer getServerFromFields() throws SSMailServerException {
        int port;
        try {
            port = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException e) {
            throw new SSMailServerException("parse error for portField", "mailserver.number_error");
        }
        return SSMailServer.makeIfValid("NONAME", this.addressText.getText(), port, this.authCheckbox.isSelected(), this.usernameText.getText(), SSMail.crypter.encrypt(String.valueOf(this.passwordField.getPassword())));
    }

    public SSMailServer showServerQuery(SSMailServer server) {
        if (server != null) {
            this.loadFieldsFromServer(server);
        }
        this.iMailServer = server;
        this.setVisible();
        return this.iMailServer;
    }

    private void onNewAuthState(boolean isEnabled) {
        this.passwordField.setEnabled(isEnabled);
        this.passwordLabel.setEnabled(isEnabled);
        this.usernameText.setEnabled(isEnabled);
        this.userNameLabel.setEnabled(isEnabled);
    }

    private void onOK() {
        boolean shouldDiscard = true;
        try {
            this.iMailServer = this.getServerFromFields();
        }
        catch (SSMailServerException exc) {
            shouldDiscard = this.queryShouldDiscard(SSBundle.getBundle().getString(exc.getResourceName()));
        }
        if (shouldDiscard) {
            this.closeDialog(0);
        }
    }

    private boolean queryShouldDiscard(String message) {
        int res = JOptionPane.showConfirmDialog(this, message + "\n\n" + SSBundle.getBundle().getString("companypanel.basic.server_error_message"), SSBundle.getBundle().getString("companypanel.basic.server_error_title"), 2, 0);
        return res == 0;
    }

    private void onCancel() {
        this.closeDialog(2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.company.panel.SSMailServerDialog");
        sb.append("{addressLabel=").append(this.addressLabel);
        sb.append(", addressText=").append(this.addressText);
        sb.append(", authCheckbox=").append(this.authCheckbox);
        sb.append(", contentPane=").append(this.contentPane);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iMailServer=").append(this.iMailServer);
        sb.append(", iParent=").append(this.iParent);
        sb.append(", passwordField=").append(this.passwordField);
        sb.append(", passwordLabel=").append(this.passwordLabel);
        sb.append(", portField=").append(this.portField);
        sb.append(", portLabel=").append(this.portLabel);
        sb.append(", shouldSave=").append(this.shouldSave);
        sb.append(", userNameLabel=").append(this.userNameLabel);
        sb.append(", usernameText=").append(this.usernameText);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JTextField jTextField;
        JLabel jLabel;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JCheckBox jCheckBox;
        JTextField jTextField3;
        JLabel jLabel4;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(5, 5, 5, 5), -1, -1, false, true));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, new Color(-16777216)));
        this.addressLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("companypanel.basic.server_address"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 20), null, null));
        this.addressText = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 1, 1, 6, 0, null, new Dimension(150, -1), null));
        this.authCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("companypanel.basic.use_auth"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.userNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("companypanel.basic.username"));
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.usernameText = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.passwordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("companypanel.basic.password"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.passwordField = jPasswordField = new JPasswordField();
        jPasswordField.setEchoChar('\u25cf');
        jPanel2.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.portLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("companypanel.basic.server_port"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.portField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        JComponent jComponent = sSButtonPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 4, 0, 7, 1, null, null, null));
        jLabel3.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

