/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.creditinvoice;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.calc.math.SSTenderMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.creditinvoice.dialog.SSSelectInvoiceDialog;
import se.swedsoft.bookkeeping.gui.creditinvoice.panel.SSCreditInvoicePanel;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSCreditInvoiceDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSCreditInvoiceDialog() {
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSCreditInvoice iInvoice, final AbstractTableModel pModel) {
        final String lockString = "creditinvoice" + iInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "creditinvoiceframe.creditinvoiceopen", iInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("creditinvoiceframe.edit.title"));
        final SSCreditInvoicePanel iPanel = new SSCreditInvoicePanel(iDialog);
        iPanel.setCreditInvoice(new SSCreditInvoice(iInvoice));
        iPanel.setSavecustomerandproductsSelected(false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iInvoice = iPanel.getCreditInvoice();
                SSDB.getInstance().updateCreditInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSOrderMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "creditinvoiceframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(SSMainFrame iMainFrame, AbstractTableModel pModel) {
        SSInvoice iCrediting = SSSelectInvoiceDialog.showDialog(iMainFrame);
        if (iCrediting == null) {
            new SSErrorDialog(iMainFrame, "creditinvoiceframe.creditinvoicenoinvoice");
            return;
        }
        if (iCrediting.getNumber() == -1) {
            return;
        }
        SSCreditInvoiceDialog.newDialog(iMainFrame, iCrediting, pModel);
    }

    public static void newDialog(final SSMainFrame iMainFrame, SSInvoice iCrediting, final AbstractTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("creditinvoiceframe.new.title"));
        final SSCreditInvoicePanel iPanel = new SSCreditInvoicePanel(iDialog);
        SSCreditInvoice iCreditInvoice = new SSCreditInvoice(iCrediting);
        iCreditInvoice.setNumber(null);
        iPanel.setCreditInvoice(iCreditInvoice);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iInvoice = iPanel.getCreditInvoice();
                SSDB.getInstance().addCreditInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSTenderMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "creditinvoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSCreditInvoice iCreditInvoice, final AbstractTableModel pModel) {
        String lockString = "creditinvoice" + iCreditInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "creditinvoiceframe.creditinvoiceopen", iCreditInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("creditinvoiceframe.copy.title"));
        final SSCreditInvoicePanel iPanel = new SSCreditInvoicePanel(iDialog);
        SSCreditInvoice iNew = new SSCreditInvoice(iCreditInvoice);
        iNew.setDate(new Date());
        iNew.setNumber(null);
        iNew.setEntered(false);
        iNew.setPrinted(false);
        if (iCreditInvoice.getCrediting() == null) {
            new SSErrorDialog(iMainFrame, "creditinvoiceframe.creditinvoicenoinvoice");
            return;
        }
        iPanel.setCreditInvoice(iNew);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iInvoice = iPanel.getCreditInvoice();
                SSDB.getInstance().addCreditInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSTenderMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                if (SSInvoiceFrame.getInstance() != null) {
                    SSInvoiceFrame.getInstance().updateFrame();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "creditinvoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

