/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.creditinvoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceDialog;
import se.swedsoft.bookkeeping.gui.creditinvoice.panel.SSCreditInvoiceSearchPanel;
import se.swedsoft.bookkeeping.gui.creditinvoice.util.SSCreditInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSCreditInvoiceFrame
extends SSDefaultTableFrame {
    private static SSCreditInvoiceFrame cInstance;
    private SSTable iTable;
    private SSCreditInvoiceTableModel iModel;
    private SSCreditInvoiceSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSCreditInvoiceFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSCreditInvoiceFrame getInstance() {
        return cInstance;
    }

    private SSCreditInvoiceFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("creditinvoiceframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "creditinvoiceframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoiceDialog.newDialog(SSCreditInvoiceFrame.this.getMainFrame(), SSCreditInvoiceFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_EDITITEM", "creditinvoiceframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iSelected = (SSCreditInvoice)SSCreditInvoiceFrame.this.iModel.getSelectedRow(SSCreditInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSCreditInvoiceFrame.this.getCreditInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSCreditInvoiceDialog.editDialog(SSCreditInvoiceFrame.this.getMainFrame(), iSelected, SSCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCreditInvoiceFrame.this.getMainFrame(), "creditinvoiceframe.creditinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "creditinvoiceframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iSelected = (SSCreditInvoice)SSCreditInvoiceFrame.this.iModel.getSelectedRow(SSCreditInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSCreditInvoiceFrame.this.getCreditInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSCreditInvoiceDialog.copyDialog(SSCreditInvoiceFrame.this.getMainFrame(), iSelected, SSCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCreditInvoiceFrame.this.getMainFrame(), "creditinvoiceframe.creditinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "creditinvoiceframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSCreditInvoiceFrame.this.iTable.getSelectedRows();
                List toDelete = SSCreditInvoiceFrame.this.iModel.getObjects(selected);
                SSCreditInvoiceFrame.this.deleteSelectedInvoice(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_PRINT", "creditinvoiceframe.printbutton");
        JMenuItem iMenuItem = iButton2.add("creditinvoiceframe.print.creditinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSCreditInvoiceFrame.this.iModel.getSelectedRows(SSCreditInvoiceFrame.this.iTable);
                if (!(iSelected = SSCreditInvoiceFrame.this.getCreditInvoices(iSelected)).isEmpty()) {
                    SSReportFactory.CreditInvoiceReport(SSCreditInvoiceFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iButton2.add("creditinvoiceframe.print.emailcreditinvoicereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iSelected = (SSCreditInvoice)SSCreditInvoiceFrame.this.iModel.getSelectedRow(SSCreditInvoiceFrame.this.iTable);
                if ((iSelected = SSCreditInvoiceFrame.this.getCreditInvoice(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getCustomer())) {
                    return;
                }
                SSReportFactory.EmailCreditInvoiceReport(SSCreditInvoiceFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iButton2.addSeparator();
        iButton2.add("creditinvoiceframe.print.creditinvoicelist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.CreditInvoiceListReport(SSCreditInvoiceFrame.this.getMainFrame());
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSCreditInvoiceTableModel();
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_PRINTED);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_CUSTOMER_NR);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_CUSTOMER_NAME);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_NET_SUM);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_TOTAL_SUM);
        this.iModel.addColumn(SSCreditInvoiceTableModel.COLUMN_CREDITING);
        this.iTable = new SSTable();
        this.iTable.setAutoResizeMode(0);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoice iSelected = (SSCreditInvoice)SSCreditInvoiceFrame.this.iModel.getSelectedRow(SSCreditInvoiceFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSCreditInvoiceFrame.this.getCreditInvoice(iSelected);
                if (iSelected != null) {
                    SSCreditInvoiceDialog.editDialog(SSCreditInvoiceFrame.this.getMainFrame(), iSelected, SSCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCreditInvoiceFrame.this.getMainFrame(), "creditinvoiceframe.creditinvoicegone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSCreditInvoiceSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSCreditInvoiceTableModel getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelectedInvoice(List<SSCreditInvoice> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "creditinvoiceframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSCreditInvoice iCreditInvoice : delete) {
                if (SSPostLock.isLocked("creditinvoice" + iCreditInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "creditinvoiceframe.creditinvoiceopen", iCreditInvoice.getNumber());
                    continue;
                }
                if (SSInvoiceMath.iSaldoMap.containsKey(iCreditInvoice.getCreditingNr())) {
                    SSInvoiceMath.iSaldoMap.put(iCreditInvoice.getCreditingNr(), SSInvoiceMath.iSaldoMap.get(iCreditInvoice.getCreditingNr()).add(SSCreditInvoiceMath.getTotalSum(iCreditInvoice)));
                }
                SSDB.getInstance().deleteCreditInvoice(iCreditInvoice);
            }
        }
    }

    private SSCreditInvoice getCreditInvoice(SSCreditInvoice iCreditInvoice) {
        return SSDB.getInstance().getCreditInvoice(iCreditInvoice);
    }

    private List<SSCreditInvoice> getCreditInvoices(List<SSCreditInvoice> iCreditInvoices) {
        return SSDB.getInstance().getCreditInvoices(iCreditInvoices);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

