/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.customer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.customer.SSCustomerDialog;
import se.swedsoft.bookkeeping.gui.customer.panel.SSCustomerSearchPanel;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerTableModel;
import se.swedsoft.bookkeeping.gui.exportbgcadmission.SSExportBGCAdmissionDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSDefaultFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSXMLFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.excel.SSCustomerExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSCustomerImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.report.SSCustomerListPrinter;
import se.swedsoft.bookkeeping.print.report.SSCustomerRevenuePrinter;

public class SSCustomerFrame
extends SSDefaultTableFrame {
    private static SSCustomerFrame cInstance;
    private SSTable iTable;
    private SSCustomerTableModel iModel;
    private SSCustomerSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSCustomerFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSCustomerFrame getInstance() {
        return cInstance;
    }

    private SSCustomerFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("customerframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "customerframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomerDialog.newDialog(SSCustomerFrame.this.getMainFrame(), SSCustomerFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "customerframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomer iSelected = (SSCustomer)SSCustomerFrame.this.iModel.getSelectedRow(SSCustomerFrame.this.iTable);
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSCustomerFrame.this.getCustomer(iSelected);
                }
                if (iSelected != null) {
                    SSCustomerDialog.editDialog(SSCustomerFrame.this.getMainFrame(), iSelected, SSCustomerFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCustomerFrame.this.getMainFrame(), "customerframe.customergone", iNumber);
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_COPYITEM", "customerframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomer iSelected = (SSCustomer)SSCustomerFrame.this.iModel.getSelectedRow(SSCustomerFrame.this.iTable);
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSCustomerFrame.this.getCustomer(iSelected);
                }
                if (iSelected != null) {
                    SSCustomerDialog.copyDialog(SSCustomerFrame.this.getMainFrame(), iSelected, SSCustomerFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCustomerFrame.this.getMainFrame(), "customerframe.customergone", iNumber);
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "customerframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSCustomerFrame.this.iTable.getSelectedRows();
                List toDelete = SSCustomerFrame.this.iModel.getObjects(selected);
                SSCustomerFrame.this.deleteSelectedCustomers(toDelete);
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_IMPORT", "customerframe.importbutton");
        iButton2.add("customerframe.import.excel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                if (iFilechooser.showOpenDialog(SSCustomerFrame.this.getMainFrame()) == 0) {
                    final SSCustomerImporter iImporter = new SSCustomerImporter(iFilechooser.getSelectedFile());
                    try {
                        SSInitDialog.runProgress(SSCustomerFrame.this.getMainFrame(), "Importerar kunder", new Runnable(){

                            @Override
                            public void run() {
                                iImporter.Import();
                            }
                        });
                    }
                    catch (SSImportException ex) {
                        SSErrorDialog.showDialog(SSCustomerFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSCustomerFrame.this.iModel.fireTableDataChanged();
                }
            }
        });
        iButton2.add("customerframe.import.xml", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                iFilechooser.setSelectedFile(new File("Kundlista.xml"));
                if (iFilechooser.showOpenDialog(SSCustomerFrame.this.getMainFrame()) == 0) {
                    final SSCustomerImporter iImporter = new SSCustomerImporter(iFilechooser.getSelectedFile());
                    try {
                        SSInitDialog.runProgress(SSCustomerFrame.this.getMainFrame(), "Importerar kunder", new Runnable(){

                            @Override
                            public void run() {
                                iImporter.doImport();
                            }
                        });
                    }
                    catch (SSImportException e1) {
                        SSErrorDialog.showDialog(SSCustomerFrame.this.getMainFrame(), "", e1.getLocalizedMessage());
                    }
                }
            }
        });
        iButton2.add("customerframe.import.ebutik", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSDefaultFileChooser iFileChooser = new SSDefaultFileChooser();
                if (iFileChooser.showOpenDialog(SSCustomerFrame.this.getMainFrame()) == 0) {
                    final SSCustomerImporter iImporter = new SSCustomerImporter(iFileChooser.getSelectedFile());
                    try {
                        SSInitDialog.runProgress(SSCustomerFrame.this.getMainFrame(), "Importerar kunder", new Runnable(){

                            @Override
                            public void run() {
                                iImporter.doEbutikImport();
                            }
                        });
                    }
                    catch (SSImportException e1) {
                        SSErrorDialog.showDialog(SSCustomerFrame.this.getMainFrame(), "", e1.getLocalizedMessage());
                    }
                }
            }
        });
        iToolBar.add(iButton2);
        iButton2 = new SSMenuButton("ICON_EXPORT", "customerframe.exportbutton");
        iButton2.add("customerframe.export.excel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iItems;
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                List iSelected = SSCustomerFrame.this.iModel.getSelectedRows(SSCustomerFrame.this.iTable);
                if (iSelected != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSCustomerFrame.this.getMainFrame(), 1, SSCustomerFrame.this.getTitle(), SSBundle.getBundle().getString("customerframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = iSelected;
                            iItems = SSCustomerFrame.this.getCustomers(iItems);
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getCustomers();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getCustomers();
                }
                iFilechooser.setSelectedFile(new File("Kundlista.xls"));
                if (iFilechooser.showSaveDialog(SSCustomerFrame.this.getMainFrame()) == 0) {
                    SSCustomerExporter iExporter = new SSCustomerExporter(iFilechooser.getSelectedFile(), iItems);
                    try {
                        iExporter.export();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSCustomerFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSCustomerFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        iButton2.add("customerframe.export.xml", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SSCustomer> iItems;
                List<SSCustomer> iSelected = SSCustomerFrame.this.iModel.getSelectedRows(SSCustomerFrame.this.iTable);
                if ((iSelected = SSCustomerFrame.this.getCustomers(iSelected)) != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSCustomerFrame.this.getMainFrame(), 1, SSCustomerFrame.this.getTitle(), SSBundle.getBundle().getString("customerframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = iSelected;
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getCustomers();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getCustomers();
                }
                if (!iItems.isEmpty()) {
                    SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                    iFilechooser.setSelectedFile(new File("Kundlista.xml"));
                    if (iFilechooser.showSaveDialog(SSCustomerFrame.this.getMainFrame()) == 0) {
                        SSCustomerExporter iExporter = new SSCustomerExporter(iFilechooser.getSelectedFile(), iItems);
                        iExporter.doXMLExport();
                    }
                }
            }
        });
        iToolBar.add(iButton2);
        iToolBar.addSeparator();
        iButton2 = new SSMenuButton("ICON_PRINT", "customerframe.printbutton");
        iButton2.add("customerframe.print.customerrevenue", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomerFrame.this.CustomerRevenueReport();
            }
        });
        iButton2.add("customerframe.print.customerlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomerFrame.this.CustomerListReport();
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    public void exportBGCAdmissions() {
        String lockString = "bgcadmission" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(this.getMainFrame(), "customerframe.bgcadmission");
            return;
        }
        List<SSCustomer> iSelected = this.iModel.getSelectedRows(this.iTable);
        if ((iSelected = this.getCustomers(iSelected)).isEmpty()) {
            SSPostLock.removeLock(lockString);
            return;
        }
        LinkedList iFiltered = new LinkedList();
        for (SSCustomer sSCustomer : iSelected) {
        }
        SSExportBGCAdmissionDialog iDialog = new SSExportBGCAdmissionDialog(this.getMainFrame(), iSelected);
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(this.getMainFrame());
        iDialog.showDialog();
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSCustomerTableModel();
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_NAME);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_YOUR_CONTACT);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_REGISTRATION_NUMBER);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_PHONE);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_CUSTOMER_CLAIM);
        this.iModel.addColumn(SSCustomerTableModel.COLUMN_CREDIT_LIMIT);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomer iSelected = (SSCustomer)SSCustomerFrame.this.iModel.getSelectedRow(SSCustomerFrame.this.iTable);
                String iNumber = null;
                if (iSelected == null) {
                    return;
                }
                iNumber = iSelected.getNumber();
                iSelected = SSCustomerFrame.this.getCustomer(iSelected);
                if (iSelected != null) {
                    SSCustomerDialog.editDialog(SSCustomerFrame.this.getMainFrame(), iSelected, SSCustomerFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSCustomerFrame.this.getMainFrame(), "customerframe.customergone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSCustomerSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    public SSCustomerTableModel getModel() {
        return this.iModel;
    }

    private void deleteSelectedCustomers(List<SSCustomer> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "customerframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSCustomer iCustomer : delete) {
                if (SSPostLock.isLocked("customer" + iCustomer.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "customerframe.customeropen", iCustomer.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteCustomer(iCustomer);
            }
        }
    }

    private void CustomerListReport() {
        SSCustomerListPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "customerframe.printallorselected");
            switch (iOption) {
                case 0: {
                    List<SSCustomer> iCustomers = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iCustomers = this.getCustomers(iCustomers);
                    iPrinter = new SSCustomerListPrinter(iCustomers);
                    break;
                }
                case 1: {
                    List<SSCustomer> iCustomers = this.iModel.getObjects();
                    iCustomers = this.getCustomers(iCustomers);
                    iPrinter = new SSCustomerListPrinter(iCustomers);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            List<SSCustomer> iCustomers = this.iModel.getObjects(this.iTable.getSelectedRows());
            iCustomers = this.getCustomers(iCustomers);
            iPrinter = new SSCustomerListPrinter(iCustomers);
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSCustomerFrame.this.getMainFrame());
            }
        });
    }

    private void CustomerRevenueReport() {
        List<SSCustomer> iCustomers;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "customerframe.printallorselected");
            switch (iOption) {
                case 0: {
                    iCustomers = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iCustomers = this.getCustomers(iCustomers);
                    break;
                }
                case 1: {
                    iCustomers = SSDB.getInstance().getCustomers();
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iCustomers = SSDB.getInstance().getCustomers();
        }
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(this.getMainFrame(), SSBundle.getBundle().getString("customerrevenue.perioddialog.title"));
        if (SSDB.getInstance().getCurrentYear() != null) {
            iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
            iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(this.getMainFrame());
        if (iDialog.showDialog() != 0) {
            return;
        }
        Date iFrom = iDialog.getFrom();
        Date iTo = iDialog.getTo();
        final SSCustomerRevenuePrinter iPrinter = new SSCustomerRevenuePrinter(iCustomers, iFrom, iTo);
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSCustomerFrame.this.getMainFrame());
            }
        });
    }

    private SSCustomer getCustomer(SSCustomer iCustomer) {
        return SSDB.getInstance().getCustomer(iCustomer);
    }

    private List<SSCustomer> getCustomers(List<SSCustomer> iCustomers) {
        return SSDB.getInstance().getCustomers(iCustomers);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getCustomers());
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iSearchPanel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.customer.SSCustomerFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

