/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.inpayment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentDialog;
import se.swedsoft.bookkeeping.gui.inpayment.panel.SSInpaymentSearchPanel;
import se.swedsoft.bookkeeping.gui.inpayment.util.SSInpaymentTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSInpaymentFrame
extends SSDefaultTableFrame {
    private static SSInpaymentFrame cInstance;
    private SSTable iTable;
    private SSInpaymentTableModel iModel;
    private SSInpaymentSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSInpaymentFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSInpaymentFrame getInstance() {
        return cInstance;
    }

    private SSInpaymentFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("inpaymentframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "inpaymentframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInpaymentDialog.newDialog(SSInpaymentFrame.this.getMainFrame(), SSInpaymentFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "inpaymentframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInpayment iSelected = (SSInpayment)SSInpaymentFrame.this.iModel.getSelectedRow(SSInpaymentFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSInpaymentFrame.this.getInpayment(iSelected);
                }
                if (iSelected != null) {
                    SSInpaymentDialog.editDialog(SSInpaymentFrame.this.getMainFrame(), iSelected, SSInpaymentFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInpaymentFrame.this.getMainFrame(), "inpaymentframe.inpaymentgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "inpaymentframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSInpaymentFrame.this.iTable.getSelectedRows();
                List toDelete = SSInpaymentFrame.this.iModel.getObjects(selected);
                SSInpaymentFrame.this.deleteSelectedInpayment(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "inpaymentframe.printbutton");
        iMenuButton.add("inpaymentframe.print.inpaymentlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.InpaymentList(SSInpaymentFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSInpaymentTableModel();
        this.iTable = new SSTable();
        this.iTable.setModel(this.iModel);
        SSInpaymentTableModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInpayment iSelected = (SSInpayment)SSInpaymentFrame.this.iModel.getSelectedRow(SSInpaymentFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSInpaymentFrame.this.getInpayment(iSelected);
                if (iSelected != null) {
                    SSInpaymentDialog.editDialog(SSInpaymentFrame.this.getMainFrame(), iSelected, SSInpaymentFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInpaymentFrame.this.getMainFrame(), "inpaymentframe.inpaymentgone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSInpaymentSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSDefaultTableModel<SSInpayment> getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelectedInpayment(List<SSInpayment> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "inpaymentframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSInpayment iInpayment : delete) {
                if (SSPostLock.isLocked("inpayment" + iInpayment.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "inpaymentframe.inpaymentopen", iInpayment.getNumber());
                    continue;
                }
                for (SSInpaymentRow iRow : iInpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                }
                SSDB.getInstance().deleteInpayment(iInpayment);
            }
        }
    }

    private SSInpayment getInpayment(SSInpayment iInpayment) {
        return SSDB.getInstance().getInpayment(iInpayment);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

