/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.inpayment.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.inpayment.util.SSInpaymentRowTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSInvoiceCellEditor;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld;

public class SSInpaymentPanel {
    private SSInpayment iInpayment;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private SSTable iTable;
    private JFormattedTextField iNumber;
    private SSDateChooser iDate;
    private JTextField iText;
    private JCheckBox iEntered;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSTable iVoucherTable;
    private JButton iRefreshVoucher;
    private SSBigDecimalTextField iSum;
    private SSTable iDifferenceTable;
    private SSInpaymentRowTableModel iModel;
    private SSVoucherRowTableModelOld iVoucherTableModel;
    private SSVoucherRowTableModelOld iDifferenceTableModel;

    public SSInpaymentPanel(SSDialog iDialog) {
        this.$$$setupUI$$$();
        this.iModel = new SSInpaymentRowTableModel();
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_INVOICE, true);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_INVOICE_CURRENCYRATE);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_VALUE, true);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_CURRENCYRATE, true);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_PAYED, true);
        this.iModel.addColumn(SSInpaymentRowTableModel.COLUMN_CURRENCYRATEDIFFERENCE);
        this.iModel.setupTable(this.iTable);
        this.iTable.setDefaultEditor(SSInvoice.class, new SSInvoiceCellEditor(SSInvoiceMath.getNonPayedOrCreditedInvoices()));
        this.iTable.setColorReadOnly(true);
        this.iTable.setSingleSelect();
        this.iVoucherTableModel = new SSVoucherRowTableModelOld(false, true){

            @Override
            public int getColumnCount() {
                return 4;
            }
        };
        this.iVoucherTable.setModel(this.iVoucherTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iVoucherTable, this.iVoucherTableModel);
        this.iDifferenceTableModel = new SSVoucherRowTableModelOld(false, false){

            @Override
            public int getColumnCount() {
                return 4;
            }
        };
        this.iDifferenceTable.setModel(this.iDifferenceTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iDifferenceTable, this.iDifferenceTableModel);
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 2) {
                    iPosition.x = 3;
                } else if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSInpaymentPanel.this.iModel.getRowCount()) {
                        SSInpaymentPanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSInpaymentRow iSelected = (SSInpaymentRow)SSInpaymentPanel.this.iModel.getSelectedRow(SSInpaymentPanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "inpaymentframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSInpaymentPanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iDifferenceTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSVoucherRow iSelected = (SSVoucherRow)SSInpaymentPanel.this.iDifferenceTableModel.getSelectedRow(SSInpaymentPanel.this.iDifferenceTable);
                if (iSelected != null) {
                    SSInpaymentPanel.this.iDifferenceTableModel.deleteRow(iSelected);
                }
                SSInpaymentPanel.this.iDifferenceTableModel.fireTableDataChanged();
                return iPosition;
            }
        };
        new SSTraversalAction(this.iDifferenceTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x == 0) {
                    iPosition.x += 2;
                } else if (iPosition.x < 3) {
                    ++iPosition.x;
                } else if (iPosition.x == 3) {
                    SSVoucherRow iVoucherRow = SSInpaymentPanel.this.iDifferenceTableModel.getObject(iPosition.y);
                    ++iPosition.y;
                    iPosition.x = 0;
                    SSInpaymentPanel.this.setDifferenceToZero(iVoucherRow);
                } else {
                    ++iPosition.y;
                    iPosition.x = 0;
                }
                return iPosition;
            }
        };
        this.iRefreshVoucher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iVoucher = SSInpaymentPanel.this.iInpayment.generateVoucher();
                SSInpaymentPanel.this.iVoucherTableModel.setVoucher(iVoucher);
            }
        });
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSInpaymentPanel.this.updateSumFields();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSInpaymentPanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInpaymentPanel.this.iText.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInpaymentPanel.this.iTable.requestFocusInWindow();
                            SSInpaymentPanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInpaymentPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInpaymentPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }

    private void setDifferenceToZero(SSVoucherRow iVoucherRow) {
        BigDecimal iDebet = iVoucherRow.getDebet();
        BigDecimal iCredit = iVoucherRow.getCredit();
        if (iDebet == null && iCredit == null) {
            BigDecimal iDifference = this.getDifference();
            if (iDifference.signum() < 0) {
                iVoucherRow.setDebet(iDifference.abs());
            } else {
                iVoucherRow.setCredit(iDifference.abs());
            }
        }
        this.iDifferenceTableModel.fireTableDataChanged();
    }

    private BigDecimal getDifference() {
        BigDecimal iCreditSum = new BigDecimal(0);
        BigDecimal iDebetSum = new BigDecimal(0);
        for (SSVoucherRow iRow : this.iDifferenceTableModel.getObjects()) {
            if (iRow.getDebet() != null) {
                iDebetSum = iDebetSum.add(iRow.getDebet());
                continue;
            }
            if (iRow.getCredit() == null) continue;
            iCreditSum = iCreditSum.add(iRow.getCredit());
        }
        return iDebetSum.subtract(iCreditSum);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public SSInpayment getInpayment() {
        this.iInpayment.setDate(this.iDate.getDate());
        this.iInpayment.setText(this.iText.getText());
        this.iInpayment.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iInpayment.setEntered(this.iEntered.isSelected());
        this.iInpayment.generateVoucher();
        return this.iInpayment;
    }

    public void setInpayment(SSInpayment pInpayment) {
        this.iInpayment = pInpayment;
        this.iNumber.setValue(this.iInpayment.getNumber());
        this.iDate.setDate(this.iInpayment.getDate());
        this.iText.setText(this.iInpayment.getText());
        this.iEntered.setSelected(this.iInpayment.isEntered());
        this.iDefaultAccounts.setDefaultAccounts(this.iInpayment.getDefaultAccounts());
        this.iVoucherTableModel.setVoucher(this.iInpayment.getVoucher());
        this.iDifferenceTableModel.setVoucher(this.iInpayment.getDifference());
        this.iModel.setObjects(this.iInpayment.getRows());
        this.updateSumFields();
    }

    private void updateSumFields() {
        BigDecimal iSum = SSInpaymentMath.getSum(this.iInpayment);
        this.iSum.setValue(iSum);
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iText.removeAll();
        this.iText = null;
        this.iEntered.removeAll();
        this.iEntered = null;
        this.iVoucherTable.dispose();
        this.iVoucherTable = null;
        for (ActionListener iActionListener : iActionListeners = this.iRefreshVoucher.getActionListeners()) {
            this.iRefreshVoucher.removeActionListener(iActionListener);
        }
        this.iRefreshVoucher.removeAll();
        this.iRefreshVoucher = null;
        this.iSum = null;
        this.iDifferenceTable.dispose();
        this.iDifferenceTable = null;
        this.iModel = null;
        this.iVoucherTableModel = null;
        this.iDifferenceTableModel = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.inpayment.panel.SSInpaymentPanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDifferenceTable=").append(this.iDifferenceTable);
        sb.append(", iDifferenceTableModel=").append(this.iDifferenceTableModel);
        sb.append(", iEntered=").append(this.iEntered);
        sb.append(", iInpayment=").append(this.iInpayment);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iRefreshVoucher=").append(this.iRefreshVoucher);
        sb.append(", iSum=").append(this.iSum);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iText=").append(this.iText);
        sb.append(", iVoucherTable=").append(this.iVoucherTable);
        sb.append(", iVoucherTableModel=").append(this.iVoucherTableModel);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JButton jButton;
        SSTable sSTable;
        SSTable sSTable2;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSTable sSTable3;
        JTextField jTextField;
        SSDateChooser sSDateChooser;
        JFormattedTextField jFormattedTextField;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("inpaymentframe.panel.1"), null, jPanel2, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("inpaymentframe.date"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("inpaymentframe.text"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel3.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        this.iDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel3.add((Component)sSDateChooser, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, 20)));
        this.iText = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, 20)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("inpaymentframe.number"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable3 = new SSTable();
        jScrollPane.setViewportView(sSTable3);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 2, new Insets(0, 2, 2, 2), 2, 0, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("inpaymentframe.sum"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iSum = sSBigDecimalTextField = new SSBigDecimalTextField();
        sSBigDecimalTextField.setEditable(false);
        jPanel4.add((Component)sSBigDecimalTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 1, 3, null, new Dimension(120, -1), new Dimension(-1, 20)));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("inpaymentframe.panel.2"), null, jPanel5, null);
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel5.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("inpaymentframe.panel.3"), null, jPanel6, null);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel7.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iDifferenceTable = sSTable2 = new SSTable();
        jScrollPane2.setViewportView(sSTable2);
        JLabel jLabel5 = new JLabel();
        jLabel5.setVerticalAlignment(1);
        jLabel5.setHorizontalTextPosition(2);
        jLabel5.setHorizontalAlignment(2);
        jLabel5.setVerticalTextPosition(1);
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("inpaymentframe.difference"));
        jPanel7.add((Component)jLabel5, new GridConstraints(0, 0, 1, 3, 8, 3, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("inpaymentframe.panel.4"), null, jPanel8, null);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel9.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iVoucherTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        this.iRefreshVoucher = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("inpaymentframe.voucherrefresh"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel9.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setVerticalAlignment(1);
        jLabel6.setHorizontalTextPosition(2);
        jLabel6.setHorizontalAlignment(2);
        jLabel6.setVerticalTextPosition(1);
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("inpaymentframe.voucher"));
        jPanel9.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel8.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel8.add((Component)spacer9, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.iEntered = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("inpaymentframe.entered"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

