/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.inventory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.inventory.SSInventoryDialog;
import se.swedsoft.bookkeeping.gui.inventory.util.SSInventoryTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSInventoryFrame
extends SSDefaultTableFrame {
    private static SSInventoryFrame cInstance;
    private SSTable iTable;
    private SSInventoryTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSInventoryFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSInventoryFrame getInstance() {
        return cInstance;
    }

    private SSInventoryFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("inventortyframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "inventortyframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInventoryDialog.newDialog(SSInventoryFrame.this.getMainFrame(), SSInventoryFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "inventortyframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInventory iInventory = (SSInventory)SSInventoryFrame.this.iModel.getSelectedRow(SSInventoryFrame.this.iTable);
                Integer iNumber = null;
                if (iInventory != null) {
                    iNumber = iInventory.getNumber();
                    iInventory = SSInventoryFrame.this.getInventory(iInventory);
                }
                if (iInventory != null) {
                    SSInventoryDialog.editDialog(SSInventoryFrame.this.getMainFrame(), iInventory, SSInventoryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInventoryFrame.this.getMainFrame(), "inventoryframe.inventorygone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "inventortyframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSInventoryFrame.this.iTable.getSelectedRows();
                List toDelete = SSInventoryFrame.this.iModel.getObjects(selected);
                SSInventoryFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "inventortyframe.printbutton");
        iMenuButton.add("inventortyframe.print.list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.InventoryList(SSInventoryFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSInventoryTableModel();
        this.iModel.addColumn(SSInventoryTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSInventoryTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSInventoryTableModel.COLUMN_TEXT);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInventory iInventory = (SSInventory)SSInventoryFrame.this.iModel.getSelectedRow(SSInventoryFrame.this.iTable);
                if (iInventory == null) {
                    return;
                }
                Integer iNumber = iInventory.getNumber();
                iInventory = SSInventoryFrame.this.getInventory(iInventory);
                if (iInventory != null) {
                    SSInventoryDialog.editDialog(SSInventoryFrame.this.getMainFrame(), iInventory, SSInventoryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInventoryFrame.this.getMainFrame(), "inventoryframe.inventorygone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSInventoryTableModel getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelected(List<SSInventory> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "inventoryframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSInventory iInventory : delete) {
                if (SSPostLock.isLocked("inventory" + iInventory.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "inventoryframe.inventoryopen", iInventory.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteInventory(iInventory);
            }
        }
    }

    private SSInventory getInventory(SSInventory iInventory) {
        return SSDB.getInstance().getInventory(iInventory);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getInventories());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.inventory.SSInventoryFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

