/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.inventory.util;

import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInventoryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.model.SSEditableTableModel;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;

public class SSInventoryRowTableModel
extends SSEditableTableModel<SSInventoryRow> {
    private static SSStock iStock;
    public static SSTableColumn<SSInventoryRow> COLUMN_PRODUCT;
    public static SSTableColumn<SSInventoryRow> COLUMN_DESCRIPTION;
    public static SSTableColumn<SSInventoryRow> COLUMN_INVENTORYQUANTITY;
    public static SSTableColumn<SSInventoryRow> COLUMN_STOCKQUANTITY;
    public static SSTableColumn<SSInventoryRow> COLUMN_CHANGE;
    public static SSTableColumn<SSInventoryRow> COLUMN_WAREHOUSELOCATION;

    public SSInventoryRowTableModel(SSStock iStock) {
        SSInventoryRowTableModel.iStock = iStock;
    }

    @Override
    public Class getType() {
        return SSInventory.class;
    }

    @Override
    public SSInventoryRow newObject() {
        return new SSInventoryRow();
    }

    static {
        COLUMN_PRODUCT = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.1")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                return iRow.getProduct();
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
                SSProduct iProduct = (SSProduct)iValue;
                iRow.setProduct(iProduct);
                if (iStock == null || iProduct == null) {
                    return;
                }
                iRow.setStockQuantity(iStock.getQuantity(iProduct));
                iRow.setChange(0);
            }

            @Override
            public Class getColumnClass() {
                return SSProduct.class;
            }

            @Override
            public int getDefaultWidth() {
                return 90;
            }
        };
        COLUMN_DESCRIPTION = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.2")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                SSProduct iProduct = iRow.getProduct();
                return iProduct == null ? null : iProduct.getDescription();
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return String.class;
            }

            @Override
            public int getDefaultWidth() {
                return 250;
            }
        };
        COLUMN_INVENTORYQUANTITY = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.3")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                return iRow.getInventoryQuantity();
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
                iRow.setInventoryQuantity((Integer)iValue);
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
        COLUMN_STOCKQUANTITY = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.4")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                Integer iQuantity = iRow.getStockQuantity();
                SSProduct iProduct = iRow.getProduct();
                if (iQuantity == null && iProduct != null && iStock != null) {
                    iQuantity = iStock.getQuantity(iProduct);
                    iRow.setStockQuantity(iQuantity);
                }
                return iQuantity;
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
        COLUMN_CHANGE = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.5")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                return iRow.getChange();
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
                iRow.setChange((Integer)iValue);
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
        COLUMN_WAREHOUSELOCATION = new SSTableColumn<SSInventoryRow>(SSBundle.getBundle().getString("inventoryrowtable.column.6")){

            @Override
            public Object getValue(SSInventoryRow iRow) {
                SSProduct iProduct = iRow.getProduct();
                return iProduct == null ? "" : (iProduct.getWarehouseLocation() == null ? "" : iProduct.getWarehouseLocation());
            }

            @Override
            public void setValue(SSInventoryRow iRow, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return String.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
    }
}

