/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInterestInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public class SSInterestInvoicePanel {
    private JPanel iPanel;
    private SSButton iCancelButton;
    private SSButton iOkButton;
    private SSTable iTable;
    private JTextField iDescription;
    private SSTableComboBox<SSAccount> iAccount;
    private SSInterestInvoiceTableModel iModel;
    private JTextField iAccountText;

    public SSInterestInvoicePanel(List<SSInvoice> iRows) {
        this.$$$setupUI$$$();
        this.iModel = new SSInterestInvoiceTableModel(iRows);
        this.iTable.setModel(this.iModel);
        SSAccount iSelected = SSDB.getInstance().getCurrentCompany().getDefaultAccount(SSDB.getInstance().getCurrentAccountPlan(), SSDefaultAccount.InterestProfit);
        this.iAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iAccount.setSearchColumns(0);
        this.iAccount.setAllowCustomValues(true);
        this.iAccount.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount selected) {
                if (selected != null) {
                    SSInterestInvoicePanel.this.iAccountText.setText(selected.getDescription());
                } else {
                    SSInterestInvoicePanel.this.iAccount.setText("");
                }
            }
        });
        this.iAccount.setSelected(iSelected, true);
        SSInterestInvoiceTableModel.setupTable(this.iTable);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iOkButton.addActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iCancelButton.addActionListener(pActionListener);
    }

    public List<SSInvoice> getInterestInvoices() {
        String iDescription = this.iDescription.getText();
        SSAccount iAccount = this.iAccount.getSelected();
        return this.iModel.getInterestInvoices(iDescription, iAccount);
    }

    public static List<SSInvoice> getRows() {
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        LinkedList<SSInvoice> iRows = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            if (iInvoice.isInterestInvoiced() || iInvoice.getType() == SSInvoiceType.CASH) continue;
            BigDecimal iSaldo = SSInvoiceMath.getSaldo(iInvoice.getNumber());
            Date iLastInpayment = SSInpaymentMath.getLastInpaymentForInvoice(iInvoice);
            if (iLastInpayment == null) {
                iLastInpayment = new Date();
            }
            iLastInpayment = SSDateMath.floor(iLastInpayment);
            if (iSaldo.signum() != 0 || !iLastInpayment.after(iInvoice.getDueDate())) continue;
            iRows.add(iInvoice);
        }
        return iRows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.invoice.panel.SSInterestInvoicePanel");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iAccountText=").append(this.iAccountText);
        sb.append(", iCancelButton=").append(this.iCancelButton);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iOkButton=").append(this.iOkButton);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButton sSButton;
        SSButton sSButton2;
        SSTable sSTable;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 4, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iAccountText = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.iDescription = jTextField = new JTextField();
        jTextField.setText(ResourceBundle.getBundle("book").getString("interestinvoice.defaultdescription"));
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("interestinvoice.description"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("interestinvoice.account"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iAccount = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(80, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 3, new Insets(0, 4, 4, 4), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.iCancelButton = sSButton2 = new SSButton();
        this.$$$loadButtonText$$$(sSButton2, ResourceBundle.getBundle("book").getString("okcancelpanel.cancelbutton"));
        jPanel3.add((Component)sSButton2, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, new Dimension(100, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iOkButton = sSButton = new SSButton();
        sSButton.setIconName("");
        ((Component)sSButton).setEnabled(true);
        sSButton.setFocusTraversalPolicyProvider(false);
        this.$$$loadButtonText$$$(sSButton, ResourceBundle.getBundle("book").getString("okcancelpanel.okbutton"));
        jPanel3.add((Component)sSButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(100, -1), new Dimension(-1, 28)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

