/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.order;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceDialog;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceFrame;
import se.swedsoft.bookkeeping.gui.order.panel.SSOrderPanel;
import se.swedsoft.bookkeeping.gui.order.util.SSOrderTableModel;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceDialog;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSOrderDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSOrderDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final SSOrderTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("orderframe.new.title"));
        final SSOrderPanel iPanel = new SSOrderPanel(iDialog);
        iPanel.setOrder(new SSOrder());
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().addOrder(iOrder);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSOrderMath.addCustomerAndProducts(iOrder);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(final SSMainFrame iMainFrame, final SSTender iTender, final AbstractTableModel iModel) {
        final String lockString = "tendertoorder" + iTender.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "orderframe.tendertoorderopen", iTender.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("orderframe.new.title"));
        final SSOrderPanel iPanel = new SSOrderPanel(iDialog);
        SSOrder iOrder = new SSOrder(iTender);
        iOrder.setPrinted(false);
        iPanel.setOrder(iOrder);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().addOrder(iOrder);
                iTender.setOrder(iOrder);
                SSDB.getInstance().updateTender(iTender);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSOrderMath.addCustomerAndProducts(iOrder);
                }
                if (iModel != null) {
                    iModel.fireTableDataChanged();
                }
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSOrder iOrder, SSOrderTableModel pModel) {
        final String lockString = "order" + iOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "orderframe.orderopen", iOrder.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("orderframe.edit.title"));
        final SSOrderPanel iPanel = new SSOrderPanel(iDialog);
        iPanel.setOrder(new SSOrder(iOrder));
        iPanel.setSavecustomerandproductsSelected(false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().updateOrder(iOrder);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSOrderMath.addCustomerAndProducts(iOrder);
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSOrder iOrder, final SSOrderTableModel pModel) {
        String lockString = "order" + iOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "orderframe.orderopen", iOrder.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("orderframe.copy.title"));
        final SSOrderPanel iPanel = new SSOrderPanel(iDialog);
        SSOrder iNew = new SSOrder(iOrder);
        iNew.setNumber(null);
        iNew.setDate(new Date());
        iNew.setInvoice(null);
        iNew.setPurchaseOrder(null);
        iNew.setPrinted(false);
        iPanel.setOrder(iNew);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iOrder = iPanel.getOrder();
                iOrder.doAutoIncrecement();
                SSDB.getInstance().addOrder(iOrder);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSOrderMath.addCustomerAndProducts(iOrder);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void invoiceDialog(SSMainFrame iMainFrame, List<SSOrder> iOrders, SSOrderTableModel iModel) {
        SSCustomer iCustomer = iOrders.get(0).getCustomer();
        if (iOrders.size() > 1) {
            if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.createcollectioninvoice", iCustomer.getNumber()) != 0) {
                return;
            }
            iOrders = SSOrderMath.getOrdersByCustomerNr(iOrders, iCustomer.getNumber());
        }
        SSInvoice iInvoice = new SSInvoice(iOrders.get(0));
        iInvoice.setDate(new Date());
        iInvoice.setNumber(null);
        for (SSOrder iCurrent : iOrders) {
            if (iCurrent.getInvoiceNr() != null || iCurrent.getPeriodicInvoiceNr() != null) {
                SSInformationDialog.showDialog(iMainFrame, "orderframe.orderhasinvoice", iCurrent.getNumber());
                return;
            }
            iInvoice.append(iCurrent);
        }
        iInvoice.setOrderNumers(iOrders);
        if (SSInvoiceFrame.getInstance() != null) {
            SSInvoiceDialog.newDialog(iMainFrame, iInvoice, iOrders, SSInvoiceFrame.getInstance().getModel());
        } else {
            SSInvoiceDialog.newDialog(iMainFrame, iInvoice, iOrders, null);
        }
    }

    public static void cashReceiptDialog(SSMainFrame iMainFrame, List<SSOrder> iOrders, SSOrderTableModel iModel) {
        SSCustomer iCustomer = iOrders.get(0).getCustomer();
        if (iOrders.size() > 1) {
            if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.createcollectioninvoice", iCustomer.getNumber()) != 0) {
                return;
            }
            iOrders = SSOrderMath.getOrdersByCustomerNr(iOrders, iCustomer.getNumber());
        }
        SSInvoice iInvoice = new SSInvoice(iOrders.get(0));
        iInvoice.setDate(new Date());
        iInvoice.setNumber(null);
        iInvoice.setType(SSInvoiceType.CASH);
        for (SSOrder iCurrent : iOrders) {
            if (iCurrent.getInvoiceNr() != null || iCurrent.getPeriodicInvoiceNr() != null) {
                SSInformationDialog.showDialog(iMainFrame, "orderframe.orderhasinvoice", iCurrent.getNumber());
                return;
            }
            iInvoice.append(iCurrent);
        }
        iInvoice.setOrderNumers(iOrders);
        if (SSInvoiceFrame.getInstance() != null) {
            SSInvoiceDialog.newDialog(iMainFrame, iInvoice, iOrders, SSInvoiceFrame.getInstance().getModel());
        } else {
            SSInvoiceDialog.newDialog(iMainFrame, iInvoice, iOrders, null);
        }
    }

    public static void periodicInvoiceDialog(SSMainFrame iMainFrame, List<SSOrder> iOrders, SSOrderTableModel iModel) {
        SSCustomer iCustomer = iOrders.get(0).getCustomer();
        if (iOrders.size() > 1) {
            if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "orderframe.createcollectioninvoice", iCustomer.getNumber()) != 0) {
                return;
            }
            iOrders = SSOrderMath.getOrdersByCustomerNr(iOrders, iCustomer.getNumber());
        }
        SSInvoice iInvoice = new SSInvoice(iOrders.get(0));
        iInvoice.setDate(new Date());
        iInvoice.setNumber(null);
        for (SSOrder iCurrent : iOrders) {
            if (iCurrent.getInvoiceNr() != null || iCurrent.getPeriodicInvoiceNr() != null) {
                SSInformationDialog.showDialog(iMainFrame, "orderframe.orderhasinvoice", iCurrent.getNumber());
                return;
            }
            iInvoice.append(iCurrent);
        }
        iInvoice.setOrderNumers(iOrders);
        iInvoice.setPaymentTerm(iOrders.get(0).getPaymentTerm());
        iInvoice.setDeliveryTerm(iOrders.get(0).getDeliveryTerm());
        iInvoice.setDeliveryWay(iOrders.get(0).getDeliveryWay());
        iInvoice.setCurrency(iOrders.get(0).getCurrency());
        iInvoice.setCurrencyRate(iOrders.get(0).getCurrencyRate());
        SSPeriodicInvoice iPeriodicInvoice = new SSPeriodicInvoice();
        iPeriodicInvoice.setTemplate(iInvoice);
        if (SSPeriodicInvoiceFrame.getInstance() != null) {
            SSPeriodicInvoiceDialog.newDialog(iMainFrame, SSPeriodicInvoiceFrame.getInstance().getModel(), iPeriodicInvoice, iOrders);
        } else {
            SSPeriodicInvoiceDialog.newDialog(iMainFrame, null, iPeriodicInvoice, iOrders);
        }
    }
}

