/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.outdelivery.util;

import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSOutdeliveryMath;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSOutdeliveryTableModel
extends SSTableModel<SSOutdelivery> {
    public static SSTableColumn<SSOutdelivery> COLUMN_NUMBER = new SSTableColumn<SSOutdelivery>(SSBundle.getBundle().getString("outdeliverytable.column.1")){

        @Override
        public Object getValue(SSOutdelivery iIndelivery) {
            return iIndelivery.getNumber();
        }

        @Override
        public void setValue(SSOutdelivery iInvoice, Object iValue) {
            iInvoice.setNumber((Integer)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 70;
        }
    };
    public static SSTableColumn<SSOutdelivery> COLUMN_DATE = new SSTableColumn<SSOutdelivery>(SSBundle.getBundle().getString("outdeliverytable.column.2")){

        @Override
        public Object getValue(SSOutdelivery iIndelivery) {
            return iIndelivery.getDate();
        }

        @Override
        public void setValue(SSOutdelivery iIndelivery, Object iValue) {
            iIndelivery.setDate((Date)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };
    public static SSTableColumn<SSOutdelivery> COLUMN_TEXT = new SSTableColumn<SSOutdelivery>(SSBundle.getBundle().getString("outdeliverytable.column.3")){

        @Override
        public Object getValue(SSOutdelivery iIndelivery) {
            return iIndelivery.getText();
        }

        @Override
        public void setValue(SSOutdelivery iIndelivery, Object iValue) {
            iIndelivery.setText((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 400;
        }
    };
    public static SSTableColumn<SSOutdelivery> COLUMN_TOTALCOUNT = new SSTableColumn<SSOutdelivery>(SSBundle.getBundle().getString("outdeliverytable.column.4")){

        @Override
        public Object getValue(SSOutdelivery iIndelivery) {
            return SSOutdeliveryMath.getTotalCount(iIndelivery);
        }

        @Override
        public void setValue(SSOutdelivery iIndelivery, Object iValue) {
            iIndelivery.setText((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 120;
        }
    };

    public SSOutdeliveryTableModel() {
        super(SSDB.getInstance().getOutdeliveries());
    }

    public SSOutdeliveryTableModel(List<SSOutdelivery> iIndeliveries) {
        super(iIndeliveries);
    }

    @Override
    public Class getType() {
        return SSOutdelivery.class;
    }
}

