/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.outpayment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentDialog;
import se.swedsoft.bookkeeping.gui.outpayment.panel.SSOutpaymentSearchPanel;
import se.swedsoft.bookkeeping.gui.outpayment.util.SSOutpaymentTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSOutpaymentFrame
extends SSDefaultTableFrame {
    private static SSOutpaymentFrame cInstance;
    private SSTable iTable;
    private SSOutpaymentTableModel iModel;
    private SSOutpaymentSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSOutpaymentFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSOutpaymentFrame getInstance() {
        return cInstance;
    }

    private SSOutpaymentFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("outpaymentframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "outpaymentframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutpaymentDialog.newDialog(SSOutpaymentFrame.this.getMainFrame(), SSOutpaymentFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "outpaymentframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutpayment iSelected = (SSOutpayment)SSOutpaymentFrame.this.iModel.getSelectedRow(SSOutpaymentFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSOutpaymentFrame.this.getOutpayment(iSelected);
                }
                if (iSelected != null) {
                    SSOutpaymentDialog.editDialog(SSOutpaymentFrame.this.getMainFrame(), iSelected, SSOutpaymentFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOutpaymentFrame.this.getMainFrame(), "outpaymentframe.outpaymentgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "outpaymentframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSOutpaymentFrame.this.iTable.getSelectedRows();
                List toDelete = SSOutpaymentFrame.this.iModel.getObjects(selected);
                SSOutpaymentFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "outpaymentframe.printbutton");
        iMenuButton.add("outpaymentframe.print.outaymentlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.OutpaymentList(SSOutpaymentFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSOutpaymentTableModel();
        this.iModel.addColumn(SSOutpaymentTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSOutpaymentTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSOutpaymentTableModel.COLUMN_TEXT);
        this.iModel.addColumn(SSOutpaymentTableModel.COLUMN_SUM);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutpayment iSelected = (SSOutpayment)SSOutpaymentFrame.this.iModel.getSelectedRow(SSOutpaymentFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSOutpaymentFrame.this.getOutpayment(iSelected);
                if (iSelected != null) {
                    SSOutpaymentDialog.editDialog(SSOutpaymentFrame.this.getMainFrame(), iSelected, SSOutpaymentFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOutpaymentFrame.this.getMainFrame(), "outpaymentframe.outpaymentgone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSOutpaymentSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSTableModel<SSOutpayment> getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelected(List<SSOutpayment> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "outpaymentframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSOutpayment iOutpayment : delete) {
                if (SSPostLock.isLocked("outpayment" + iOutpayment.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "outpaymentframe.outpaymentopen", iOutpayment.getNumber());
                    continue;
                }
                for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                    if (iRow.getValue() == null || iRow.getInvoiceNr() == null || !SSSupplierInvoiceMath.iSaldoMap.containsKey(iRow.getInvoiceNr())) continue;
                    SSSupplierInvoiceMath.iSaldoMap.put(iRow.getInvoiceNr(), SSSupplierInvoiceMath.iSaldoMap.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                }
                SSDB.getInstance().deleteOutpayment(iOutpayment);
            }
        }
    }

    private SSOutpayment getOutpayment(SSOutpayment iOutpayment) {
        return SSDB.getInstance().getOutpayment(iOutpayment);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

