/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.ownreport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.ownreport.SSOwnReportDialog;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSOwnReportFrame
extends SSDefaultTableFrame {
    private static SSOwnReportFrame cInstance;
    private SSTable iTable;
    private SSOwnReportTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSOwnReportFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSOwnReportFrame getInstance() {
        return cInstance;
    }

    private SSOwnReportFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("ownreportframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "ownreportframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOwnReportDialog.newDialog(SSOwnReportFrame.this.getMainFrame());
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "ownreportframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOwnReport iSelected = (SSOwnReport)SSOwnReportFrame.this.iModel.getSelectedRow(SSOwnReportFrame.this.iTable);
                String iName = null;
                if (iSelected != null) {
                    iName = iSelected.getName();
                    iSelected = SSOwnReportFrame.this.getOwnReport(iSelected);
                }
                if (iSelected != null) {
                    SSOwnReportDialog.editDialog(SSOwnReportFrame.this.getMainFrame(), iSelected);
                } else {
                    new SSErrorDialog(SSOwnReportFrame.this.getMainFrame(), "ownreportframe.ownreportgone", iName);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "ownreportframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSOwnReportFrame.this.iTable.getSelectedRows();
                List toDelete = SSOwnReportFrame.this.iModel.getObjects(selected);
                SSOwnReportFrame.this.deleteSelectedOwnReport(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_PRINT", "ownreportframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOwnReport iSelected = (SSOwnReport)SSOwnReportFrame.this.iModel.getSelectedRow(SSOwnReportFrame.this.iTable);
                String iName = null;
                if (iSelected != null) {
                    iName = iSelected.getName();
                    iSelected = SSOwnReportFrame.this.getOwnReport(iSelected);
                }
                if (iSelected != null) {
                    SSReportFactory.buildOwnReport(SSOwnReportFrame.this.getMainFrame(), iSelected);
                } else {
                    new SSErrorDialog(SSOwnReportFrame.this.getMainFrame(), "ownreportframe.ownreportgone", iName);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSOwnReportTableModel();
        this.iModel.addColumn(SSOwnReportTableModel.COLUMN_NAME);
        this.iModel.addColumn(SSOwnReportTableModel.COLUMN_PROJECT);
        this.iModel.addColumn(SSOwnReportTableModel.COLUMN_RESULTUNIT);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOwnReport iSelected = (SSOwnReport)SSOwnReportFrame.this.iModel.getSelectedRow(SSOwnReportFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                String iName = iSelected.getName();
                iSelected = SSOwnReportFrame.this.getOwnReport(iSelected);
                if (iSelected != null) {
                    SSOwnReportDialog.editDialog(SSOwnReportFrame.this.getMainFrame(), iSelected);
                } else {
                    new SSErrorDialog(SSOwnReportFrame.this.getMainFrame(), "ownreportframe.ownreportgone", iName);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSTableModel<SSOwnReport> getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelectedOwnReport(List<SSOwnReport> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "ownreportframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSOwnReport iOwnReport : delete) {
                if (SSPostLock.isLocked("ownreport" + iOwnReport.getId() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "ownreportframe.ownreportopen", iOwnReport.getName());
                    continue;
                }
                SSDB.getInstance().deleteOwnReport(iOwnReport);
            }
        }
    }

    private SSOwnReport getOwnReport(SSOwnReport iOwnReport) {
        return SSDB.getInstance().getOwnReport(iOwnReport);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getOwnReports());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.ownreport.SSOwnReportFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

